/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VariableDeclaration;
import de.uni_koblenz.jgralab.greql.evaluator.VertexCosts;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VariableEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.IsDeclaredVarOf;
import de.uni_koblenz.jgralab.greql.schema.IsTypeExprOf;
import de.uni_koblenz.jgralab.greql.schema.SimpleDeclaration;
import java.util.HashSet;
import org.pcollections.PVector;

public class SimpleDeclarationEvaluator
extends VertexEvaluator<SimpleDeclaration> {
    public SimpleDeclarationEvaluator(SimpleDeclaration vertex, GreqlQueryImpl query) {
        super(vertex, query);
    }

    @Override
    public PVector<VariableDeclaration> evaluate(InternalGreqlEvaluator evaluator) {
        evaluator.progress(this.getOwnEvaluationCosts());
        IsTypeExprOf inc = ((SimpleDeclaration)this.vertex).getFirstIsTypeExprOfIncidence(EdgeDirection.IN);
        Expression typeExpression = inc.getAlpha();
        VertexEvaluator<Expression> exprEval = this.query.getVertexEvaluator(typeExpression);
        PVector<VariableDeclaration> varDeclList = JGraLab.vector();
        for (IsDeclaredVarOf varInc = ((SimpleDeclaration)this.vertex).getFirstIsDeclaredVarOfIncidence(EdgeDirection.IN); varInc != null; varInc = varInc.getNextIsDeclaredVarOfIncidence(EdgeDirection.IN)) {
            VariableDeclaration varDecl = new VariableDeclaration(varInc.getAlpha(), exprEval, (VariableEvaluator)this.query.getVertexEvaluator(varInc.getAlpha()));
            varDeclList = varDeclList.plus(varDecl);
        }
        return varDeclList;
    }

    @Override
    public VertexCosts calculateSubtreeEvaluationCosts() {
        SimpleDeclaration simpleDecl = (SimpleDeclaration)this.getVertex();
        VertexEvaluator<Expression> typeExprEval = this.query.getVertexEvaluator(simpleDecl.getFirstIsTypeExprOfIncidence().getAlpha());
        long typeCosts = typeExprEval.getCurrentSubtreeEvaluationCosts();
        long declaredVarCosts = 0L;
        for (IsDeclaredVarOf inc = simpleDecl.getFirstIsDeclaredVarOfIncidence(EdgeDirection.IN); inc != null; inc = inc.getNextIsDeclaredVarOfIncidence(EdgeDirection.IN)) {
            VariableEvaluator varEval = (VariableEvaluator)this.query.getVertexEvaluator(inc.getAlpha());
            declaredVarCosts += varEval.getCurrentSubtreeEvaluationCosts();
        }
        long ownCosts = 2L;
        long iteratedCosts = ownCosts * this.getVariableCombinations();
        long subtreeCosts = iteratedCosts + declaredVarCosts + typeCosts;
        return new VertexCosts(ownCosts, iteratedCosts, subtreeCosts);
    }

    @Override
    public void calculateNeededAndDefinedVariables() {
        VertexEvaluator<Expression> veval;
        this.neededVariables = new HashSet();
        this.definedVariables = new HashSet();
        for (IsDeclaredVarOf varInc = ((SimpleDeclaration)this.vertex).getFirstIsDeclaredVarOfIncidence(EdgeDirection.IN); varInc != null; varInc = varInc.getNextIsDeclaredVarOfIncidence(EdgeDirection.IN)) {
            this.definedVariables.add(varInc.getAlpha());
        }
        IsTypeExprOf typeInc = ((SimpleDeclaration)this.vertex).getFirstIsTypeExprOfIncidence(EdgeDirection.IN);
        if (typeInc != null && (veval = this.query.getVertexEvaluator(typeInc.getAlpha())) != null) {
            this.neededVariables.addAll(veval.getNeededVariables());
        }
    }

    @Override
    public long calculateEstimatedCardinality() {
        SimpleDeclaration decl = (SimpleDeclaration)this.getVertex();
        VertexEvaluator<Expression> typeExprEval = this.query.getVertexEvaluator(decl.getFirstIsTypeExprOfIncidence(EdgeDirection.IN).getAlpha());
        long singleCardinality = typeExprEval.getEstimatedCardinality();
        long wholeCardinality = singleCardinality * (long)this.getDefinedVariables().size();
        return wholeCardinality;
    }
}

