/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VertexCosts;
import de.uni_koblenz.jgralab.greql.evaluator.fa.NFA;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.EdgeRestrictionEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.PrimaryPathDescriptionEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.exception.UnknownTypeException;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.IsEdgeRestrOf;
import de.uni_koblenz.jgralab.greql.schema.PrimaryPathDescription;
import de.uni_koblenz.jgralab.greql.schema.SimplePathDescription;
import de.uni_koblenz.jgralab.greql.types.TypeCollection;

public class SimplePathDescriptionEvaluator
extends PrimaryPathDescriptionEvaluator<SimplePathDescription> {
    public SimplePathDescriptionEvaluator(SimplePathDescription vertex, GreqlQueryImpl query) {
        super(vertex, query);
    }

    @Override
    public NFA evaluate(InternalGreqlEvaluator evaluator) {
        evaluator.progress(this.getOwnEvaluationCosts());
        TypeCollection typeCollection = TypeCollection.empty();
        EdgeRestrictionEvaluator edgeRestEval = null;
        VertexEvaluator<? extends Expression> predicateEvaluator = null;
        for (IsEdgeRestrOf inc : ((SimplePathDescription)this.vertex).getIsEdgeRestrOfIncidences(EdgeDirection.IN)) {
            edgeRestEval = (EdgeRestrictionEvaluator)this.query.getVertexEvaluator(inc.getAlpha());
            typeCollection = typeCollection.combine(edgeRestEval.getTypeCollection(evaluator));
            predicateEvaluator = edgeRestEval.getPredicateEvaluator();
        }
        try {
            typeCollection = typeCollection.bindToSchema(evaluator);
        }
        catch (UnknownTypeException e) {
            throw new UnknownTypeException(e.getTypeName(), this.createPossibleSourcePositions());
        }
        NFA createdNFA = NFA.createSimplePathDescriptionNFA(this.getEdgeDirection((PrimaryPathDescription)this.vertex), typeCollection, this.getEdgeRoles(edgeRestEval), predicateEvaluator, this.query);
        evaluator.setLocalEvaluationResult(this.vertex, createdNFA);
        return createdNFA;
    }

    @Override
    public VertexCosts calculateSubtreeEvaluationCosts() {
        return new VertexCosts(10L, 10L, 10L);
    }
}

