/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.TraversalContext;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VertexCosts;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.SubgraphDefinitionEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.IsExpressionOnSubgraph;
import de.uni_koblenz.jgralab.greql.schema.IsSubgraphDefinitionOf;
import de.uni_koblenz.jgralab.greql.schema.SubgraphDefinition;
import de.uni_koblenz.jgralab.greql.schema.SubgraphRestrictedExpression;

public class SubgraphRestrictedExpressionEvaluator
extends VertexEvaluator<SubgraphRestrictedExpression> {
    SubgraphDefinitionEvaluator<?> subgraphDefinitionEval;
    VertexEvaluator<? extends Expression> exprEval;

    public SubgraphRestrictedExpressionEvaluator(SubgraphRestrictedExpression vertex, GreqlQueryImpl query) {
        super(vertex, query);
    }

    @Override
    public Object evaluate(InternalGreqlEvaluator evaluator) {
        evaluator.progress(this.getOwnEvaluationCosts());
        if (this.subgraphDefinitionEval == null) {
            IsSubgraphDefinitionOf isSubgraphDef = ((SubgraphRestrictedExpression)this.vertex).getFirstIsSubgraphDefinitionOfIncidence(EdgeDirection.IN);
            SubgraphDefinition defVertex = (SubgraphDefinition)isSubgraphDef.getThat();
            this.subgraphDefinitionEval = (SubgraphDefinitionEvaluator)this.query.getVertexEvaluator(defVertex);
        }
        TraversalContext subgraph = (TraversalContext)this.subgraphDefinitionEval.getResult(evaluator);
        if (this.exprEval == null) {
            IsExpressionOnSubgraph isExprOn = ((SubgraphRestrictedExpression)this.vertex).getFirstIsExpressionOnSubgraphIncidence(EdgeDirection.IN);
            Expression expr = (Expression)isExprOn.getThat();
            this.exprEval = this.query.getVertexEvaluator(expr);
        }
        Graph graph = evaluator.getGraph();
        TraversalContext oldTraversalContext = graph.getTraversalContext();
        graph.setTraversalContext(subgraph);
        Object result = this.exprEval.getResult(evaluator);
        evaluator.setLocalEvaluationResult(this.vertex, result);
        graph.setTraversalContext(oldTraversalContext);
        return result;
    }

    @Override
    protected VertexCosts calculateSubtreeEvaluationCosts() {
        if (this.subgraphDefinitionEval == null) {
            IsSubgraphDefinitionOf isSubgraphDef = ((SubgraphRestrictedExpression)this.vertex).getFirstIsSubgraphDefinitionOfIncidence(EdgeDirection.IN);
            SubgraphDefinition defVertex = (SubgraphDefinition)isSubgraphDef.getThat();
            this.subgraphDefinitionEval = (SubgraphDefinitionEvaluator)this.query.getVertexEvaluator(defVertex);
        }
        if (this.exprEval == null) {
            IsExpressionOnSubgraph isExprOn = ((SubgraphRestrictedExpression)this.vertex).getFirstIsExpressionOnSubgraphIncidence(EdgeDirection.IN);
            Expression expr = (Expression)isExprOn.getThat();
            this.exprEval = this.query.getVertexEvaluator(expr);
        }
        long ownCosts = 10L;
        long iteratedCosts = ownCosts * this.getVariableCombinations();
        long subtree = this.subgraphDefinitionEval.getCurrentSubtreeEvaluationCosts() + this.exprEval.getCurrentSubtreeEvaluationCosts() + iteratedCosts;
        return new VertexCosts(ownCosts, iteratedCosts, subtree);
    }
}

