/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VertexCosts;
import de.uni_koblenz.jgralab.greql.evaluator.fa.NFA;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.PathDescriptionEvaluator;
import de.uni_koblenz.jgralab.greql.schema.PathDescription;
import de.uni_koblenz.jgralab.greql.schema.TransposedPathDescription;

public class TransposedPathDescriptionEvaluator
extends PathDescriptionEvaluator<TransposedPathDescription> {
    public TransposedPathDescriptionEvaluator(TransposedPathDescription vertex, GreqlQueryImpl query) {
        super(vertex, query);
    }

    @Override
    public NFA evaluate(InternalGreqlEvaluator evaluator) {
        evaluator.progress(this.getOwnEvaluationCosts());
        PathDescription p = ((TransposedPathDescription)this.vertex).getFirstIsTransposedPathOfIncidence(EdgeDirection.IN).getAlpha();
        PathDescriptionEvaluator pathEval = (PathDescriptionEvaluator)this.query.getVertexEvaluator(p);
        return NFA.createTransposedPathDescriptionNFA(pathEval.getNFA(evaluator));
    }

    @Override
    public VertexCosts calculateSubtreeEvaluationCosts() {
        TransposedPathDescription transPath = (TransposedPathDescription)this.getVertex();
        PathDescriptionEvaluator pathEval = (PathDescriptionEvaluator)this.query.getVertexEvaluator(transPath.getFirstIsTransposedPathOfIncidence().getAlpha());
        long pathCosts = pathEval.getCurrentSubtreeEvaluationCosts();
        long transpositionCosts = pathCosts / 20L;
        long subtreeCosts = transpositionCosts + pathCosts;
        return new VertexCosts(transpositionCosts, transpositionCosts, subtreeCosts);
    }
}

