/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.greql.OptimizerInfo;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VertexCosts;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.exception.UnknownTypeException;
import de.uni_koblenz.jgralab.greql.schema.TypeId;
import de.uni_koblenz.jgralab.greql.types.TypeCollection;

public class TypeIdEvaluator
extends VertexEvaluator<TypeId> {
    private TypeCollection tc;

    public TypeIdEvaluator(TypeId vertex, GreqlQueryImpl query) {
        super(vertex, query);
    }

    @Override
    public TypeCollection evaluate(InternalGreqlEvaluator evaluator) {
        if (this.tc == null) {
            this.tc = TypeCollection.empty().with(((TypeId)this.vertex).get_name(), ((TypeId)this.vertex).is_type(), ((TypeId)this.vertex).is_excluded());
        }
        try {
            this.tc = this.tc.bindToSchema(evaluator);
        }
        catch (UnknownTypeException e) {
            throw new UnknownTypeException(e.getTypeName(), this.createPossibleSourcePositions());
        }
        evaluator.progress(this.getOwnEvaluationCosts());
        return this.tc;
    }

    @Override
    public VertexCosts calculateSubtreeEvaluationCosts() {
        OptimizerInfo optimizerInfo = this.query.getOptimizer().getOptimizerInfo();
        long costs = optimizerInfo.getEdgeClassCount() + optimizerInfo.getVertexClassCount();
        return new VertexCosts(costs, costs, costs);
    }

    @Override
    public double calculateEstimatedSelectivity() {
        double selectivity;
        OptimizerInfo optimizerInfo = this.query.getOptimizer().getOptimizerInfo();
        if (this.tc != null) {
            selectivity = this.tc.getFrequency(optimizerInfo);
        } else {
            int typesInSchema = (int)Math.round((double)(optimizerInfo.getEdgeClassCount() + optimizerInfo.getVertexClassCount()) / 2.0);
            selectivity = 1.0;
            TypeId id = (TypeId)this.getVertex();
            if (id.is_type()) {
                selectivity = 1.0 / (double)typesInSchema;
            } else {
                double avgSubclasses = (optimizerInfo.getAverageEdgeSubclasses() + optimizerInfo.getAverageVertexSubclasses()) / 2.0;
                selectivity = avgSubclasses / (double)typesInSchema;
            }
            if (id.is_excluded()) {
                selectivity = 1.0 - selectivity;
            }
        }
        logger.fine("TypeId estimated selectivity " + this.tc + ": " + selectivity);
        return selectivity;
    }

    @Override
    public String getLoggingName() {
        StringBuilder name = new StringBuilder();
        name.append(((TypeId)this.vertex).getAttributedElementClass().getQualifiedName());
        if (((TypeId)this.vertex).is_type()) {
            name.append("-type");
        }
        if (((TypeId)this.vertex).is_excluded()) {
            name.append("-excluded");
        }
        return name.toString();
    }
}

