/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.evaluator.vertexeval;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.VertexCosts;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.DeclarationEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.PathDescriptionEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.SimpleDeclarationEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.schema.Declaration;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.GreqlAggregation;
import de.uni_koblenz.jgralab.greql.schema.GreqlVertex;
import de.uni_koblenz.jgralab.greql.schema.IsDeclaredVarOf;
import de.uni_koblenz.jgralab.greql.schema.SimpleDeclaration;
import de.uni_koblenz.jgralab.greql.schema.Variable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class VariableEvaluator<V extends Variable>
extends VertexEvaluator<V> {
    private List<VertexEvaluator<? extends Expression>> dependingExpressions;
    private long estimatedAssignments = Long.MIN_VALUE;

    public void setValue(Object variableValue, InternalGreqlEvaluator evaluator) {
        if (this.dependingExpressions == null) {
            this.dependingExpressions = this.calculateDependingExpressions();
        }
        int size = this.dependingExpressions.size();
        for (int i = 0; i < size; ++i) {
            this.dependingExpressions.get(i).clear(evaluator);
        }
        evaluator.setLocalEvaluationResult(this.vertex, variableValue);
    }

    public Object getValue(InternalGreqlEvaluator evaluator) {
        return evaluator.getLocalEvaluationResult(this.vertex);
    }

    public VariableEvaluator(V vertex, GreqlQueryImpl query) {
        super(vertex, query);
    }

    @Override
    public Object evaluate(InternalGreqlEvaluator evaluator) {
        evaluator.progress(this.getOwnEvaluationCosts());
        return this.getValue(evaluator);
    }

    @Override
    public Object getResult(InternalGreqlEvaluator evaluator) {
        return this.getValue(evaluator);
    }

    @Override
    public Set<Variable> getNeededVariables() {
        if (this.neededVariables == null) {
            this.neededVariables = new HashSet();
            this.neededVariables.add(this.vertex);
        }
        return this.neededVariables;
    }

    @Override
    public Set<Variable> getDefinedVariables() {
        if (this.definedVariables == null) {
            this.definedVariables = new HashSet();
        }
        return this.definedVariables;
    }

    public List<VertexEvaluator<? extends Expression>> calculateDependingExpressions() {
        LinkedList<GreqlVertex> queue = new LinkedList<GreqlVertex>();
        ArrayList<VertexEvaluator<? extends Expression>> dependingEvaluators = new ArrayList<VertexEvaluator<? extends Expression>>();
        ArrayList<Vertex> forbiddenVertices = new ArrayList<Vertex>();
        SimpleDeclaration simpleDecl = null;
        if (((Variable)this.vertex).getFirstIsDeclaredVarOfIncidence(EdgeDirection.OUT) != null) {
            simpleDecl = (SimpleDeclaration)((Variable)this.vertex).getFirstIsDeclaredVarOfIncidence(EdgeDirection.OUT).getThat();
        }
        if (simpleDecl != null) {
            forbiddenVertices.add(simpleDecl);
            Declaration declaringVertex = (Declaration)simpleDecl.getFirstIsSimpleDeclOfIncidence().getThat();
            if (declaringVertex.getFirstIsCompDeclOfIncidence(EdgeDirection.OUT) != null) {
                forbiddenVertices.add(declaringVertex.getFirstIsCompDeclOfIncidence(EdgeDirection.OUT).getThat());
            } else {
                forbiddenVertices.add(declaringVertex.getFirstIsQuantifiedDeclOfIncidence(EdgeDirection.OUT).getThat());
            }
        }
        queue.add(this.vertex);
        while (!queue.isEmpty()) {
            GreqlVertex currentVertex = (GreqlVertex)queue.poll();
            VertexEvaluator<GreqlVertex> eval = this.query.getVertexEvaluator(currentVertex);
            if (!(eval == null || dependingEvaluators.contains(eval) || eval instanceof PathDescriptionEvaluator || eval instanceof DeclarationEvaluator || eval instanceof SimpleDeclarationEvaluator)) {
                dependingEvaluators.add(eval);
            }
            for (GreqlAggregation currentEdge = currentVertex.getFirstGreqlAggregationIncidence(EdgeDirection.OUT); currentEdge != null; currentEdge = currentEdge.getNextGreqlAggregationIncidence(EdgeDirection.OUT)) {
                GreqlVertex nextVertex = (GreqlVertex)currentEdge.getThat();
                if (forbiddenVertices.contains(nextVertex)) continue;
                queue.add(nextVertex);
            }
        }
        return dependingEvaluators;
    }

    @Override
    public void calculateNeededAndDefinedVariables() {
    }

    @Override
    public long getVariableCombinations() {
        if (this.estimatedAssignments == Long.MIN_VALUE) {
            this.estimatedAssignments = this.calculateEstimatedAssignments();
        }
        return this.estimatedAssignments;
    }

    public long calculateEstimatedAssignments() {
        Variable v = (Variable)this.getVertex();
        IsDeclaredVarOf inc = v.getFirstIsDeclaredVarOfIncidence();
        if (inc != null) {
            SimpleDeclaration decl = inc.getOmega();
            VertexEvaluator<Expression> typeExpEval = this.query.getVertexEvaluator(decl.getFirstIsTypeExprOfIncidence().getAlpha());
            return typeExpEval.getEstimatedCardinality();
        }
        return 1L;
    }

    @Override
    public VertexCosts calculateSubtreeEvaluationCosts() {
        return new VertexCosts(1L, 1L, 1L);
    }
}

