/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.exception;

import de.uni_koblenz.jgralab.greql.exception.GreqlException;

public class ParsingException
extends GreqlException {
    private static final long serialVersionUID = 894099164202915776L;
    private String errorMessage;
    private String tokenString;
    private int offset;
    private int length;

    public ParsingException(String msg, String token, int offset, int length, String query) {
        super("Parsing error: " + msg + " '" + token + "' at position (" + offset + "," + length + ")");
        this.errorMessage = msg;
        this.tokenString = token;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        return this;
    }

    private static String surrounding(String query, int off, int len) {
        int ol;
        int e;
        if (len < 0 || off < 0) {
            return "";
        }
        int s = off - 20;
        if (s < 0) {
            s = 0;
        }
        if ((e = off + len + 20) > query.length()) {
            e = query.length();
        }
        if ((ol = off + len) > query.length()) {
            ol = query.length();
        }
        String start = query.substring(s, off);
        String problematicPart = query.substring(off, ol);
        String end = query.substring(ol, e);
        return start + "\u2039" + problematicPart + "\u203a" + end;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getToken() {
        return this.tokenString;
    }
}

