/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.collections;

import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import de.uni_koblenz.jgralab.greql.types.Table;
import de.uni_koblenz.jgralab.greql.types.Tuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.pcollections.PCollection;
import org.pcollections.PVector;

public class SortByColumn
extends Function {
    @Description(params={"column", "t"}, description="Sorts a table of tuples by one column.", categories={Function.Category.COLLECTIONS_AND_MAPS})
    public Table<Tuple> evaluate(Integer column, Table<Tuple> t) {
        return this.evaluate(JGraLab.vector().plus(column), t);
    }

    @Description(params={"columns", "t"}, description="Sorts a table of tuples by many columns.", categories={Function.Category.COLLECTIONS_AND_MAPS})
    public Table<Tuple> evaluate(PVector<Integer> columns, Table<Tuple> t) {
        Table result = Table.empty();
        return result.withTitles(t.getTitles()).plusAll(this.evaluate(columns, t.toPVector()));
    }

    @Description(params={"column", "l"}, description="Sorts a collection of tuples by one column.", categories={Function.Category.COLLECTIONS_AND_MAPS})
    public PVector<Tuple> evaluate(Integer column, PCollection<Tuple> l) {
        return this.evaluate(JGraLab.vector().plus(column), l);
    }

    @Description(params={"columns", "l"}, description="Sorts a collection of tuples by many columns.", categories={Function.Category.COLLECTIONS_AND_MAPS})
    public PVector<Tuple> evaluate(PVector<Integer> columns, PCollection<Tuple> l) {
        if (columns.isEmpty()) {
            throw new IllegalArgumentException("Parameter columns must contain at least one column number.");
        }
        if (l.isEmpty()) {
            return JGraLab.vector();
        }
        Tuple[] sorted = new Tuple[l.size()];
        l.toArray(sorted);
        Arrays.sort(sorted, new TupleComparator(columns));
        PVector<Tuple> result = JGraLab.vector();
        for (Tuple x : sorted) {
            result = result.plus(x);
        }
        return result;
    }

    @Override
    public long getEstimatedCosts(ArrayList<Long> inElements) {
        long n = inElements.get(0);
        return (long)((double)(2L * n) * Math.log(n));
    }

    @Override
    public long getEstimatedCardinality(int inElements) {
        return inElements;
    }

    private static class TupleComparator
    implements Comparator<Tuple> {
        PVector<Integer> cols;

        TupleComparator(PVector<Integer> columns) {
            this.cols = columns;
        }

        @Override
        public int compare(Tuple t0, Tuple t1) {
            int l = this.cols.size();
            int result = 0;
            for (int i = 0; i < l && result == 0; ++i) {
                int c = (Integer)this.cols.get(i);
                Comparable c0 = (Comparable)t0.get(c);
                Comparable c1 = (Comparable)t1.get(c);
                result = c0.compareTo(c1);
            }
            return result;
        }
    }
}

