/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.graph;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.graphmarker.BooleanGraphMarker;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.fa.DFA;
import de.uni_koblenz.jgralab.greql.evaluator.fa.State;
import de.uni_koblenz.jgralab.greql.evaluator.fa.Transition;
import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import de.uni_koblenz.jgralab.greql.funlib.NeedsEvaluatorArgument;
import de.uni_koblenz.jgralab.greql.types.pathsearch.PathSearchQueueEntry;
import java.util.LinkedList;

@NeedsEvaluatorArgument
public class IsReachable
extends Function {
    public static boolean PRINT_STOP_VERTICES = false;

    @Description(params={"internal", "u", "v", "dfa"}, description="Returns true, iff there is a path from vertex given as first argument to vertex given as second argument that matches the path description given as second argument. Usually invoked like so: myVertex (--> | <>--)+ myOtherVertex.", categories={Function.Category.GRAPH, Function.Category.PATHS_AND_PATHSYSTEMS_AND_SLICES})
    public IsReachable() {
        super(50L, 1L, 0.01);
    }

    public Boolean evaluate(InternalGreqlEvaluator evaluator, Vertex u, Vertex v, DFA dfa) {
        if (u.getGraph() != v.getGraph()) {
            throw new IllegalArgumentException("The vertices are in different graphs, but must be in the same graph.");
        }
        BooleanGraphMarker[] markers = new BooleanGraphMarker[dfa.stateList.size()];
        for (State s : dfa.stateList) {
            markers[s.number] = new BooleanGraphMarker(u.getGraph());
        }
        LinkedList<PathSearchQueueEntry> queue = new LinkedList<PathSearchQueueEntry>();
        PathSearchQueueEntry currentEntry = new PathSearchQueueEntry(u, dfa.initialState);
        markers[currentEntry.state.number].mark(currentEntry.vertex);
        queue.add(currentEntry);
        while (!queue.isEmpty()) {
            currentEntry = (PathSearchQueueEntry)queue.poll();
            if (currentEntry.vertex == v && currentEntry.state.isFinal) {
                return true;
            }
            for (Edge inc : currentEntry.vertex.incidences()) {
                for (Transition currentTransition : currentEntry.state.outTransitions) {
                    Vertex nextVertex = currentTransition.getNextVertex(currentEntry.vertex, inc);
                    boolean isMarked = markers[currentTransition.endState.number].isMarked(nextVertex);
                    boolean transitionIsPossible = currentTransition.accepts(currentEntry.vertex, inc, evaluator);
                    if (isMarked || !transitionIsPossible) continue;
                    PathSearchQueueEntry nextEntry = new PathSearchQueueEntry(nextVertex, currentTransition.endState);
                    markers[nextEntry.state.number].mark(nextVertex);
                    queue.add(nextEntry);
                }
            }
        }
        return false;
    }
}

