/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.graph;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import de.uni_koblenz.jgralab.greql.types.TypeCollection;

public class NextGraphElement
extends Function {
    public NextGraphElement() {
        super(2L, 1L, 1.0);
    }

    @Description(params={"e"}, description="Returns the next edge for a given element from the incidence sequence.", categories={Function.Category.GRAPH})
    public Edge evaluate(Edge e) {
        return e.getNextIncidence();
    }

    @Description(params={"e", "global"}, description="Returns the next edge for a given element. The boolean parameter $global$ decides if successor is taken from the global edge sequence (true), or from the incidence sequence (false).", categories={Function.Category.GRAPH})
    public Edge evaluate(Edge e, Boolean global) {
        return global != false ? e.getNextEdge() : e.getNextIncidence();
    }

    @Description(params={"e", "global", "tc"}, description="Returns the next edge for a given element, restricted by a type collection. The boolean parameter $global$ decides if successor is taken from the global edge sequence (true), or from the incidence sequence (false).", categories={Function.Category.GRAPH})
    public Edge evaluate(Edge e, Boolean global, TypeCollection tc) {
        if (global.booleanValue()) {
            for (Edge n = e.getNextEdge(); n != null; n = n.getNextEdge()) {
                if (!tc.acceptsType(n.getAttributedElementClass())) continue;
                return n;
            }
            return null;
        }
        return this.evaluate(e, tc);
    }

    @Description(params={"e", "tc"}, description="Returns the next edge for a given element, restricted by a type collection.", categories={Function.Category.GRAPH})
    public Edge evaluate(Edge e, TypeCollection tc) {
        for (Edge n = e.getNextIncidence(); n != null; n = n.getNextIncidence()) {
            if (!tc.acceptsType(n.getAttributedElementClass())) continue;
            return n;
        }
        return null;
    }

    @Description(params={"v"}, description="Returns the next vertex for a given element.", categories={Function.Category.GRAPH})
    public Vertex evaluate(Vertex v) {
        return v.getNextVertex();
    }

    @Description(params={"v", "tc"}, description="Returns the next vertex for a given element, restricted by a type collection.", categories={Function.Category.GRAPH})
    public Vertex evaluate(Vertex v, TypeCollection tc) {
        for (Vertex n = v.getNextVertex(); n != null; n = n.getNextVertex()) {
            if (!tc.acceptsType(n.getAttributedElementClass())) continue;
            return n;
        }
        return null;
    }
}

