/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.graph;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.evaluator.InternalGreqlEvaluator;
import de.uni_koblenz.jgralab.greql.evaluator.fa.DFA;
import de.uni_koblenz.jgralab.greql.evaluator.fa.State;
import de.uni_koblenz.jgralab.greql.evaluator.fa.Transition;
import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import de.uni_koblenz.jgralab.greql.funlib.NeedsEvaluatorArgument;
import de.uni_koblenz.jgralab.greql.types.pathsearch.VertexStateQueue;
import java.util.HashSet;
import org.pcollections.PSet;

@NeedsEvaluatorArgument
public class ReachableVertices
extends Function {
    @Description(params={"internal", "v", "dfa"}, description="Returns all vertices that are reachable from the given vertex by a path matching the the given path description.", categories={Function.Category.GRAPH, Function.Category.PATHS_AND_PATHSYSTEMS_AND_SLICES})
    public ReachableVertices() {
        super(100L, 10L, 1.0);
    }

    public PSet<Vertex> evaluate(InternalGreqlEvaluator evaluator, Vertex v, DFA dfa) {
        return ReachableVertices.search(evaluator, v, dfa);
    }

    public static PSet<Vertex> search(InternalGreqlEvaluator evaluator, Vertex v, DFA dfa) {
        PSet<Vertex> resultSet = JGraLab.set();
        HashSet[] markedElements = new HashSet[dfa.stateList.size()];
        for (State s : dfa.stateList) {
            markedElements[s.number] = new HashSet(100);
        }
        VertexStateQueue queue = new VertexStateQueue();
        markedElements[dfa.initialState.number].add(v);
        queue.put(v, dfa.initialState);
        while (queue.hasNext()) {
            Vertex vertex = queue.currentVertex;
            State state = queue.currentState;
            if (state.isFinal) {
                resultSet = resultSet.plus(vertex);
            }
            for (Edge inc = vertex.getFirstIncidence(); inc != null; inc = inc.getNextIncidence()) {
                int size = state.outTransitions.size();
                for (int i = 0; i < size; ++i) {
                    Transition currentTransition = state.outTransitions.get(i);
                    Vertex nextVertex = currentTransition.getNextVertex(vertex, inc);
                    if (markedElements[currentTransition.endState.number].contains(nextVertex) || !currentTransition.accepts(vertex, inc, evaluator)) continue;
                    markedElements[currentTransition.endState.number].add(nextVertex);
                    queue.put(nextVertex, currentTransition.endState);
                }
            }
        }
        return resultSet;
    }
}

