/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.graph.base;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.funlib.graph.base.EdgeDirectionFunction;
import de.uni_koblenz.jgralab.greql.types.TypeCollection;
import org.pcollections.PVector;

public abstract class IncidencesFunction
extends EdgeDirectionFunction {
    protected IncidencesFunction(EdgeDirection direction) {
        super(direction, 10L, 10L, 1.0);
    }

    protected PVector<Edge> evaluate(Vertex v) {
        PVector<Edge> incs = JGraLab.vector();
        for (Edge e : v.incidences()) {
            incs = incs.plus(e);
        }
        return incs;
    }

    protected PVector<Edge> evaluate(Vertex v, TypeCollection c) {
        PVector<Edge> incs = JGraLab.vector();
        block5: for (Edge e = v.getFirstIncidence(); e != null; e = e.getNextIncidence()) {
            if (!c.acceptsType(e.getAttributedElementClass())) continue;
            switch (this.direction) {
                case INOUT: {
                    incs = incs.plus(e);
                    continue block5;
                }
                case OUT: {
                    if (!e.isNormal()) continue block5;
                    incs = incs.plus(e);
                    continue block5;
                }
                case IN: {
                    if (e.isNormal()) continue block5;
                    incs = incs.plus(e);
                }
            }
        }
        return incs;
    }
}

