/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.relations;

import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;

public class Equals
extends Function {
    @Description(params={"a", "b"}, description="Determines if $a$ and $b$ are equal. Alternative: a = b", categories={Function.Category.RELATIONS})
    public Equals() {
        super(2L, 1L, 0.05);
    }

    public Boolean evaluate(String s, Enum<?> e) {
        return s.equals(e.toString());
    }

    public Boolean evaluate(Enum<?> e, String s) {
        return s.equals(e.toString());
    }

    public Boolean evaluate(Number a, Number b) {
        if (a instanceof Double || b instanceof Double) {
            return a.doubleValue() == b.doubleValue();
        }
        if (a instanceof Long || b instanceof Long) {
            return a.longValue() == b.longValue();
        }
        return a.intValue() == b.intValue();
    }

    public Boolean evaluate(Object a, Object b) {
        return a.equals(b);
    }
}

