/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.relations;

import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;

public class GrEqual
extends Function {
    @Description(params={"a", "b"}, description="Determines if $a \\geq b$. Alternative: a >= b", categories={Function.Category.RELATIONS})
    public GrEqual() {
        super(2L, 1L, 0.05);
    }

    public Boolean evaluate(Number a, Number b) {
        if (a instanceof Double || b instanceof Double) {
            return Double.compare(a.doubleValue(), b.doubleValue()) >= 0;
        }
        if (a instanceof Long || b instanceof Long) {
            return a.longValue() >= b.longValue();
        }
        assert (a instanceof Integer && b instanceof Integer);
        return a.intValue() >= b.intValue();
    }

    public <T extends Comparable<? super T>> Boolean evaluate(T a, T b) {
        return a.compareTo(b) >= 0;
    }
}

