/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.schema;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import org.pcollections.PMap;
import org.pcollections.PVector;

public class Attributes
extends Function {
    public Attributes() {
        super(2L, 1L, 1.0);
    }

    @Description(params={"cls"}, description="Returns the attribute names and domains of the specified schema class in terms of a vector containing one map per attribute with the keys name and domain.", categories={Function.Category.SCHEMA_ACCESS})
    public PVector<PMap<String, String>> evaluate(AttributedElementClass<?, ?> cls) {
        PVector<PMap<String, String>> result = JGraLab.vector();
        for (Attribute a : cls.getAttributeList()) {
            PMap<String, String> entry = JGraLab.map();
            entry = entry.plus("name", a.getName()).plus("domain", a.getDomain().getQualifiedName());
            result = result.plus(entry);
        }
        return result;
    }

    @Description(params={"el"}, description="Returns the attribute names and domains of the specified element in terms of a vector containing one map per attribute with the keys name and domain.", categories={Function.Category.SCHEMA_ACCESS})
    public PVector<PMap<String, String>> evaluate(AttributedElement<?, ?> el) {
        return this.evaluate((AttributedElementClass<?, ?>)el.getAttributedElementClass());
    }
}

