/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.statistics;

import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import java.util.ArrayList;
import java.util.Collection;

public class Sdev
extends Function {
    @Description(params={"l"}, description="Returns the standard deviation of a collection of numbers.\nIf the collection's size is less than 2, the standard deviation is undefined.", categories={Function.Category.STATISTICS})
    public Sdev() {
    }

    public Double evaluate(Collection<Number> l) {
        if (l.size() < 1) {
            return null;
        }
        double sum = 0.0;
        for (Number n : l) {
            sum += n.doubleValue();
        }
        double mean = sum / (double)l.size();
        sum = 0.0;
        for (Number n : l) {
            double d = n.doubleValue() - mean;
            sum += d * d;
        }
        return Math.sqrt(sum / (double)(l.size() - 1));
    }

    @Override
    public long getEstimatedCosts(ArrayList<Long> inElements) {
        return inElements.get(0);
    }
}

