/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.statistics;

import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import java.util.ArrayList;
import java.util.Collection;

public class Sum
extends Function {
    @Description(params={"l"}, description="Returns the sum of the given collection of numbers.", categories={Function.Category.STATISTICS})
    public Sum() {
    }

    public Number evaluate(Collection<Number> l) {
        if (l.isEmpty()) {
            return 0;
        }
        Class resultType = Integer.class;
        for (Number n : l) {
            if (n instanceof Integer) continue;
            if (n instanceof Long) {
                if (resultType != Integer.class) continue;
                resultType = Long.class;
                continue;
            }
            if (n instanceof Double) {
                resultType = Double.class;
                break;
            }
            throw new IllegalArgumentException("sum can't handle numbers of type " + n.getClass());
        }
        if (resultType == Integer.class) {
            int sum = 0;
            for (Number n : l) {
                sum += n.intValue();
            }
            return sum;
        }
        if (resultType == Long.class) {
            long sum = 0L;
            for (Number n : l) {
                sum += n.longValue();
            }
            return sum;
        }
        double sum = 0.0;
        for (Number n : l) {
            sum += n.doubleValue();
        }
        return sum;
    }

    @Override
    public long getEstimatedCosts(ArrayList<Long> inElements) {
        return inElements.get(0);
    }
}

