/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.strings;

import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;
import de.uni_koblenz.jgralab.greql.funlib.strings.ReMatch;
import java.util.List;
import java.util.regex.Pattern;
import org.pcollections.PVector;

public class Split
extends Function {
    @Description(params={"s", "regex"}, description="Splits the given string according to the given regular expression and returns the parts as list.", categories={Function.Category.STRINGS})
    public Split() {
        super(10L, 3L, 0.1);
    }

    public List<String> evaluate(String s, String regex) {
        Pattern pat = ReMatch.patternCache.get(regex);
        if (pat == null) {
            pat = Pattern.compile(regex);
            ReMatch.patternCache.put(regex, pat);
        }
        String[] parts = pat.split(s);
        PVector<String> result = JGraLab.vector();
        for (String part : parts) {
            result = result.plus(part);
        }
        return result;
    }
}

