/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.funlib.strings;

import de.uni_koblenz.jgralab.greql.funlib.Description;
import de.uni_koblenz.jgralab.greql.funlib.Function;

public class Substring
extends Function {
    @Description(params={"s", "beginIndex"}, description="Returns the substring of s starting at beginIndex.", categories={Function.Category.STRINGS})
    public String evaluate(String s, Integer beginIndex) {
        try {
            return s.substring(beginIndex);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    @Description(params={"s", "beginIndex", "endIndex"}, description="Returns the substring of s from beginIndex (incl) to endIndex (excl).", categories={Function.Category.STRINGS})
    public String evaluate(String s, Integer beginIndex, Integer endIndex) {
        try {
            return s.substring(beginIndex, endIndex);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }
}

