/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.OptimizerInfo;
import de.uni_koblenz.jgralab.greql.exception.OptimizerException;
import de.uni_koblenz.jgralab.greql.optimizer.Optimizer;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerBase;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerUtility;
import de.uni_koblenz.jgralab.greql.schema.GreqlAggregation;
import de.uni_koblenz.jgralab.greql.schema.GreqlVertex;
import de.uni_koblenz.jgralab.greql.schema.PathDescription;
import de.uni_koblenz.jgralab.greql.schema.Variable;
import de.uni_koblenz.jgralab.schema.Attribute;
import java.util.HashMap;
import java.util.logging.Logger;

public class CommonSubgraphOptimizer
extends OptimizerBase {
    private static Logger logger = JGraLab.getLogger(CommonSubgraphOptimizer.class);
    private boolean anOptimizationWasDone = false;
    private final HashMap<String, GreqlVertex> subgraphMap = new HashMap();
    private final HashMap<GreqlVertex, String> reverseSubgraphMap = new HashMap();

    public CommonSubgraphOptimizer(OptimizerInfo optimizerInfo) {
        super(optimizerInfo);
    }

    @Override
    public boolean isEquivalent(Optimizer optimizer) {
        return optimizer instanceof CommonSubgraphOptimizer;
    }

    @Override
    public boolean optimize(GreqlQuery query) throws OptimizerException {
        this.anOptimizationWasDone = false;
        this.computeHashAndProcess(query.getQueryGraph().getFirstGreqlExpression());
        return this.anOptimizationWasDone;
    }

    private String computeHashAndProcess(GreqlVertex vertex) {
        if (this.reverseSubgraphMap.containsKey(vertex)) {
            return "{V" + vertex.getId() + "}";
        }
        if (vertex instanceof Variable) {
            return "{V" + vertex.getId() + "}";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("{V");
        buf.append(":");
        buf.append(vertex.getAttributedElementClass().getQualifiedName());
        buf.append(this.computeAttributeHash(vertex));
        for (Edge e : vertex.incidences(EdgeDirection.IN)) {
            buf.append("{E:");
            buf.append(e.getAttributedElementClass().getQualifiedName());
            buf.append("}");
            buf.append(this.computeHashAndProcess((GreqlVertex)e.getThat()));
        }
        buf.append("}");
        String hash = buf.toString();
        GreqlVertex lowerVertex = vertex;
        if (this.subgraphMap.containsKey(hash)) {
            GreqlVertex higherVertex = this.subgraphMap.get(hash);
            if (lowerVertex.getId() > higherVertex.getId()) {
                GreqlVertex tmp = lowerVertex;
                lowerVertex = higherVertex;
                higherVertex = tmp;
                this.reverseSubgraphMap.remove(higherVertex);
            }
            this.mergeVertices(lowerVertex, higherVertex);
        }
        this.subgraphMap.put(hash, lowerVertex);
        this.reverseSubgraphMap.put(lowerVertex, hash);
        return "{V" + lowerVertex.getId() + "}";
    }

    private String computeAttributeHash(GreqlVertex vertex) {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        for (Attribute attr : vertex.getAttributedElementClass().getAttributeList()) {
            buf.append(attr.getName());
            buf.append("=");
            Object attrValue = vertex.getAttribute(attr.getName());
            if (attrValue != null) {
                buf.append(attrValue);
            }
            buf.append(";");
        }
        buf.append(")");
        return buf.toString();
    }

    private void mergeVertices(GreqlVertex lowerVertex, GreqlVertex higherVertex) {
        if (!(lowerVertex instanceof PathDescription)) {
            this.anOptimizationWasDone = true;
            logger.finer(this.optimizerHeaderString() + "Merging " + lowerVertex + " and " + higherVertex + ".");
            this.mergeSourcePositionsBelow(lowerVertex, higherVertex);
            while (higherVertex.getFirstIncidence(EdgeDirection.OUT) != null) {
                higherVertex.getFirstIncidence(EdgeDirection.OUT).setAlpha(lowerVertex);
            }
            higherVertex.delete();
        }
    }

    private void mergeSourcePositionsBelow(GreqlVertex lowerVertex, GreqlVertex higherVertex) {
        GreqlAggregation gal = lowerVertex.getFirstGreqlAggregationIncidence(EdgeDirection.IN);
        for (GreqlAggregation gah = higherVertex.getFirstGreqlAggregationIncidence(EdgeDirection.IN); gal != null && gah != null; gal = gal.getNextGreqlAggregationIncidence(EdgeDirection.IN), gah = gah.getNextGreqlAggregationIncidence(EdgeDirection.IN)) {
            OptimizerUtility.mergeSourcePositions(gah, gal);
            this.mergeSourcePositionsBelow(gal.getAlpha(), gah.getAlpha());
        }
    }
}

