/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer;

import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.OptimizerInfo;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.exception.OptimizerException;
import de.uni_koblenz.jgralab.greql.optimizer.CommonSubgraphOptimizer;
import de.uni_koblenz.jgralab.greql.optimizer.ConditionalExpressionOptimizer;
import de.uni_koblenz.jgralab.greql.optimizer.EarlySelectionOptimizer;
import de.uni_koblenz.jgralab.greql.optimizer.MergeConstraintsOptimizer;
import de.uni_koblenz.jgralab.greql.optimizer.MergeSimpleDeclarationsOptimizer;
import de.uni_koblenz.jgralab.greql.optimizer.Optimizer;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerBase;
import de.uni_koblenz.jgralab.greql.optimizer.PathExistenceOptimizer;
import de.uni_koblenz.jgralab.greql.optimizer.PathExistenceToDirectedPathExpressionOptimizer;
import de.uni_koblenz.jgralab.greql.optimizer.TransformXorFunctionApplicationOptimizer;
import de.uni_koblenz.jgralab.greql.optimizer.TypeCollectionEvaluator;
import de.uni_koblenz.jgralab.greql.optimizer.VariableDeclarationOrderOptimizer;
import de.uni_koblenz.jgralab.greql.schema.GreqlExpression;
import de.uni_koblenz.jgralab.greql.schema.GreqlGraph;
import de.uni_koblenz.jgralab.greql.schema.GreqlVertex;
import de.uni_koblenz.jgralab.greql.schema.Variable;
import java.util.Set;
import java.util.logging.Logger;

public class DefaultOptimizer
extends OptimizerBase {
    private static Logger logger = JGraLab.getLogger(DefaultOptimizer.class);

    public DefaultOptimizer(OptimizerInfo optimizerInfo) {
        super(optimizerInfo);
    }

    @Override
    protected String optimizerHeaderString() {
        return "### " + this.getClass().getSimpleName() + ": ";
    }

    @Override
    public boolean isEquivalent(Optimizer optimizer) {
        return optimizer instanceof DefaultOptimizer;
    }

    @Override
    public boolean optimize(GreqlQuery query) throws OptimizerException {
        if (query.getQueryGraph().getVCount() <= 1) {
            return false;
        }
        logger.fine(this.optimizerHeaderString() + "Starting optimization.  Fasten your seatbelts!");
        CommonSubgraphOptimizer cso = new CommonSubgraphOptimizer(this.optimizerInfo);
        PathExistenceToDirectedPathExpressionOptimizer pe2dpeo = new PathExistenceToDirectedPathExpressionOptimizer(this.optimizerInfo);
        EarlySelectionOptimizer eso = new EarlySelectionOptimizer(this.optimizerInfo);
        PathExistenceOptimizer peo = new PathExistenceOptimizer(this.optimizerInfo);
        VariableDeclarationOrderOptimizer vdoo = new VariableDeclarationOrderOptimizer(this.optimizerInfo);
        ConditionalExpressionOptimizer ceo = new ConditionalExpressionOptimizer(this.optimizerInfo);
        TransformXorFunctionApplicationOptimizer txfao = new TransformXorFunctionApplicationOptimizer(this.optimizerInfo);
        MergeConstraintsOptimizer mco = new MergeConstraintsOptimizer(this.optimizerInfo);
        MergeSimpleDeclarationsOptimizer msdo = new MergeSimpleDeclarationsOptimizer(this.optimizerInfo);
        boolean aTransformationWasDone = false;
        int noOfRuns = 1;
        if (this.optimizerInfo.getSchema() != null) {
            TypeCollectionEvaluator tce = new TypeCollectionEvaluator((GreqlQueryImpl)query);
            tce.execute();
        }
        while (cso.optimize(query) | txfao.optimize(query) | cso.optimize(query) | mco.optimize(query) | pe2dpeo.optimize(query) | eso.optimize(query) | cso.optimize(query) | vdoo.optimize(query) | cso.optimize(query) | peo.optimize(query) | ceo.optimize(query) | cso.optimize(query) | msdo.optimize(query)) {
            aTransformationWasDone = true;
            if (++noOfRuns > 10) {
                logger.warning("Optimizer didn't finish after 10 runs. Stopping here.");
                break;
            }
            logger.fine(this.optimizerHeaderString() + "starts a new iteration (" + noOfRuns + ")...");
        }
        logger.fine(this.optimizerHeaderString() + " finished after " + noOfRuns + " iterations.");
        return aTransformationWasDone;
    }

    protected void printCosts(GreqlQuery query) {
        GreqlGraph syntaxgraph = query.getQueryGraph();
        logger.fine("Optimizer: Optimizing " + syntaxgraph.getId() + ".\n" + "This syntaxgraph has " + syntaxgraph.getECount() + " edges and " + syntaxgraph.getVCount() + " vertexes.");
        GreqlExpression rootVertex = syntaxgraph.getFirstGreqlExpression();
        VertexEvaluator<GreqlExpression> rootEval = ((GreqlQueryImpl)query).getVertexEvaluator(rootVertex);
        rootEval.getInitialSubtreeEvaluationCosts();
        rootEval.getEstimatedCardinality();
        rootEval.calculateEstimatedSelectivity();
        logger.fine("=========================================================");
        for (GreqlVertex vertex = syntaxgraph.getFirstGreqlVertex(); vertex != null; vertex = vertex.getNextGreqlVertex()) {
            logger.fine("Current Node: " + vertex);
            VertexEvaluator<GreqlVertex> veval = ((GreqlQueryImpl)query).getVertexEvaluator(vertex);
            if (veval != null) {
                long costs = veval.getInitialSubtreeEvaluationCosts();
                long card = veval.getEstimatedCardinality();
                Set<Variable> neededVars = veval.getNeededVariables();
                Set<Variable> definedVars = veval.getDefinedVariables();
                long varCombs = veval.getVariableCombinations();
                double sel = veval.getEstimatedSelectivity();
                logger.fine("Costs for subtree evaluation: " + costs + "\n" + "Estimated cardinality: " + card + "\n" + "Estimated selectivity: " + sel + "\n" + "Needed Vars: " + neededVars + "\n" + "Defined Vars: " + definedVars + "\n" + "Variable Combinations: " + varCombs);
            }
            logger.fine("=========================================================");
        }
        VertexEvaluator<GreqlExpression> greql2ExpEval = ((GreqlQueryImpl)query).getVertexEvaluator(syntaxgraph.getFirstGreqlExpression());
        greql2ExpEval.resetSubtreeToInitialState(null);
        long estimatedInterpretationSteps = greql2ExpEval.getCurrentSubtreeEvaluationCosts();
        logger.fine("Costs for the whole query: " + estimatedInterpretationSteps);
    }
}

