/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer;

import de.uni_koblenz.jgralab.greql.OptimizerInfo;
import de.uni_koblenz.jgralab.greql.types.TypeCollection;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.VertexClass;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;

public class DefaultOptimizerInfo
implements OptimizerInfo {
    public static final String PROPERTY_FILE_VERSION = "OptimizerInfo-1.0";
    private static final String OPTIMIZER_INFO_VERSION_KEY = "OptimizerInfoVersion";
    private static final String AVERAGE_VERTEX_COUNT_KEY = "AverageVertexCount";
    private static final String AVERAGE_EDGE_COUNT_KEY = "AverageEdgeCount";
    private static final String QUALIFIED_SCHEMA_NAME_KEY = "QualifiedSchemaName";
    private static final double DEFAULT_AVG_EC_SUBCLASSES = 2.0;
    private static final double DEFAULT_AVG_VC_SUBCLASSES = 2.0;
    private static final int DEFAULT_ABSTRACT_EC_COUNT = 10;
    private static final int DEFAULT_EC_COUNT = 50;
    private static final int DEFAULT_ABSTRACT_VC_COUNT = 10;
    private static final int DEFAULT_VC_COUNT = 50;
    private static final int DEFAULT_AVG_EDGE_COUNT = 15000;
    private static final long DEFAULT_AVG_VERTEX_COUNT = 10000L;
    private Schema schema;
    private long avgVertexCount;
    private long avgEdgeCount;
    private int abstractVertexClassCount;
    private int abstractEdgeClassCount;
    private int vertexClassCount;
    private int edgeClassCount;
    private double avgEdgeSubclasses;
    private double avgVertexSubclasses;
    private HashMap<GraphElementClass<?, ?>, Double> frequenciesWithoutSubclasses;
    private HashMap<GraphElementClass<?, ?>, Double> frequencies;

    public DefaultOptimizerInfo() {
        this(null);
    }

    public DefaultOptimizerInfo(Schema schema) {
        this(schema, null);
    }

    public DefaultOptimizerInfo(Schema schema, String propFilename) {
        int n;
        this.schema = schema;
        this.avgVertexCount = 10000L;
        this.avgEdgeCount = 15000L;
        if (schema == null) {
            this.vertexClassCount = 50;
            this.abstractVertexClassCount = 10;
            this.edgeClassCount = 50;
            this.abstractEdgeClassCount = 10;
            this.avgVertexSubclasses = 2.0;
            this.avgEdgeSubclasses = 2.0;
            return;
        }
        GraphClass gc = schema.getGraphClass();
        this.vertexClassCount = gc.getVertexClassCount();
        this.edgeClassCount = gc.getEdgeClassCount();
        this.abstractVertexClassCount = 0;
        this.abstractEdgeClassCount = 0;
        this.avgVertexSubclasses = 0.0;
        this.avgEdgeSubclasses = 0.0;
        if (this.vertexClassCount > 0) {
            n = 0;
            for (VertexClass vc : gc.getVertexClasses()) {
                n += vc.getAllSubClasses().size();
                if (!vc.isAbstract()) continue;
                ++this.abstractVertexClassCount;
            }
            this.avgVertexSubclasses = (double)n / (double)this.vertexClassCount;
            if (this.abstractVertexClassCount == this.vertexClassCount) {
                this.abstractVertexClassCount = 0;
            }
        }
        if (this.edgeClassCount > 0) {
            n = 0;
            for (EdgeClass ec : gc.getEdgeClasses()) {
                n += ec.getAllSubClasses().size();
                if (!ec.isAbstract()) continue;
                ++this.abstractEdgeClassCount;
            }
            this.avgEdgeSubclasses = (double)n / (double)this.edgeClassCount;
            if (this.abstractEdgeClassCount == this.edgeClassCount) {
                this.abstractEdgeClassCount = 0;
            }
        }
        this.frequenciesWithoutSubclasses = new HashMap(this.vertexClassCount + this.edgeClassCount);
        for (GraphElementClass<?, ?> gec : gc.getGraphElementClasses()) {
            if (gec instanceof VertexClass) {
                this.frequenciesWithoutSubclasses.put(gec, gec.isAbstract() ? 0.0 : 1.0 / (double)(this.vertexClassCount - this.abstractVertexClassCount));
                continue;
            }
            this.frequenciesWithoutSubclasses.put(gec, gec.isAbstract() ? 0.0 : 1.0 / (double)(this.edgeClassCount - this.abstractEdgeClassCount));
        }
        this.frequencies = new HashMap(this.vertexClassCount + this.edgeClassCount);
        for (GraphElementClass<?, ?> gec : schema.getGraphClass().getGraphElementClasses()) {
            double f = this.frequenciesWithoutSubclasses.get(gec);
            for (GraphElementClass sub : gec.getAllSubClasses()) {
                f += this.frequenciesWithoutSubclasses.get(sub).doubleValue();
            }
            this.frequencies.put(gec, f);
        }
        if (propFilename != null) {
            try {
                this.loadFromPropertyFile(propFilename);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public void storePropertyFile(String propFilename) throws IOException {
        Properties properties = new Properties();
        properties.put(OPTIMIZER_INFO_VERSION_KEY, PROPERTY_FILE_VERSION);
        properties.put(QUALIFIED_SCHEMA_NAME_KEY, this.schema.getQualifiedName());
        properties.put(AVERAGE_VERTEX_COUNT_KEY, Long.toString(this.avgVertexCount));
        properties.put(AVERAGE_EDGE_COUNT_KEY, Long.toString(this.avgEdgeCount));
        for (GraphElementClass<?, ?> gec : this.frequencies.keySet()) {
            properties.put((gec instanceof VertexClass ? "VC_" : "EC_") + gec.getQualifiedName(), this.frequenciesWithoutSubclasses.get(gec) + ";" + this.frequencies.get(gec));
        }
        BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(propFilename));
        properties.store(stream, null);
        stream.close();
    }

    private void loadFromPropertyFile(String propFileame) throws IOException {
        if (this.schema == null) {
            throw new IllegalStateException("schema must not be null when loading a property file");
        }
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(propFileame));
        Properties properties = new Properties();
        properties.load(stream);
        String version = properties.getProperty(OPTIMIZER_INFO_VERSION_KEY);
        if (!PROPERTY_FILE_VERSION.equals(version)) {
            throw new RuntimeException("Wrong property file format, expected: \"OptimizerInfo-1.0\", found: \"" + version + "\"");
        }
        String qn = properties.getProperty(QUALIFIED_SCHEMA_NAME_KEY);
        if (!this.schema.getQualifiedName().equals(qn)) {
            throw new RuntimeException("Schema name mismatch, expected \"" + this.schema.getQualifiedName() + "\", found \"" + qn + "\"");
        }
        for (String key : properties.stringPropertyNames()) {
            String val = properties.getProperty(key);
            if (key.startsWith("VC_") || key.startsWith("EC_")) {
                String name = key.substring(3);
                GraphElementClass<?, ?> gec = this.schema.getGraphClass().getGraphElementClass(name);
                if (gec == null) {
                    throw new RuntimeException("GraphElementClass \"" + name + "\" does not exist in schema \"" + this.schema.getQualifiedName() + "\"");
                }
                String[] f = val.split(";");
                this.frequenciesWithoutSubclasses.put(gec, Double.parseDouble(f[0]));
                this.frequencies.put(gec, Double.parseDouble(f[1]));
                continue;
            }
            if (key.equals(AVERAGE_VERTEX_COUNT_KEY)) {
                this.setAvgVertexCount(Long.parseLong(val));
                continue;
            }
            if (key.equals(AVERAGE_EDGE_COUNT_KEY)) {
                this.setAvgEdgeCount(Long.parseLong(val));
                continue;
            }
            if (key.equals(QUALIFIED_SCHEMA_NAME_KEY) || key.equals(OPTIMIZER_INFO_VERSION_KEY)) continue;
            throw new RuntimeException("Unknown property key \"" + key + "\"");
        }
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public int getEdgeClassCount() {
        return this.edgeClassCount;
    }

    @Override
    public int getVertexClassCount() {
        return this.vertexClassCount;
    }

    public int getAbstractVertexClassCount() {
        return this.abstractVertexClassCount;
    }

    public int getAbstractEdgeClassCount() {
        return this.abstractEdgeClassCount;
    }

    @Override
    public long getAverageVertexCount() {
        return this.avgVertexCount;
    }

    @Override
    public long getAverageEdgeCount() {
        return this.avgEdgeCount;
    }

    public void setSchema(Schema schema) {
        if (this.schema != null) {
            throw new IllegalArgumentException("Schema can be set only once");
        }
        this.schema = schema;
    }

    public void setAvgVertexCount(long avgVertexCount) {
        if (avgVertexCount <= 0L) {
            throw new IllegalArgumentException("avgVertexCount must be > 0");
        }
        this.avgVertexCount = avgVertexCount;
    }

    public void setAvgEdgeCount(long avgEdgeCount) {
        if (avgEdgeCount <= 0L) {
            throw new IllegalArgumentException("avgEdgeCount must be > 0");
        }
        this.avgEdgeCount = avgEdgeCount;
    }

    public void setFrequencies(GraphElementClass<?, ?> gec, double freqWithoutSubclasses, double freq) {
        if (this.schema == null) {
            throw new IllegalStateException("Schema must be set before defining frequencies");
        }
        if (gec.getSchema() != this.schema) {
            throw new IllegalArgumentException("GraphElementClass does not belong to schema");
        }
        this.frequenciesWithoutSubclasses.put(gec, freqWithoutSubclasses);
        this.frequencies.put(gec, freq);
    }

    @Override
    public double getAverageVertexSubclasses() {
        return this.avgVertexSubclasses;
    }

    @Override
    public double getAverageEdgeSubclasses() {
        return this.avgEdgeSubclasses;
    }

    @Override
    public double getFrequencyOfGraphElementClass(GraphElementClass<?, ?> gec) {
        if (this.schema == null) {
            if (gec instanceof VertexClass) {
                return (double)this.getAverageVertexCount() * this.getAverageVertexSubclasses() / (double)(this.getVertexClassCount() - this.getAbstractVertexClassCount());
            }
            return (double)this.getAverageEdgeCount() * this.getAverageEdgeSubclasses() / (double)(this.getEdgeClassCount() - this.getAbstractEdgeClassCount());
        }
        return this.frequencies.get(gec);
    }

    @Override
    public double getFrequencyOfGraphElementClassWithoutSubclasses(GraphElementClass<?, ?> gec) {
        if (this.schema == null) {
            if (gec.isAbstract()) {
                return 0.0;
            }
            if (gec instanceof VertexClass) {
                return (double)this.getAverageVertexCount() / (double)(this.getVertexClassCount() - this.getAbstractVertexClassCount());
            }
            return (double)this.getAverageEdgeCount() / (double)(this.getEdgeClassCount() - this.getAbstractEdgeClassCount());
        }
        return this.frequenciesWithoutSubclasses.get(gec);
    }

    @Override
    public double getFrequencyOfTypeCollection(TypeCollection tc) {
        return tc.getFrequency(this);
    }

    @Override
    public double getEdgesPerVertex() {
        return (double)this.getAverageEdgeCount() / (double)this.getAverageVertexCount();
    }

    @Override
    public long getEstimatedGraphElementCount(GraphElementClass<?, ?> gec) {
        if (gec instanceof VertexClass) {
            return (long)((double)this.getAverageVertexCount() * this.getFrequencyOfGraphElementClass(gec));
        }
        return (long)((double)this.getAverageEdgeCount() * this.getFrequencyOfGraphElementClass(gec));
    }

    @Override
    public long getEstimatedGraphElementCount(TypeCollection tc) {
        return tc.getEstimatedGraphElementCount(this);
    }
}

