/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.OptimizerInfo;
import de.uni_koblenz.jgralab.greql.exception.OptimizerException;
import de.uni_koblenz.jgralab.greql.optimizer.Optimizer;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerBase;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerUtility;
import de.uni_koblenz.jgralab.greql.schema.Declaration;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.FunctionApplication;
import de.uni_koblenz.jgralab.greql.schema.FunctionId;
import de.uni_koblenz.jgralab.greql.schema.GreqlGraph;
import de.uni_koblenz.jgralab.greql.schema.Identifier;
import de.uni_koblenz.jgralab.greql.schema.IsArgumentOf;
import de.uni_koblenz.jgralab.greql.schema.IsBoundVarOf;
import de.uni_koblenz.jgralab.greql.schema.IsConstraintOf;
import de.uni_koblenz.jgralab.greql.schema.IsDeclaredVarOf;
import de.uni_koblenz.jgralab.greql.schema.IsSimpleDeclOf;
import de.uni_koblenz.jgralab.greql.schema.IsVarOf;
import de.uni_koblenz.jgralab.greql.schema.RecordConstruction;
import de.uni_koblenz.jgralab.greql.schema.RecordElement;
import de.uni_koblenz.jgralab.greql.schema.RecordId;
import de.uni_koblenz.jgralab.greql.schema.SetComprehension;
import de.uni_koblenz.jgralab.greql.schema.SimpleDeclaration;
import de.uni_koblenz.jgralab.greql.schema.Variable;
import de.uni_koblenz.jgralab.schema.Attribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class EarlySelectionOptimizer
extends OptimizerBase {
    private static Logger logger = JGraLab.getLogger(EarlySelectionOptimizer.class);
    private GreqlGraph syntaxgraph;

    public EarlySelectionOptimizer(OptimizerInfo optimizerInfo) {
        super(optimizerInfo);
    }

    @Override
    public boolean isEquivalent(Optimizer optimizer) {
        return optimizer instanceof EarlySelectionOptimizer;
    }

    @Override
    public boolean optimize(GreqlQuery query) throws OptimizerException {
        this.syntaxgraph = query.getQueryGraph();
        int noOfRuns = 1;
        while (this.runOptimization()) {
            logger.finer(this.optimizerHeaderString() + "Iteration " + noOfRuns + " finished.  Restarting...");
            ++noOfRuns;
        }
        if (noOfRuns > 1) {
            logger.finer(this.optimizerHeaderString() + "finished after " + noOfRuns + " runs.");
        }
        OptimizerUtility.createMissingSourcePositions(this.syntaxgraph);
        return noOfRuns > 1;
    }

    private boolean runOptimization() throws OptimizerException {
        HashMap<SimpleDeclaration, Set<Expression>> movableExpressions = new HashMap<SimpleDeclaration, Set<Expression>>();
        for (Declaration decl : this.syntaxgraph.getDeclarationVertices()) {
            for (IsConstraintOf isConst = decl.getFirstIsConstraintOfIncidence(EdgeDirection.IN); isConst != null; isConst = isConst.getNextIsConstraintOfIncidence(EdgeDirection.IN)) {
                Expression exp = isConst.getAlpha();
                for (Map.Entry<SimpleDeclaration, Set<Expression>> e : this.collectMovableExpressions(exp).entrySet()) {
                    if (movableExpressions.containsKey(e.getKey())) {
                        ((Set)movableExpressions.get(e.getKey())).addAll((Collection)e.getValue());
                        continue;
                    }
                    movableExpressions.put(e.getKey(), e.getValue());
                }
            }
        }
        boolean aTransformationWasDone = false;
        ArrayList simpleDeclsWithMovableExpressions = new ArrayList(movableExpressions.keySet());
        Collections.sort(simpleDeclsWithMovableExpressions, new Comparator<SimpleDeclaration>(){

            @Override
            public int compare(SimpleDeclaration sd1, SimpleDeclaration sd2) {
                Declaration decl2;
                Declaration decl1 = sd1.getFirstIsSimpleDeclOfIncidence().getOmega();
                if (OptimizerUtility.isAbove(decl1, decl2 = sd2.getFirstIsSimpleDeclOfIncidence().getOmega())) {
                    return 1;
                }
                if (OptimizerUtility.isAbove(decl2, decl1)) {
                    return -1;
                }
                return 0;
            }
        });
        for (SimpleDeclaration sd : simpleDeclsWithMovableExpressions) {
            Declaration parentDecl = sd.getFirstIsSimpleDeclOfIncidence().getOmega();
            Set<Variable> varsDeclaredBySd = OptimizerUtility.collectVariablesDeclaredBy(sd);
            boolean foundPredicateNeedingAllVars = false;
            boolean foundPredNeedingPartOfVars = false;
            Set<Variable> varsMaybeToSplitOut = new HashSet<Variable>();
            for (Expression pred : (Set)movableExpressions.get(sd)) {
                Set<Variable> neededLocalVars = this.collectNeededLocalVariables(pred);
                if (neededLocalVars.size() < varsDeclaredBySd.size()) {
                    foundPredNeedingPartOfVars = true;
                    if (varsMaybeToSplitOut.size() >= neededLocalVars.size()) continue;
                    varsMaybeToSplitOut = neededLocalVars;
                    continue;
                }
                foundPredicateNeedingAllVars = true;
            }
            List<SimpleDeclaration> sdsOfParentDecl = this.collectSimpleDeclarationsOf(parentDecl);
            if (foundPredNeedingPartOfVars && (!foundPredicateNeedingAllVars || sdsOfParentDecl.size() == 1)) {
                this.splitSimpleDeclaration(sd, varsMaybeToSplitOut);
                aTransformationWasDone = true;
                continue;
            }
            if (varsDeclaredBySd.size() == 1) {
                this.movePredicatesToOneVarSimpleDeclaration(sd, (Set)movableExpressions.get(sd), varsDeclaredBySd);
                aTransformationWasDone = true;
                continue;
            }
            if (sdsOfParentDecl.size() <= 1) continue;
            this.movePredicatesToMultiVarSimpleDeclaration(sd, (Set)movableExpressions.get(sd), varsDeclaredBySd);
            aTransformationWasDone = true;
        }
        return aTransformationWasDone;
    }

    private void movePredicatesToMultiVarSimpleDeclaration(SimpleDeclaration origSD, Set<Expression> predicates, Set<Variable> varsDeclaredByOrigSD) throws OptimizerException {
        logger.finer(this.optimizerHeaderString() + "(Mn) Performing early selection transformation for " + origSD + " declaring ");
        int varsSize = varsDeclaredByOrigSD.size();
        int i = 1;
        StringBuilder sb = new StringBuilder();
        for (Variable var : varsDeclaredByOrigSD) {
            sb.append(var + " (" + var.get_name() + ")");
            if (i < varsSize) {
                sb.append(", ");
            }
            ++i;
        }
        logger.finer(sb.toString() + " with predicates " + predicates + ".");
        Declaration parentDeclOfOrigSD = origSD.getFirstIsSimpleDeclOfIncidence(EdgeDirection.OUT).getOmega();
        assert (parentDeclOfOrigSD.getDegree(EdgeDirection.OUT) == 1);
        HashMap<Variable, Set<Edge>> varEdgeMap = new HashMap<Variable, Set<Edge>>();
        for (Variable var : varsDeclaredByOrigSD) {
            varEdgeMap.put(var, this.collectVariableAccessEdges(var));
        }
        RecordConstruction newOuterRecord = this.syntaxgraph.createRecordConstruction();
        StringBuilder newOuterVarName = new StringBuilder();
        for (Variable var : varsDeclaredByOrigSD) {
            newOuterVarName.append(var.get_name());
            RecordElement recElem = this.syntaxgraph.createRecordElement();
            this.syntaxgraph.createIsRecordElementOf(recElem, newOuterRecord);
            RecordId recId = this.syntaxgraph.createRecordId();
            recId.set_name("_" + var.get_name());
            this.syntaxgraph.createIsRecordIdOf(recId, recElem);
            this.syntaxgraph.createIsRecordExprOf(var, recElem);
        }
        Variable newOuterRecordVar = this.syntaxgraph.createVariable();
        newOuterRecordVar.set_name(newOuterVarName.toString());
        SimpleDeclaration newOuterSD = this.syntaxgraph.createSimpleDeclaration();
        this.syntaxgraph.createIsSimpleDeclOf(newOuterSD, parentDeclOfOrigSD);
        this.syntaxgraph.createIsDeclaredVarOf(newOuterRecordVar, newOuterSD);
        SetComprehension newInnerCompr = this.syntaxgraph.createSetComprehension();
        this.syntaxgraph.createIsTypeExprOfDeclaration(newInnerCompr, newOuterSD);
        Declaration newInnerDecl = this.syntaxgraph.createDeclaration();
        this.syntaxgraph.createIsCompDeclOf(newInnerDecl, newInnerCompr);
        this.syntaxgraph.createIsCompResultDefOf(newOuterRecord, newInnerCompr);
        origSD.getFirstIsSimpleDeclOfIncidence(EdgeDirection.OUT).setOmega(newInnerDecl);
        Expression newCombinedConstraint = this.createConjunction(new ArrayList<Expression>(predicates), new HashSet<Variable>());
        this.syntaxgraph.createIsConstraintOf(newCombinedConstraint, newInnerDecl);
        for (Expression expression : predicates) {
            this.removeExpressionFromOriginalConstraint(expression, parentDeclOfOrigSD);
        }
        for (Map.Entry entry : varEdgeMap.entrySet()) {
            FunctionApplication funApp = this.syntaxgraph.createFunctionApplication();
            FunctionId funId = OptimizerUtility.findOrCreateFunctionId("getValue", this.syntaxgraph);
            this.syntaxgraph.createIsFunctionIdOf(funId, funApp);
            Identifier identifier = this.syntaxgraph.createIdentifier();
            identifier.set_name("_" + ((Variable)entry.getKey()).get_name());
            this.syntaxgraph.createIsArgumentOf(newOuterRecordVar, funApp);
            this.syntaxgraph.createIsArgumentOf(identifier, funApp);
            for (Edge edge : (Set)entry.getValue()) {
                if (!edge.isValid()) continue;
                edge.setAlpha(funApp);
                assert (edge.getAlpha() == funApp);
            }
        }
    }

    private void movePredicatesToOneVarSimpleDeclaration(SimpleDeclaration origSD, Set<Expression> predicates, Set<Variable> varsDeclaredByOrigSD) throws OptimizerException {
        Variable var = varsDeclaredByOrigSD.iterator().next();
        logger.finer(this.optimizerHeaderString() + "Performing early selection transformation for " + origSD + " declaring variable " + var + " (" + var.get_name() + ") with predicates " + predicates);
        Expression newCombinedConstraint = this.createConjunction(new ArrayList<Expression>(predicates), varsDeclaredByOrigSD);
        SetComprehension newSetComp = this.syntaxgraph.createSetComprehension();
        Declaration newDecl = this.syntaxgraph.createDeclaration();
        SimpleDeclaration newInnerSD = this.syntaxgraph.createSimpleDeclaration();
        Set<Variable> undeclaredVars = this.collectUndeclaredVariablesBelow(newCombinedConstraint);
        if (undeclaredVars.size() != 1) {
            OptimizerException ex = new OptimizerException("undeclaredVars = " + undeclaredVars + " has size different form 1.");
            logger.throwing(this.getClass().getName(), "movePredicatesToOneVarSimpleDeclaration", ex);
            throw ex;
        }
        Variable newInnerVar = undeclaredVars.iterator().next();
        origSD.getFirstIsTypeExprOfIncidence(EdgeDirection.IN).setOmega(newInnerSD);
        this.syntaxgraph.createIsTypeExprOfDeclaration(newSetComp, origSD);
        this.syntaxgraph.createIsCompDeclOf(newDecl, newSetComp);
        this.syntaxgraph.createIsSimpleDeclOf(newInnerSD, newDecl);
        this.syntaxgraph.createIsDeclaredVarOf(newInnerVar, newInnerSD);
        this.syntaxgraph.createIsConstraintOf(newCombinedConstraint, newDecl);
        this.syntaxgraph.createIsCompResultDefOf(newInnerVar, newSetComp);
        for (Expression exp : predicates) {
            this.removeExpressionFromOriginalConstraint(exp, origSD.getFirstIsSimpleDeclOfIncidence().getOmega());
        }
    }

    private void removeExpressionFromOriginalConstraint(Expression exp, Declaration origDecl) throws OptimizerException {
        if (exp.getFirstIsConstraintOfIncidence(EdgeDirection.OUT) != null) {
            exp.getFirstIsConstraintOfIncidence(EdgeDirection.OUT).delete();
            OptimizerUtility.deleteOrphanedVerticesBelow(exp, new HashSet<Vertex>());
            return;
        }
        ArrayList<Edge> upEdges = new ArrayList<Edge>();
        for (Edge e : exp.incidences(EdgeDirection.OUT)) {
            FunctionApplication father;
            if (!(e.getOmega() instanceof FunctionApplication) || !this.existsForwardPathExcludingOtherTargetClassVertices(e, origDecl) || !OptimizerUtility.isAnd(father = (FunctionApplication)e.getOmega())) continue;
            upEdges.add(e);
        }
        for (Edge upEdge : upEdges) {
            if (!upEdge.isValid()) continue;
            FunctionApplication funApp = (FunctionApplication)upEdge.getOmega();
            if (funApp == null) {
                throw new OptimizerException("Something's pretty wrong. upEdge.getOmega() returned null!! upEdge = " + upEdge + ".");
            }
            Expression otherArg = null;
            for (IsArgumentOf inc : funApp.getIsArgumentOfIncidences(EdgeDirection.IN)) {
                if (inc.getNormalEdge() == upEdge.getNormalEdge()) continue;
                otherArg = inc.getAlpha();
            }
            ArrayList<Edge> funAppEdges = new ArrayList<Edge>();
            for (Edge funAppEdge : funApp.incidences(EdgeDirection.OUT)) {
                funAppEdges.add(funAppEdge);
            }
            for (Edge fae : funAppEdges) {
                fae.setAlpha(otherArg);
            }
            OptimizerUtility.deleteOrphanedVerticesBelow(funApp, new HashSet<Vertex>());
        }
    }

    private Set<Edge> collectVariableAccessEdges(Variable var) {
        HashSet<Edge> edges = new HashSet<Edge>();
        for (Edge e : var.incidences(EdgeDirection.OUT)) {
            if (e instanceof IsDeclaredVarOf || e instanceof IsBoundVarOf || e instanceof IsVarOf) continue;
            edges.add(e);
        }
        return edges;
    }

    private Expression createConjunction(List<Expression> predicates, Set<Variable> varsToBeCopied, HashMap<Variable, Variable> copiedVars) {
        if (predicates.size() == 1) {
            return (Expression)this.copySubgraph(predicates.get(0), this.syntaxgraph, varsToBeCopied, copiedVars);
        }
        FunctionApplication funApp = this.syntaxgraph.createFunctionApplication();
        FunctionId funId = OptimizerUtility.findOrCreateFunctionId("and", this.syntaxgraph);
        this.syntaxgraph.createIsFunctionIdOf(funId, funApp);
        this.syntaxgraph.createIsArgumentOf((Expression)this.copySubgraph(predicates.get(0), this.syntaxgraph, varsToBeCopied, copiedVars), funApp);
        this.syntaxgraph.createIsArgumentOf(this.createConjunction(predicates.subList(1, predicates.size()), varsToBeCopied, copiedVars), funApp);
        return funApp;
    }

    private Expression createConjunction(List<Expression> predicates, Set<Variable> varsToBeCopied) {
        return this.createConjunction(predicates, varsToBeCopied, new HashMap<Variable, Variable>());
    }

    private HashMap<SimpleDeclaration, Set<Expression>> collectMovableExpressions(Expression exp) {
        Declaration parent;
        HashMap<SimpleDeclaration, Set<Expression>> movableExpressions = new HashMap<SimpleDeclaration, Set<Expression>>();
        if (exp instanceof FunctionApplication && OptimizerUtility.isAnd((FunctionApplication)exp)) {
            FunctionApplication funApp = (FunctionApplication)exp;
            for (IsArgumentOf isArg = funApp.getFirstIsArgumentOfIncidence(EdgeDirection.IN); isArg != null; isArg = isArg.getNextIsArgumentOfIncidence(EdgeDirection.IN)) {
                for (Map.Entry<SimpleDeclaration, Set<Expression>> entry : this.collectMovableExpressions(isArg.getAlpha()).entrySet()) {
                    if (movableExpressions.containsKey(entry.getKey())) {
                        movableExpressions.get(entry.getKey()).addAll((Collection<Expression>)entry.getValue());
                        continue;
                    }
                    movableExpressions.put(entry.getKey(), entry.getValue());
                }
            }
            return movableExpressions;
        }
        SimpleDeclaration sd = this.findSimpleDeclarationThatDeclaresAllNeededLocalVariables(exp);
        if (sd != null && (this.collectSimpleDeclarationsOf(parent = sd.getFirstIsSimpleDeclOfIncidence(EdgeDirection.OUT).getOmega()).size() > 1 || OptimizerUtility.collectVariablesDeclaredBy(sd).size() > 1)) {
            if (movableExpressions.containsKey(sd)) {
                movableExpressions.get(sd).add(exp);
            } else {
                HashSet<Expression> predicates = new HashSet<Expression>();
                predicates.add(exp);
                movableExpressions.put(sd, predicates);
            }
        }
        return movableExpressions;
    }

    private SimpleDeclaration findSimpleDeclarationThatDeclaresAllNeededLocalVariables(Expression exp) {
        Set<Variable> neededVars = this.collectNeededLocalVariables(exp);
        SimpleDeclaration sd = null;
        SimpleDeclaration oldSd = null;
        for (Variable var : neededVars) {
            sd = var.getFirstIsDeclaredVarOfIncidence().getOmega();
            if (oldSd != null && sd != oldSd) {
                return null;
            }
            oldSd = sd;
        }
        return sd;
    }

    private Set<Variable> collectNeededLocalVariables(Expression exp) {
        Set<Variable> neededVars = OptimizerUtility.collectInternallyDeclaredVariablesBelow(exp);
        HashSet<Variable> neededLocalVars = new HashSet<Variable>();
        Declaration localDecl = this.findNearestDeclarationAbove(exp);
        for (SimpleDeclaration sd : this.collectSimpleDeclarationsOf(localDecl)) {
            for (Variable var : neededVars) {
                for (IsDeclaredVarOf inc = sd.getFirstIsDeclaredVarOfIncidence(); inc != null; inc = inc.getNextIsDeclaredVarOfIncidence()) {
                    if (inc.getAlpha() != var) continue;
                    neededLocalVars.add(var);
                }
            }
        }
        return neededLocalVars;
    }

    private boolean existsForwardPathExcludingOtherTargetClassVertices(Edge edge, Vertex target) {
        Vertex omega = edge.getOmega();
        if (omega == target) {
            return true;
        }
        if (omega.getAttributedElementClass().getSchemaClass() == target.getAttributedElementClass().getSchemaClass()) {
            return false;
        }
        for (Edge e : omega.incidences(EdgeDirection.OUT)) {
            if (!this.existsForwardPathExcludingOtherTargetClassVertices(e, target)) continue;
            return true;
        }
        return false;
    }

    private List<SimpleDeclaration> collectSimpleDeclarationsOf(Declaration decl) {
        ArrayList<SimpleDeclaration> sds = new ArrayList<SimpleDeclaration>();
        for (IsSimpleDeclOf inc : decl.getIsSimpleDeclOfIncidences(EdgeDirection.IN)) {
            sds.add(inc.getAlpha());
        }
        return sds;
    }

    private Set<Variable> collectUndeclaredVariablesBelow(Vertex vertex) {
        HashSet<Variable> undeclaredVars = new HashSet<Variable>();
        for (Variable var : OptimizerUtility.collectInternallyDeclaredVariablesBelow(vertex)) {
            if (var.getFirstIsDeclaredVarOfIncidence(EdgeDirection.OUT) != null) continue;
            undeclaredVars.add(var);
        }
        return undeclaredVars;
    }

    private Vertex copySubgraph(Vertex origVertex, GreqlGraph graph, Set<Variable> variablesToBeCopied, HashMap<Variable, Variable> copiedVarMap) {
        if (origVertex instanceof Identifier && !(origVertex instanceof Variable)) {
            return origVertex;
        }
        if (origVertex instanceof Variable) {
            if (copiedVarMap.containsKey(origVertex)) {
                return copiedVarMap.get(origVertex);
            }
            if (!variablesToBeCopied.contains(origVertex)) {
                return origVertex;
            }
        }
        Object topVertex = graph.createVertex(origVertex.getAttributedElementClass());
        this.copyAttributes(origVertex, (AttributedElement<?, ?>)topVertex);
        if (topVertex instanceof Variable) {
            Variable newVar = (Variable)topVertex;
            newVar.set_name("_" + newVar.get_name());
            copiedVarMap.put((Variable)origVertex, newVar);
        }
        for (Edge origEdge = origVertex.getFirstIncidence(EdgeDirection.IN); origEdge != null; origEdge = origEdge.getNextIncidence(EdgeDirection.IN)) {
            Vertex subVertex = this.copySubgraph(origEdge.getAlpha(), graph, variablesToBeCopied, copiedVarMap);
            graph.createEdge(origEdge.getAttributedElementClass(), subVertex, (Vertex)topVertex);
        }
        return topVertex;
    }

    private void copyAttributes(AttributedElement<?, ?> from, AttributedElement<?, ?> to) {
        for (Attribute attr : from.getAttributedElementClass().getAttributeList()) {
            to.setAttribute(attr.getName(), from.getAttribute(attr.getName()));
        }
    }
}

