/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.OptimizerInfo;
import de.uni_koblenz.jgralab.greql.optimizer.Optimizer;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerBase;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerUtility;
import de.uni_koblenz.jgralab.greql.schema.Declaration;
import de.uni_koblenz.jgralab.greql.schema.GreqlGraph;
import de.uni_koblenz.jgralab.greql.schema.IsSimpleDeclOf;
import de.uni_koblenz.jgralab.greql.schema.IsTypeExprOfDeclaration;
import de.uni_koblenz.jgralab.greql.schema.SimpleDeclaration;
import de.uni_koblenz.jgralab.impl.InternalEdge;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class MergeSimpleDeclarationsOptimizer
extends OptimizerBase {
    private static Logger logger = JGraLab.getLogger(MergeSimpleDeclarationsOptimizer.class);
    private boolean anOptimizationWasDone = false;

    public MergeSimpleDeclarationsOptimizer(OptimizerInfo optimizerInfo) {
        super(optimizerInfo);
    }

    @Override
    public boolean isEquivalent(Optimizer optimizer) {
        return optimizer instanceof MergeSimpleDeclarationsOptimizer;
    }

    @Override
    public boolean optimize(GreqlQuery query) {
        this.anOptimizationWasDone = false;
        this.findAndMergeSimpleDeclarations(query.getQueryGraph());
        return this.anOptimizationWasDone;
    }

    private void findAndMergeSimpleDeclarations(GreqlGraph syntaxgraph) {
        HashMap<String, ArrayList<SimpleDeclaration>> mergableSDMap = new HashMap<String, ArrayList<SimpleDeclaration>>();
        for (Declaration decl = syntaxgraph.getFirstDeclaration(); decl != null; decl = decl.getNextDeclaration()) {
            for (IsSimpleDeclOf isSimpleDeclOf = decl.getFirstIsSimpleDeclOfIncidence(EdgeDirection.IN); isSimpleDeclOf != null; isSimpleDeclOf = isSimpleDeclOf.getNextIsSimpleDeclOfIncidence()) {
                SimpleDeclaration sDecl = isSimpleDeclOf.getAlpha();
                String key = decl.getId() + "-" + sDecl.getFirstIsTypeExprOfIncidence(EdgeDirection.IN).getAlpha().getId();
                if (mergableSDMap.containsKey(key)) {
                    mergableSDMap.get(key).add(sDecl);
                    continue;
                }
                ArrayList<SimpleDeclaration> simpleDecls = new ArrayList<SimpleDeclaration>();
                simpleDecls.add(sDecl);
                mergableSDMap.put(key, simpleDecls);
            }
        }
        this.mergeSimpleDeclarations(mergableSDMap);
    }

    private void mergeSimpleDeclarations(HashMap<String, ArrayList<SimpleDeclaration>> mergableSDMap) {
        for (Map.Entry<String, ArrayList<SimpleDeclaration>> e : mergableSDMap.entrySet()) {
            SimpleDeclaration survivor = e.getValue().get(0);
            Declaration decl = survivor.getFirstIsSimpleDeclOfIncidence().getOmega();
            IsSimpleDeclOf isSDOfSurvivor = survivor.getFirstIsSimpleDeclOfIncidence(EdgeDirection.OUT);
            IsTypeExprOfDeclaration isTEODSurvivor = survivor.getFirstIsTypeExprOfDeclarationIncidence(EdgeDirection.IN);
            for (SimpleDeclaration s : e.getValue()) {
                IsSimpleDeclOf isSDOfS = s.getFirstIsSimpleDeclOfIncidence(EdgeDirection.OUT);
                if (this.isNextInIncidenceList(decl, isSDOfSurvivor, isSDOfS)) {
                    logger.finer(this.optimizerHeaderString() + "Merging all variables of " + s + " into " + survivor + ".");
                    while (s.getFirstIsDeclaredVarOfIncidence() != null) {
                        ((InternalEdge)((Object)s.getFirstIsDeclaredVarOfIncidence())).setOmega(survivor);
                    }
                    OptimizerUtility.mergeSourcePositions(isSDOfS, isSDOfSurvivor);
                    IsTypeExprOfDeclaration isTEODS = s.getFirstIsTypeExprOfDeclarationIncidence(EdgeDirection.IN);
                    OptimizerUtility.mergeSourcePositions(isTEODS, isTEODSurvivor);
                    s.delete();
                    this.anOptimizationWasDone = true;
                    continue;
                }
                survivor = s;
            }
        }
    }

    private boolean isNextInIncidenceList(Declaration decl, IsSimpleDeclOf isSDOfSurvivor, IsSimpleDeclOf isSDOfS) {
        for (IsSimpleDeclOf edge = decl.getFirstIsSimpleDeclOfIncidence(); edge != null; edge = edge.getNextIsSimpleDeclOfIncidence()) {
            if (edge.getNormalEdge() != isSDOfSurvivor) {
                continue;
            }
            IsSimpleDeclOf nextEdge = edge.getNextIsSimpleDeclOfIncidence();
            return nextEdge != null && nextEdge.getNormalEdge() == isSDOfS;
        }
        return false;
    }
}

