/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.OptimizerInfo;
import de.uni_koblenz.jgralab.greql.exception.OptimizerException;
import de.uni_koblenz.jgralab.greql.optimizer.Optimizer;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerUtility;
import de.uni_koblenz.jgralab.greql.schema.Declaration;
import de.uni_koblenz.jgralab.greql.schema.GreqlExpression;
import de.uni_koblenz.jgralab.greql.schema.GreqlGraph;
import de.uni_koblenz.jgralab.greql.schema.IsBoundVarOf;
import de.uni_koblenz.jgralab.greql.schema.IsDeclaredVarOf;
import de.uni_koblenz.jgralab.greql.schema.IsSimpleDeclOf;
import de.uni_koblenz.jgralab.greql.schema.SimpleDeclaration;
import de.uni_koblenz.jgralab.greql.schema.Variable;
import java.util.HashSet;
import java.util.Set;

public abstract class OptimizerBase
implements Optimizer {
    protected OptimizerInfo optimizerInfo;

    protected OptimizerBase(OptimizerInfo optimizerInfo) {
        this.optimizerInfo = optimizerInfo;
    }

    @Override
    public OptimizerInfo getOptimizerInfo() {
        return this.optimizerInfo;
    }

    protected String optimizerHeaderString() {
        return "*** " + this.getClass().getSimpleName() + ": ";
    }

    protected void relink(Vertex from, Vertex to) {
        Edge newE;
        assert (from != null && to != null) : "Relinking null!";
        assert (from != to) : "Relinking from itself!";
        assert (from.getSchemaClass() == to.getSchemaClass()) : "Relinking different classes! from is " + from + ", to is " + to;
        assert (from.isValid() && to.isValid()) : "Relinking invalid vertices!";
        Edge e = from.getFirstIncidence(EdgeDirection.IN);
        while (e != null) {
            newE = e.getNextIncidence(EdgeDirection.IN);
            e.setOmega(to);
            e = newE;
        }
        e = from.getFirstIncidence(EdgeDirection.OUT);
        while (e != null) {
            newE = e.getNextIncidence(EdgeDirection.OUT);
            e.setAlpha(to);
            e = newE;
        }
    }

    protected boolean isDeclaredBefore(Variable var1, Variable var2) {
        SimpleDeclaration sd2;
        Declaration decl2;
        if (var1 == var2) {
            return false;
        }
        IsBoundVarOf ibvo1 = var1.getFirstIsBoundVarOfIncidence();
        IsBoundVarOf ibvo2 = var2.getFirstIsBoundVarOfIncidence();
        if (ibvo1 != null) {
            if (ibvo2 == null) {
                return true;
            }
            GreqlExpression root = ibvo1.getOmega();
            for (IsBoundVarOf ibvo : root.getIsBoundVarOfIncidences()) {
                if ((ibvo = (IsBoundVarOf)ibvo.getNormalEdge()) == ibvo1) {
                    return true;
                }
                if (ibvo != ibvo2) continue;
                return false;
            }
            throw new OptimizerException("You must never come here...");
        }
        if (ibvo2 != null) {
            return false;
        }
        SimpleDeclaration sd1 = var1.getFirstIsDeclaredVarOfIncidence(EdgeDirection.OUT).getOmega();
        Declaration decl1 = sd1.getFirstIsSimpleDeclOfIncidence(EdgeDirection.OUT).getOmega();
        if (decl1 == (decl2 = (sd2 = var2.getFirstIsDeclaredVarOfIncidence(EdgeDirection.OUT).getOmega()).getFirstIsSimpleDeclOfIncidence(EdgeDirection.OUT).getOmega())) {
            if (sd1 == sd2) {
                for (IsDeclaredVarOf inc = sd1.getFirstIsDeclaredVarOfIncidence(EdgeDirection.IN); inc != null; inc = inc.getNextIsDeclaredVarOfIncidence(EdgeDirection.IN)) {
                    if (inc.getAlpha() == var1) {
                        return true;
                    }
                    if (inc.getAlpha() != var2) continue;
                    return false;
                }
            } else {
                for (IsSimpleDeclOf inc = decl1.getFirstIsSimpleDeclOfIncidence(EdgeDirection.IN); inc != null; inc = inc.getNextIsSimpleDeclOfIncidence(EdgeDirection.IN)) {
                    if (inc.getAlpha() == sd1) {
                        return true;
                    }
                    if (inc.getAlpha() != sd2) continue;
                    return false;
                }
            }
        } else {
            Vertex declParent2;
            Vertex declParent1 = decl1.getFirstIncidence(EdgeDirection.OUT).getOmega();
            return OptimizerUtility.isAbove(declParent1, declParent2 = decl2.getFirstIncidence(EdgeDirection.OUT).getOmega());
        }
        throw new OptimizerException("No case matched in isDeclaredBefore(Variable, Variable). That must not happen!");
    }

    protected Declaration findNearestDeclarationAbove(Vertex vertex) {
        if (vertex instanceof Declaration) {
            return (Declaration)vertex;
        }
        Declaration result = null;
        for (Edge inc = vertex.getFirstIncidence(EdgeDirection.OUT); inc != null; inc = inc.getNextIncidence(EdgeDirection.OUT)) {
            result = this.findNearestDeclarationAbove(inc.getOmega());
            if (result == null) continue;
            return result;
        }
        return null;
    }

    protected SimpleDeclaration splitSimpleDeclaration(SimpleDeclaration sd, Set<Variable> varsToBeSplit) {
        GreqlGraph syntaxgraph = (GreqlGraph)sd.getGraph();
        Set<Variable> varsDeclaredBySD = OptimizerUtility.collectVariablesDeclaredBy(sd);
        if (varsDeclaredBySD.size() == varsToBeSplit.size()) {
            return sd;
        }
        Declaration parentDecl = sd.getFirstIsSimpleDeclOfIncidence(EdgeDirection.OUT).getOmega();
        IsSimpleDeclOf oldEdge = sd.getFirstIsSimpleDeclOfIncidence();
        SimpleDeclaration newSD = syntaxgraph.createSimpleDeclaration();
        IsSimpleDeclOf newEdge = syntaxgraph.createIsSimpleDeclOf(newSD, parentDecl);
        syntaxgraph.createIsTypeExprOfDeclaration(sd.getFirstIsTypeExprOfDeclarationIncidence(EdgeDirection.IN).getAlpha(), newSD);
        newEdge.getReversedEdge().putIncidenceAfter(oldEdge.getReversedEdge());
        for (Variable var : varsToBeSplit) {
            HashSet<IsDeclaredVarOf> relinkIncs = new HashSet<IsDeclaredVarOf>();
            for (IsDeclaredVarOf inc = sd.getFirstIsDeclaredVarOfIncidence(EdgeDirection.IN); inc != null; inc = inc.getNextIsDeclaredVarOfIncidence(EdgeDirection.IN)) {
                if (inc.getAlpha() != var) continue;
                relinkIncs.add(inc);
            }
            for (IsDeclaredVarOf relinkEdge : relinkIncs) {
                relinkEdge.setOmega(newSD);
            }
        }
        return newSD;
    }
}

