/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.OptimizerInfo;
import de.uni_koblenz.jgralab.greql.exception.OptimizerException;
import de.uni_koblenz.jgralab.greql.funlib.collections.Intersection;
import de.uni_koblenz.jgralab.greql.optimizer.Optimizer;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerBase;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerUtility;
import de.uni_koblenz.jgralab.greql.schema.BoolLiteral;
import de.uni_koblenz.jgralab.greql.schema.Declaration;
import de.uni_koblenz.jgralab.greql.schema.EdgePathDescription;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.FunctionApplication;
import de.uni_koblenz.jgralab.greql.schema.GreqlGraph;
import de.uni_koblenz.jgralab.greql.schema.IsBoundVarOf;
import de.uni_koblenz.jgralab.greql.schema.IsDeclaredVarOf;
import de.uni_koblenz.jgralab.greql.schema.IsPathDescriptionOf;
import de.uni_koblenz.jgralab.greql.schema.PathDescription;
import de.uni_koblenz.jgralab.greql.schema.PathExistence;
import de.uni_koblenz.jgralab.greql.schema.PathExpression;
import de.uni_koblenz.jgralab.greql.schema.SimpleDeclaration;
import de.uni_koblenz.jgralab.greql.schema.TypeId;
import de.uni_koblenz.jgralab.greql.schema.Variable;
import de.uni_koblenz.jgralab.greql.schema.VertexSetExpression;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Logger;

public class PathExistenceToDirectedPathExpressionOptimizer
extends OptimizerBase {
    private static Logger logger = JGraLab.getLogger(PathExistenceToDirectedPathExpressionOptimizer.class);

    public PathExistenceToDirectedPathExpressionOptimizer(OptimizerInfo optimizerInfo) {
        super(optimizerInfo);
    }

    @Override
    public boolean isEquivalent(Optimizer optimizer) {
        return optimizer instanceof PathExistenceToDirectedPathExpressionOptimizer;
    }

    @Override
    public boolean optimize(GreqlQuery query) throws OptimizerException {
        GreqlGraph syntaxgraph = query.getQueryGraph();
        if (syntaxgraph.getFirstVertex(PathExistence.VC) == null) {
            return false;
        }
        LinkedList<PathExistence> pes = new LinkedList<PathExistence>();
        for (PathExistence pe : syntaxgraph.getPathExistenceVertices()) {
            if (this.isInNot(pe)) continue;
            pes.add(pe);
        }
        Iterator it = pes.iterator();
        while (it.hasNext()) {
            PathExistence pe;
            pe = (PathExistence)it.next();
            boolean optimized = this.tryOptimizePathExistence(pe);
            if (optimized) continue;
            it.remove();
        }
        for (PathExistence pe : pes) {
            BoolLiteral lit = syntaxgraph.createBoolLiteral();
            lit.set_boolValue(true);
            while (pe.getFirstIncidence(EdgeDirection.OUT) != null) {
                Edge e = pe.getFirstIncidence(EdgeDirection.OUT);
                e.setAlpha(lit);
                assert (e.getAlpha() == lit);
            }
            pe.delete();
        }
        OptimizerUtility.createMissingSourcePositions(syntaxgraph);
        return !pes.isEmpty();
    }

    private boolean isInNot(Vertex v) {
        FunctionApplication fa;
        if (v instanceof FunctionApplication && (fa = (FunctionApplication)v).get_functionId().get_name().equals("not")) {
            return true;
        }
        for (Edge e : v.incidences(EdgeDirection.OUT)) {
            boolean result = this.isInNot(e.getThat());
            if (!result) continue;
            return result;
        }
        return false;
    }

    private boolean tryOptimizePathExistence(PathExistence pe) {
        SimpleDeclaration startSD;
        Expression startExp = pe.get_startExpr();
        Expression targetExp = pe.get_targetExpr();
        if (!(startExp instanceof Variable) || !(targetExp instanceof Variable)) {
            logger.finer(this.optimizerHeaderString() + "PathExistence hasn't form var1 --> var2, skipping...");
            return false;
        }
        Expression pathDesc = pe.get_path();
        if (!(pathDesc instanceof PathDescription)) {
            logger.finer(this.optimizerHeaderString() + "PathExistence contains an Expression as PathDescription, skipping...");
            return false;
        }
        if (!this.isOptimizablePathDescription((PathDescription)pathDesc)) {
            logger.finer(this.optimizerHeaderString() + "PathExistence contains an EdgePathDescription, skipping...");
            return false;
        }
        Variable start = (Variable)startExp;
        Variable target = (Variable)targetExp;
        if (start == target) {
            logger.finer(this.optimizerHeaderString() + "PathExistence specifies a loop, skipping...");
            return false;
        }
        boolean startIsDeclaredFirst = true;
        if (this.isDeclaredBefore(target, start)) {
            startIsDeclaredFirst = false;
        }
        SimpleDeclaration sd = null;
        Variable sdsVar = null;
        Variable anchorVar = null;
        IsBoundVarOf ibvoStart = start.getFirstIsBoundVarOfIncidence();
        IsBoundVarOf ibvoTarget = target.getFirstIsBoundVarOfIncidence();
        if (ibvoStart != null && ibvoTarget != null) {
            return false;
        }
        if (ibvoStart != null && ibvoTarget == null) {
            anchorVar = start;
            sdsVar = target;
            SimpleDeclaration targetSD = target.getFirstIsDeclaredVarOfIncidence().getOmega();
            sd = targetSD.getDegree(IsDeclaredVarOf.EC) > 1 ? this.splitSimpleDecl(targetSD, target) : targetSD;
        } else if (ibvoStart == null && ibvoTarget != null) {
            anchorVar = target;
            sdsVar = start;
            startSD = start.getFirstIsDeclaredVarOfIncidence().getOmega();
            sd = startSD.getDegree(IsDeclaredVarOf.EC) > 1 ? this.splitSimpleDecl(startSD, target) : startSD;
        } else {
            startSD = start.getFirstIsDeclaredVarOfIncidence().getOmega();
            SimpleDeclaration targetSD = target.getFirstIsDeclaredVarOfIncidence().getOmega();
            if (targetSD == startSD) {
                if (startIsDeclaredFirst) {
                    sd = this.splitSimpleDecl(startSD, target);
                    anchorVar = start;
                    sdsVar = target;
                } else {
                    sd = this.splitSimpleDecl(startSD, start);
                    anchorVar = target;
                    sdsVar = start;
                }
            } else if (startIsDeclaredFirst) {
                sd = targetSD.getDegree(IsDeclaredVarOf.EC) > 1 ? this.splitSimpleDecl(targetSD, target) : targetSD;
                sdsVar = target;
                anchorVar = start;
            } else {
                sd = startSD.getDegree(IsDeclaredVarOf.EC) > 1 ? this.splitSimpleDecl(startSD, start) : startSD;
                anchorVar = target;
                sdsVar = start;
            }
        }
        if (this.isDeclaredBefore(sdsVar, anchorVar)) {
            return false;
        }
        if (!this.isConstraintAndTopLevelConjunction(pe, sd.getFirstIsSimpleDeclOfIncidence().getOmega())) {
            logger.finer(this.optimizerHeaderString() + pe + " cannot be optimized, cause it's not in an constraint conjunction...");
            return false;
        }
        PathDescription path = (PathDescription)pe.get_path();
        Set<Variable> varsUsedInPath = OptimizerUtility.collectInternallyDeclaredVariablesBelow(path);
        if (varsUsedInPath.contains(sdsVar)) {
            logger.finer(this.optimizerHeaderString() + "PathExistence path contains declared var, so skipping...");
            return false;
        }
        for (Variable usedVar : varsUsedInPath) {
            if (!this.isDeclaredBefore(sdsVar, usedVar)) continue;
            logger.finer(this.optimizerHeaderString() + "PathExistence path contains a previously declared var, so skipping...");
            return false;
        }
        Expression typeExp = sd.get_typeExpr();
        if (typeExp instanceof VertexSetExpression) {
            VertexSetExpression vse = (VertexSetExpression)typeExp;
            this.optimizeVertexSetExpression(pe, sd, anchorVar, vse);
            return true;
        }
        sd.getFirstIsTypeExprOfDeclarationIncidence(EdgeDirection.IN).delete();
        GreqlGraph g = (GreqlGraph)typeExp.getGraph();
        FunctionApplication diff = g.createFunctionApplication();
        g.createIsFunctionIdOf(OptimizerUtility.findOrCreateFunctionId(Intersection.class.getSimpleName().toLowerCase(), g), diff);
        diff.add_argument(typeExp);
        sd.add_typeExpr(diff);
        boolean forward = true;
        if (pe.get_targetExpr() == anchorVar) {
            forward = false;
        }
        PathExpression directedVS = this.createForwardOrBackwardVertexSet(forward, anchorVar, path, null);
        diff.add_argument(directedVS);
        return true;
    }

    private boolean isOptimizablePathDescription(PathDescription pd) {
        if (pd instanceof EdgePathDescription) {
            return false;
        }
        for (IsPathDescriptionOf ipdo : pd.getIsPathDescriptionOfIncidences(EdgeDirection.IN)) {
            boolean isOptimizable = this.isOptimizablePathDescription((PathDescription)ipdo.getThat());
            if (isOptimizable) continue;
            return false;
        }
        return true;
    }

    private boolean isConstraintAndTopLevelConjunction(Vertex current, Declaration top) {
        if (current == top) {
            return true;
        }
        if (current instanceof FunctionApplication && OptimizerUtility.isOr((FunctionApplication)current)) {
            return false;
        }
        for (Edge e : current.incidences(EdgeDirection.OUT)) {
            Vertex newCurrent = e.getOmega();
            if (!this.isConstraintAndTopLevelConjunction(newCurrent, top)) continue;
            return true;
        }
        return false;
    }

    private PathExpression createForwardOrBackwardVertexSet(boolean forward, Variable anchor, PathDescription path, Iterable<? extends TypeId> restrictions) {
        GreqlGraph g = (GreqlGraph)path.getGraph();
        PathExpression newPE = null;
        if (forward) {
            newPE = g.createForwardVertexSet();
            newPE.add_path(path);
            if (restrictions != null) {
                for (TypeId typeId : restrictions) {
                    path.add_goalRestr(typeId);
                }
            }
            newPE.add_startExpr(anchor);
        } else {
            newPE = g.createBackwardVertexSet();
            newPE.add_path(path);
            if (restrictions != null) {
                for (TypeId typeId : restrictions) {
                    path.add_startRestr(typeId);
                }
            }
            newPE.add_targetExpr(anchor);
        }
        return newPE;
    }

    private boolean optimizeVertexSetExpression(PathExistence pe, SimpleDeclaration sd, Variable otherVar, VertexSetExpression vse) {
        boolean forward = true;
        if (pe.get_targetExpr() == otherVar) {
            forward = false;
        }
        GreqlGraph g = (GreqlGraph)pe.getGraph();
        PathExpression newPE = this.createForwardOrBackwardVertexSet(forward, otherVar, (PathDescription)pe.get_path(), vse.get_typeRestr());
        if (vse.getDegree(EdgeDirection.OUT) < 2) {
            vse.delete();
        } else {
            sd.getFirstIsTypeExprOfDeclarationIncidence().delete();
        }
        g.createIsTypeExprOfDeclaration(newPE, sd);
        logger.finer(this.optimizerHeaderString() + "Created " + newPE + " as optimization...");
        return true;
    }

    private SimpleDeclaration splitSimpleDecl(SimpleDeclaration sd, Variable var) {
        HashSet<Variable> splitSet = new HashSet<Variable>(1);
        splitSet.add(var);
        return this.splitSimpleDeclaration(sd, splitSet);
    }
}

