/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.OptimizerInfo;
import de.uni_koblenz.jgralab.greql.exception.OptimizerException;
import de.uni_koblenz.jgralab.greql.optimizer.Optimizer;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerBase;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerUtility;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.FunctionApplication;
import de.uni_koblenz.jgralab.greql.schema.FunctionId;
import de.uni_koblenz.jgralab.greql.schema.GreqlGraph;
import de.uni_koblenz.jgralab.greql.schema.IsArgumentOf;
import java.util.ArrayList;
import java.util.logging.Logger;

public class TransformXorFunctionApplicationOptimizer
extends OptimizerBase {
    private static Logger logger = JGraLab.getLogger(TransformXorFunctionApplicationOptimizer.class);

    TransformXorFunctionApplicationOptimizer(OptimizerInfo optimizerInfo) {
        super(optimizerInfo);
    }

    @Override
    public boolean isEquivalent(Optimizer optimizer) {
        return optimizer instanceof TransformXorFunctionApplicationOptimizer;
    }

    @Override
    public boolean optimize(GreqlQuery query) throws OptimizerException {
        GreqlGraph syntaxgraph = query.getQueryGraph();
        ArrayList<FunctionApplication> xors = new ArrayList<FunctionApplication>();
        for (FunctionApplication funApp : syntaxgraph.getFunctionApplicationVertices()) {
            if (!OptimizerUtility.isXor(funApp)) continue;
            xors.add(funApp);
        }
        boolean somethingWasTransformed = false;
        for (FunctionApplication xor : xors) {
            somethingWasTransformed = true;
            IsArgumentOf isArgOf = xor.getFirstIsArgumentOfIncidence(EdgeDirection.IN);
            Expression arg1 = isArgOf.getAlpha();
            isArgOf = isArgOf.getNextIsArgumentOfIncidence(EdgeDirection.IN);
            Expression arg2 = isArgOf.getAlpha();
            FunctionApplication or = syntaxgraph.createFunctionApplication();
            FunctionId orId = OptimizerUtility.findOrCreateFunctionId("or", syntaxgraph);
            syntaxgraph.createIsFunctionIdOf(orId, or);
            FunctionApplication leftAnd = syntaxgraph.createFunctionApplication();
            FunctionApplication rightAnd = syntaxgraph.createFunctionApplication();
            FunctionId andId = OptimizerUtility.findOrCreateFunctionId("and", syntaxgraph);
            syntaxgraph.createIsFunctionIdOf(andId, leftAnd);
            syntaxgraph.createIsFunctionIdOf(andId, rightAnd);
            FunctionApplication leftNot = syntaxgraph.createFunctionApplication();
            FunctionApplication rightNot = syntaxgraph.createFunctionApplication();
            FunctionId notId = OptimizerUtility.findOrCreateFunctionId("not", syntaxgraph);
            syntaxgraph.createIsFunctionIdOf(notId, leftNot);
            syntaxgraph.createIsFunctionIdOf(notId, rightNot);
            syntaxgraph.createIsArgumentOf(leftAnd, or);
            syntaxgraph.createIsArgumentOf(rightAnd, or);
            syntaxgraph.createIsArgumentOf(arg1, leftAnd);
            syntaxgraph.createIsArgumentOf(leftNot, leftAnd);
            syntaxgraph.createIsArgumentOf(arg2, leftNot);
            syntaxgraph.createIsArgumentOf(arg1, rightNot);
            syntaxgraph.createIsArgumentOf(rightNot, rightAnd);
            syntaxgraph.createIsArgumentOf(arg2, rightAnd);
            ArrayList<Edge> edgesToBeRelinked = new ArrayList<Edge>();
            for (Edge e = xor.getFirstIncidence(EdgeDirection.OUT); e != null; e = e.getNextIncidence(EdgeDirection.OUT)) {
                edgesToBeRelinked.add(e);
            }
            for (Edge edge : edgesToBeRelinked) {
                edge.setAlpha(or);
            }
            logger.finer(this.optimizerHeaderString() + "Transformed " + xor + " to (" + arg1 + " & ~" + arg2 + ") | (~" + arg1 + " & " + arg2 + ").");
            xor.delete();
        }
        return somethingWasTransformed;
    }
}

