/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer.condexp;

import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerUtility;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.BinaryOperator;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.False;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.Formula;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.Literal;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.Not;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.True;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.FunctionApplication;
import de.uni_koblenz.jgralab.greql.schema.FunctionId;
import de.uni_koblenz.jgralab.greql.schema.GreqlGraph;

public class And
extends BinaryOperator {
    public And(GreqlQuery query, Formula lhs, Formula rhs) {
        super(query, lhs, rhs);
    }

    @Override
    public String toString() {
        return "(" + this.leftHandSide + " & " + this.rightHandSide + ")";
    }

    @Override
    public Expression toExpression() {
        GreqlGraph syntaxgraph = this.query.getQueryGraph();
        FunctionApplication funApp = syntaxgraph.createFunctionApplication();
        FunctionId funId = OptimizerUtility.findOrCreateFunctionId("and", syntaxgraph);
        syntaxgraph.createIsFunctionIdOf(funId, funApp);
        syntaxgraph.createIsArgumentOf(this.leftHandSide.toExpression(), funApp);
        syntaxgraph.createIsArgumentOf(this.rightHandSide.toExpression(), funApp);
        return funApp;
    }

    @Override
    protected Formula calculateReplacementFormula(Expression exp, Literal literal) {
        return new And(this.query, this.leftHandSide.calculateReplacementFormula(exp, literal), this.rightHandSide.calculateReplacementFormula(exp, literal));
    }

    @Override
    public Formula simplify() {
        Formula rhs;
        Formula lhs = this.leftHandSide.simplify();
        if (lhs.equals(new Not(this.query, rhs = this.rightHandSide.simplify())) || new Not(this.query, lhs).equals(rhs)) {
            return new False(this.query);
        }
        if (lhs instanceof False) {
            return lhs;
        }
        if (rhs instanceof False) {
            return rhs;
        }
        if (lhs instanceof True) {
            return rhs;
        }
        if (rhs instanceof True) {
            return lhs;
        }
        if (lhs.equals(rhs)) {
            return lhs;
        }
        return new And(this.query, lhs, rhs);
    }

    @Override
    public double getSelectivity() {
        double selectivity = this.leftHandSide.getSelectivity() * this.rightHandSide.getSelectivity();
        logger.finer("selectivity[" + this + "] = " + selectivity);
        return selectivity;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof And) {
            And and = (And)o;
            return this.leftHandSide.equals(and.leftHandSide) && this.rightHandSide.equals(and.rightHandSide);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.hashCode(17);
    }
}

