/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer.condexp;

import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.Formula;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.Literal;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.GreqlGraph;
import java.util.ArrayList;

public class ConditionalExpression
extends Formula {
    protected Expression condition;
    protected Formula trueFormula;
    protected Formula falseFormula;

    public ConditionalExpression(GreqlQuery query, Expression condition, Formula trueExp, Formula falseExp) {
        super(query);
        this.condition = condition;
        this.trueFormula = trueExp;
        this.falseFormula = falseExp;
    }

    @Override
    public String toString() {
        return "(v" + this.condition.getId() + ") ? " + this.trueFormula + " : " + this.falseFormula + ";";
    }

    @Override
    public Expression toExpression() {
        GreqlGraph syntaxgraph = this.query.getQueryGraph();
        de.uni_koblenz.jgralab.greql.schema.ConditionalExpression cond = syntaxgraph.createConditionalExpression();
        syntaxgraph.createIsConditionOf(this.condition, cond);
        syntaxgraph.createIsTrueExprOf(this.trueFormula.toExpression(), cond);
        syntaxgraph.createIsFalseExprOf(this.falseFormula.toExpression(), cond);
        return cond;
    }

    @Override
    protected ArrayList<Expression> getNonConstantTermExpressions() {
        throw new UnsupportedOperationException("Intentionally not implemented.");
    }

    @Override
    protected Formula calculateReplacementFormula(Expression exp, Literal literal) {
        throw new UnsupportedOperationException("Intentionally not implemented.");
    }

    @Override
    public Formula simplify() {
        throw new UnsupportedOperationException("Intentionally not implemented.");
    }

    @Override
    public double getSelectivity() {
        throw new UnsupportedOperationException("Intentionally not implemented.");
    }

    @Override
    public boolean equals(Object o) {
        throw new UnsupportedOperationException("Intentionally not implemented.");
    }

    @Override
    public int hashCode() {
        throw new UnsupportedOperationException("Intentionally not implemented.");
    }
}

