/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer.condexp;

import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlQueryImpl;
import de.uni_koblenz.jgralab.greql.evaluator.vertexeval.VertexEvaluator;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.ConditionalExpression;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.Equiv;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.False;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.Formula;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.Not;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.True;
import de.uni_koblenz.jgralab.greql.schema.Expression;

public class ConditionalExpressionUnit {
    private final GreqlQuery query;
    private final Expression condition;
    private final Formula trueFormula;
    private final Formula falseFormula;
    private double influenceCostRatio = -1.0;

    public ConditionalExpressionUnit(Expression exp, Formula origFormula) {
        this.query = origFormula.query;
        this.condition = exp;
        this.trueFormula = origFormula.calculateReplacementFormula(this.condition, new True(this.query)).simplify();
        this.falseFormula = origFormula.calculateReplacementFormula(this.condition, new False(this.query)).simplify();
    }

    private double calculateInfluenceCostRatio() {
        Formula boolDiff = new Not(this.query, new Equiv(this.query, this.trueFormula, new Not(this.query, this.falseFormula)));
        boolDiff = boolDiff.simplify();
        double selectivity = boolDiff.getSelectivity();
        VertexEvaluator<Expression> veval = ((GreqlQueryImpl)this.query).getVertexEvaluator(this.condition);
        long costs = veval.getInitialSubtreeEvaluationCosts();
        return selectivity / (double)costs;
    }

    ConditionalExpression toConditionalExpression() {
        return new ConditionalExpression(this.query, this.condition, this.trueFormula.optimize(), this.falseFormula.optimize());
    }

    public double getInfluenceCostRatio() {
        if (this.influenceCostRatio == -1.0) {
            this.influenceCostRatio = this.calculateInfluenceCostRatio();
        }
        return this.influenceCostRatio;
    }
}

