/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.optimizer.condexp;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.optimizer.OptimizerUtility;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.And;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.ConditionalExpressionUnit;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.False;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.Literal;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.NonConstantTerm;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.Not;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.Or;
import de.uni_koblenz.jgralab.greql.optimizer.condexp.True;
import de.uni_koblenz.jgralab.greql.schema.BoolLiteral;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.FunctionApplication;
import de.uni_koblenz.jgralab.greql.schema.IsArgumentOf;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Logger;

public abstract class Formula {
    private static final int MAX_NON_CONSTANT_TERM_NUMBER = 3;
    protected static Logger logger = JGraLab.getLogger(Formula.class);
    protected GreqlQuery query;

    public abstract String toString();

    public abstract Expression toExpression();

    public static Formula createFormulaFromExpression(Expression exp, GreqlQuery query) {
        Formula formula = Formula.createFormulaFromExpressionInternal(query, exp);
        OptimizerUtility.deleteOrphanedVerticesBelow(exp, new HashSet<Vertex>(formula.getNonConstantTermExpressions()));
        return formula;
    }

    public Formula(GreqlQuery query) {
        this.query = query;
    }

    private static Formula createFormulaFromExpressionInternal(GreqlQuery query, Expression exp) {
        assert (exp.isValid()) : exp + " is not valid!";
        if (exp instanceof BoolLiteral) {
            BoolLiteral bool = (BoolLiteral)exp;
            if (bool.is_boolValue()) {
                return new True(query);
            }
            return new False(query);
        }
        if (exp instanceof FunctionApplication) {
            FunctionApplication funApp = (FunctionApplication)exp;
            if (OptimizerUtility.isAnd(funApp)) {
                IsArgumentOf inc = funApp.getFirstIsArgumentOfIncidence(EdgeDirection.IN);
                Expression leftArg = inc.getAlpha();
                Expression rightArg = inc.getNextIsArgumentOfIncidence(EdgeDirection.IN).getAlpha();
                return new And(query, Formula.createFormulaFromExpressionInternal(query, leftArg), Formula.createFormulaFromExpressionInternal(query, rightArg));
            }
            if (OptimizerUtility.isOr(funApp)) {
                IsArgumentOf inc = funApp.getFirstIsArgumentOfIncidence(EdgeDirection.IN);
                Expression leftArg = inc.getAlpha();
                Expression rightArg = inc.getNextIsArgumentOfIncidence(EdgeDirection.IN).getAlpha();
                return new Or(query, Formula.createFormulaFromExpressionInternal(query, leftArg), Formula.createFormulaFromExpressionInternal(query, rightArg));
            }
            if (OptimizerUtility.isNot(funApp)) {
                IsArgumentOf inc = funApp.getFirstIsArgumentOfIncidence(EdgeDirection.IN);
                Expression arg = inc.getAlpha();
                return new Not(query, Formula.createFormulaFromExpressionInternal(query, arg));
            }
        }
        return new NonConstantTerm(query, exp);
    }

    public Formula optimize() {
        ArrayList<Expression> nctExpressions = this.getNonConstantTermExpressions();
        if (nctExpressions.size() < 2) {
            return this;
        }
        ConditionalExpressionUnit bestUnit = this.calculateBestConditionalExpressionUnit(nctExpressions);
        return bestUnit.toConditionalExpression();
    }

    private ConditionalExpressionUnit calculateBestConditionalExpressionUnit(ArrayList<Expression> nonConstantTermExpressions) {
        if (nonConstantTermExpressions.size() > 3) {
            logger.fine("Formula: " + nonConstantTermExpressions.size() + " NCTEs ==> shortcutting...");
            return new ConditionalExpressionUnit(nonConstantTermExpressions.get(0), this);
        }
        ConditionalExpressionUnit best = null;
        for (Expression exp : nonConstantTermExpressions) {
            ConditionalExpressionUnit current = new ConditionalExpressionUnit(exp, this);
            if (best == null) {
                best = current;
            }
            if (best != null && !(best.getInfluenceCostRatio() < current.getInfluenceCostRatio())) continue;
            best = current;
        }
        return best;
    }

    protected abstract ArrayList<Expression> getNonConstantTermExpressions();

    protected abstract Formula calculateReplacementFormula(Expression var1, Literal var2);

    public abstract Formula simplify();

    public abstract double getSelectivity();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();
}

