/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.parallel;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.greql.GreqlEnvironment;
import de.uni_koblenz.jgralab.greql.parallel.ParallelGreqlEvaluator;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public class EvaluationEnvironment {
    Graph datagraph;
    GreqlEnvironment greqlEnvironment;
    ExecutorService executor;
    Exception exception;
    HashMap<ParallelGreqlEvaluator.TaskHandle, Integer> inDegree = new HashMap();
    HashMap<ParallelGreqlEvaluator.TaskHandle, ParallelGreqlEvaluator.EvaluationTask> tasks = new HashMap();
    long startTime;
    long doneTime;
    boolean sequentially;

    EvaluationEnvironment(boolean sequentially) {
        this.sequentially = sequentially;
    }

    public GreqlEnvironment getGreqlEnvironment() {
        return this.greqlEnvironment;
    }

    public Graph getDatagraph() {
        return this.datagraph;
    }

    public Object getResult(ParallelGreqlEvaluator.TaskHandle handle) {
        ParallelGreqlEvaluator.EvaluationTask t = this.tasks.get(handle);
        if (!t.isDone()) {
            throw new IllegalStateException(handle + " is not yet done.");
        }
        if (!this.tasks.containsKey(handle)) {
            throw new IllegalArgumentException(handle + " does not belong to this EvaluationEnvironment.");
        }
        try {
            return this.tasks.get(handle).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public long getEvaluationTime() {
        return this.doneTime - this.startTime;
    }

    public long getEvaluationTime(ParallelGreqlEvaluator.TaskHandle handle) {
        return this.tasks.get(handle).getEvaluationTime();
    }
}

