/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.parser;

import de.uni_koblenz.jgralab.greql.exception.ParsingException;
import de.uni_koblenz.jgralab.greql.parser.ComplexToken;
import de.uni_koblenz.jgralab.greql.parser.DoubleToken;
import de.uni_koblenz.jgralab.greql.parser.LongToken;
import de.uni_koblenz.jgralab.greql.parser.SimpleToken;
import de.uni_koblenz.jgralab.greql.parser.Token;
import de.uni_koblenz.jgralab.greql.parser.TokenTypes;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GreqlLexer {
    protected static final Map<TokenTypes, String> fixedTokens = Collections.unmodifiableMap(new EnumMap<TokenTypes, String>(TokenTypes.class){
        {
            this.put(TokenTypes.TRANSPOSED, "^T");
            this.put(TokenTypes.AND, "and");
            this.put(TokenTypes.FALSE, "false");
            this.put(TokenTypes.NOT, "not");
            this.put(TokenTypes.UNDEFINED, "undefined");
            this.put(TokenTypes.OR, "or");
            this.put(TokenTypes.TRUE, "true");
            this.put(TokenTypes.XOR, "xor");
            this.put(TokenTypes.AS, "as");
            this.put(TokenTypes.MAP, "map");
            this.put(TokenTypes.E, "E");
            this.put(TokenTypes.EXISTS_ONE, "exists!");
            this.put(TokenTypes.EXISTS, "exists");
            this.put(TokenTypes.END, "end");
            this.put(TokenTypes.FORALL, "forall");
            this.put(TokenTypes.FROM, "from");
            this.put(TokenTypes.IN, "in");
            this.put(TokenTypes.ON, "on");
            this.put(TokenTypes.LET, "let");
            this.put(TokenTypes.LIST, "list");
            this.put(TokenTypes.REC, "rec");
            this.put(TokenTypes.REPORT, "report");
            this.put(TokenTypes.REPORTSET, "reportSet");
            this.put(TokenTypes.REPORTSETN, "reportSetN");
            this.put(TokenTypes.REPORTLIST, "reportList");
            this.put(TokenTypes.REPORTLISTN, "reportListN");
            this.put(TokenTypes.REPORTMAP, "reportMap");
            this.put(TokenTypes.REPORTMAPN, "reportMapN");
            this.put(TokenTypes.STORE, "store");
            this.put(TokenTypes.SET, "set");
            this.put(TokenTypes.TUP, "tup");
            this.put(TokenTypes.USING, "using");
            this.put(TokenTypes.V, "V");
            this.put(TokenTypes.WHERE, "where");
            this.put(TokenTypes.WITH, "with");
            this.put(TokenTypes.QUESTION, "?");
            this.put(TokenTypes.EXCL, "!");
            this.put(TokenTypes.COLON, ":");
            this.put(TokenTypes.COMMA, ",");
            this.put(TokenTypes.DOT, ".");
            this.put(TokenTypes.DOTDOT, "..");
            this.put(TokenTypes.AT, "@");
            this.put(TokenTypes.LPAREN, "(");
            this.put(TokenTypes.RPAREN, ")");
            this.put(TokenTypes.LBRACK, "[");
            this.put(TokenTypes.RBRACK, "]");
            this.put(TokenTypes.LCURLY, "{");
            this.put(TokenTypes.RCURLY, "}");
            this.put(TokenTypes.EDGESTART, "<-");
            this.put(TokenTypes.EDGEEND, "->");
            this.put(TokenTypes.EDGE, "--");
            this.put(TokenTypes.RARROW, "-->");
            this.put(TokenTypes.LARROW, "<--");
            this.put(TokenTypes.ARROW, "<->");
            this.put(TokenTypes.ASSIGN, ":=");
            this.put(TokenTypes.EQUAL, "=");
            this.put(TokenTypes.MATCH, "=~");
            this.put(TokenTypes.NOT_EQUAL, "<>");
            this.put(TokenTypes.LE, "<=");
            this.put(TokenTypes.GE, ">=");
            this.put(TokenTypes.L_T, "<");
            this.put(TokenTypes.G_T, ">");
            this.put(TokenTypes.DIV, "/");
            this.put(TokenTypes.PLUS, "+");
            this.put(TokenTypes.MINUS, "-");
            this.put(TokenTypes.STAR, "*");
            this.put(TokenTypes.MOD, "%");
            this.put(TokenTypes.PLUSPLUS, "++");
            this.put(TokenTypes.SEMI, ";");
            this.put(TokenTypes.CARET, "^");
            this.put(TokenTypes.BOR, "|");
            this.put(TokenTypes.AMP, "&");
            this.put(TokenTypes.SMILEY, ":-)");
            this.put(TokenTypes.HASH, "#");
            this.put(TokenTypes.OUTAGGREGATION, "<>--");
            this.put(TokenTypes.INAGGREGATION, "--<>");
            this.put(TokenTypes.PATHSYSTEMSTART, "-<");
            this.put(TokenTypes.IMPORT, "import");
            this.put(TokenTypes.POS_INFINITY, "POSITIVE_INFINITY");
            this.put(TokenTypes.NEG_INFINITY, "NEGATIVE_INFINITY");
            this.put(TokenTypes.NOT_A_NUMBER, "NaN");
        }
    });
    protected static Map<String, TokenTypes> stringToTokenMap = new HashMap<String, TokenTypes>();
    protected static BitSet separators = new BitSet();
    protected String query;
    protected int position;

    public GreqlLexer(String source) {
        Character[] sepArray;
        for (Map.Entry<TokenTypes, String> entry : fixedTokens.entrySet()) {
            stringToTokenMap.put(entry.getValue(), entry.getKey());
        }
        for (Character sep : sepArray = new Character[]{Character.valueOf(';'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf(':'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf(','), Character.valueOf(' '), Character.valueOf('\n'), Character.valueOf('\t'), Character.valueOf('.'), Character.valueOf('-'), Character.valueOf('+'), Character.valueOf('*'), Character.valueOf('/'), Character.valueOf('%'), Character.valueOf('='), Character.valueOf('?'), Character.valueOf('^'), Character.valueOf('|'), Character.valueOf('!'), Character.valueOf('@')}) {
            separators.set(sep.charValue());
        }
        this.query = null;
        this.position = 0;
        this.query = source;
        if (this.query == null) {
            throw new NullPointerException("Cannot parse nullpointer as GReQL query");
        }
    }

    public static String getTokenString(TokenTypes token) {
        return fixedTokens.get((Object)token);
    }

    private static final boolean isSeparator(int c) {
        return separators.get(c);
    }

    public Token getNextToken() {
        TokenTypes recognizedTokenType = null;
        Token recognizedToken = null;
        int bml = 0;
        this.skipWs();
        int currLength = 1;
        for (int i = 0; i < 4; ++i) {
            while (this.position + currLength < this.query.length() - 1 && !GreqlLexer.isSeparator(this.query.charAt(this.position + currLength)) && !GreqlLexer.isSeparator(this.query.charAt(this.position + currLength - 1))) {
                ++currLength;
            }
            String currentTokenString = this.position + currLength < this.query.length() ? this.query.substring(this.position, this.position + currLength) : this.query.substring(this.position);
            TokenTypes possibleToken = stringToTokenMap.get(currentTokenString);
            if (possibleToken != null) {
                recognizedTokenType = possibleToken;
                bml = currentTokenString.length();
            }
            ++currLength;
        }
        if (recognizedTokenType == null) {
            char separator = this.query.charAt(this.position);
            if (separator == '\"' || separator == '\'') {
                ++this.position;
                int start = this.position;
                StringBuilder sb = new StringBuilder();
                while (this.position < this.query.length() && this.query.charAt(this.position) != separator) {
                    if (this.query.charAt(this.position) == '\\') {
                        if (this.position == this.query.length()) {
                            throw new ParsingException("String started at position " + start + " but is not closed in query", this.query.substring(start, this.position), start, this.position - start, this.query);
                        }
                        if (this.query.charAt(this.position + 1) == separator || this.query.charAt(this.position + 1) == '\\') {
                            ++this.position;
                        }
                    }
                    sb.append(this.query.charAt(this.position));
                    ++this.position;
                }
                if (this.position >= this.query.length() || this.query.charAt(this.position) != separator) {
                    throw new ParsingException("String started at position " + start + " but is not closed in query", sb.toString(), start, this.position - start, this.query);
                }
                recognizedTokenType = TokenTypes.STRING;
                recognizedToken = new ComplexToken(recognizedTokenType, start, this.position, sb.toString());
                ++this.position;
            } else {
                char c = this.query.charAt(this.position);
                if (this.isNumber(c)) {
                    Matcher m = Pattern.compile("(0[xX][0-9A-Fa-f]+)|([0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?)").matcher(this.query.substring(this.position));
                    m.lookingAt();
                    int end = m.end() + this.position;
                    this.position += m.end();
                    String matchedString = m.group();
                    if (matchedString.startsWith("0x") || matchedString.startsWith("0X")) {
                        Long hexValue = Long.parseLong(matchedString.substring(2), 16);
                        return new LongToken(TokenTypes.LONGLITERAL, this.position, end, matchedString, hexValue);
                    }
                    if (matchedString.startsWith("0")) {
                        try {
                            Long octValue = Long.parseLong(matchedString.substring(1), 8);
                            return new LongToken(TokenTypes.LONGLITERAL, this.position, end, matchedString, octValue);
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    try {
                        Long decValue = Long.parseLong(matchedString);
                        return new LongToken(TokenTypes.LONGLITERAL, this.position, end, matchedString, decValue);
                    }
                    catch (Exception ex) {
                        Double doubleValue = Double.parseDouble(matchedString);
                        return new DoubleToken(TokenTypes.DOUBLELITERAL, this.position, end, matchedString, doubleValue);
                    }
                }
                StringBuilder nextPossibleToken = new StringBuilder();
                int start = this.position;
                while (this.query.length() > this.position && !GreqlLexer.isSeparator(this.query.charAt(this.position))) {
                    nextPossibleToken.append(this.query.charAt(this.position++));
                }
                if (this.query.length() < this.position) {
                    return new SimpleToken(TokenTypes.EOF, start, 0);
                }
                String tokenText = nextPossibleToken.toString();
                recognizedToken = tokenText.equals("thisVertex") ? new ComplexToken(TokenTypes.THISVERTEX, start, this.position - start, tokenText) : (tokenText.equals("thisEdge") ? new ComplexToken(TokenTypes.THISEDGE, start, this.position - start, tokenText) : (tokenText.equals(fixedTokens.get((Object)TokenTypes.POS_INFINITY)) || tokenText.equals(fixedTokens.get((Object)TokenTypes.NEG_INFINITY)) || tokenText.equals(fixedTokens.get((Object)TokenTypes.NOT_A_NUMBER)) ? this.matchDoubleConstantToken(start, this.position - start, tokenText) : new ComplexToken(TokenTypes.IDENTIFIER, start, this.position - start, tokenText)));
            }
        } else {
            recognizedToken = new SimpleToken(recognizedTokenType, this.position, bml);
            this.position += bml;
        }
        if (recognizedToken == null) {
            throw new ParsingException("Error while scanning query at position", null, this.position, this.position, this.query);
        }
        return recognizedToken;
    }

    private final Token matchDoubleConstantToken(int start, int i, String tokenText) {
        Double value = Double.parseDouble(tokenText);
        return new DoubleToken(TokenTypes.DOUBLELITERAL, start, i, tokenText, value);
    }

    private final boolean isNumber(char c) {
        return c >= Character.valueOf('0').charValue() && c <= Character.valueOf('9').charValue();
    }

    public boolean hasNextToken() {
        this.skipWs();
        return this.position < this.query.length();
    }

    private static final boolean isWs(int c) {
        return c == 32 || c == 10 || c == 9 || c == 13;
    }

    private final void skipWs() {
        while (true) {
            if (this.position < this.query.length() && GreqlLexer.isWs(this.query.charAt(this.position))) {
                ++this.position;
                continue;
            }
            if (this.position < this.query.length() - 2 && this.query.substring(this.position, this.position + 2).equals("//")) {
                ++this.position;
                while (this.position < this.query.length() && this.query.charAt(this.position) != '\n') {
                    ++this.position;
                }
                if (this.position < this.query.length() && this.query.charAt(this.position) == '\n') {
                    ++this.position;
                }
            }
            if (this.position < this.query.length() - 4 && this.query.substring(this.position, this.position + 2).equals("/*")) {
                ++this.position;
                while (this.position < this.query.length() - 1 && this.query.substring(this.position, this.position + 2).equals("*/")) {
                    ++this.position;
                }
                if (this.position < this.query.length() && this.query.substring(this.position, this.position + 2).equals("*/")) {
                    this.position += 2;
                }
            }
            if (!(this.position < this.query.length() && GreqlLexer.isWs(this.query.charAt(this.position)) || this.position < this.query.length() - 2 && this.query.substring(this.position, this.position + 2).equals("//") || this.position < this.query.length() - 4 && this.query.substring(this.position, this.position + 2).equals("/*"))) break;
        }
    }

    public static List<Token> scan(String query) {
        ArrayList<Token> list = new ArrayList<Token>();
        GreqlLexer lexer = new GreqlLexer(query);
        while (lexer.hasNextToken()) {
            Token nextToken = lexer.getNextToken();
            list.add(nextToken);
        }
        if (list.isEmpty() || ((Token)list.get((int)(list.size() - 1))).type != TokenTypes.EOF) {
            list.add(new SimpleToken(TokenTypes.EOF, lexer.position, 0));
        }
        return list;
    }
}

