/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.parser;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.ImplementationType;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.exception.DuplicateVariableException;
import de.uni_koblenz.jgralab.greql.exception.ParsingException;
import de.uni_koblenz.jgralab.greql.funlib.FunLib;
import de.uni_koblenz.jgralab.greql.parser.DoubleToken;
import de.uni_koblenz.jgralab.greql.parser.GreqlLexer;
import de.uni_koblenz.jgralab.greql.parser.LongToken;
import de.uni_koblenz.jgralab.greql.parser.ParserHelper;
import de.uni_koblenz.jgralab.greql.parser.RuleEnum;
import de.uni_koblenz.jgralab.greql.parser.SimpleSymbolTable;
import de.uni_koblenz.jgralab.greql.parser.SymbolTable;
import de.uni_koblenz.jgralab.greql.parser.Token;
import de.uni_koblenz.jgralab.greql.parser.TokenTypes;
import de.uni_koblenz.jgralab.greql.parser.VertexPosition;
import de.uni_koblenz.jgralab.greql.schema.AggregationPathDescription;
import de.uni_koblenz.jgralab.greql.schema.AlternativePathDescription;
import de.uni_koblenz.jgralab.greql.schema.BackwardVertexSet;
import de.uni_koblenz.jgralab.greql.schema.BoolLiteral;
import de.uni_koblenz.jgralab.greql.schema.Comprehension;
import de.uni_koblenz.jgralab.greql.schema.ConditionalExpression;
import de.uni_koblenz.jgralab.greql.schema.Declaration;
import de.uni_koblenz.jgralab.greql.schema.Definition;
import de.uni_koblenz.jgralab.greql.schema.Direction;
import de.uni_koblenz.jgralab.greql.schema.DoubleLiteral;
import de.uni_koblenz.jgralab.greql.schema.EdgePathDescription;
import de.uni_koblenz.jgralab.greql.schema.EdgeRestriction;
import de.uni_koblenz.jgralab.greql.schema.ElementSetExpression;
import de.uni_koblenz.jgralab.greql.schema.ExponentiatedPathDescription;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.ExpressionDefinedSubgraph;
import de.uni_koblenz.jgralab.greql.schema.ForwardVertexSet;
import de.uni_koblenz.jgralab.greql.schema.FunctionApplication;
import de.uni_koblenz.jgralab.greql.schema.FunctionId;
import de.uni_koblenz.jgralab.greql.schema.GReQLDirection;
import de.uni_koblenz.jgralab.greql.schema.GreqlAggregation;
import de.uni_koblenz.jgralab.greql.schema.GreqlExpression;
import de.uni_koblenz.jgralab.greql.schema.GreqlGraph;
import de.uni_koblenz.jgralab.greql.schema.GreqlSchema;
import de.uni_koblenz.jgralab.greql.schema.Identifier;
import de.uni_koblenz.jgralab.greql.schema.IntLiteral;
import de.uni_koblenz.jgralab.greql.schema.IntermediateVertexPathDescription;
import de.uni_koblenz.jgralab.greql.schema.IsAlternativePathOf;
import de.uni_koblenz.jgralab.greql.schema.IsArgumentOf;
import de.uni_koblenz.jgralab.greql.schema.IsBooleanPredicateOfEdgeRestriction;
import de.uni_koblenz.jgralab.greql.schema.IsBoundExprOfDefinition;
import de.uni_koblenz.jgralab.greql.schema.IsBoundExprOfQuantifiedExpression;
import de.uni_koblenz.jgralab.greql.schema.IsBoundVarOf;
import de.uni_koblenz.jgralab.greql.schema.IsCompDeclOf;
import de.uni_koblenz.jgralab.greql.schema.IsCompResultDefOf;
import de.uni_koblenz.jgralab.greql.schema.IsConditionOf;
import de.uni_koblenz.jgralab.greql.schema.IsConstraintOf;
import de.uni_koblenz.jgralab.greql.schema.IsDeclaredVarOf;
import de.uni_koblenz.jgralab.greql.schema.IsDefinitionOf;
import de.uni_koblenz.jgralab.greql.schema.IsDirectionOf;
import de.uni_koblenz.jgralab.greql.schema.IsEdgeExprOf;
import de.uni_koblenz.jgralab.greql.schema.IsEdgeRestrOf;
import de.uni_koblenz.jgralab.greql.schema.IsExponentOf;
import de.uni_koblenz.jgralab.greql.schema.IsExponentiatedPathOf;
import de.uni_koblenz.jgralab.greql.schema.IsExprOf;
import de.uni_koblenz.jgralab.greql.schema.IsExpressionOnSubgraph;
import de.uni_koblenz.jgralab.greql.schema.IsFalseExprOf;
import de.uni_koblenz.jgralab.greql.schema.IsFirstValueOf;
import de.uni_koblenz.jgralab.greql.schema.IsFunctionIdOf;
import de.uni_koblenz.jgralab.greql.schema.IsGoalRestrOf;
import de.uni_koblenz.jgralab.greql.schema.IsIdOfStoreClause;
import de.uni_koblenz.jgralab.greql.schema.IsIntermediateVertexOf;
import de.uni_koblenz.jgralab.greql.schema.IsIteratedPathOf;
import de.uni_koblenz.jgralab.greql.schema.IsKeyExprOfComprehension;
import de.uni_koblenz.jgralab.greql.schema.IsKeyExprOfConstruction;
import de.uni_koblenz.jgralab.greql.schema.IsLastValueOf;
import de.uni_koblenz.jgralab.greql.schema.IsOptionalPathOf;
import de.uni_koblenz.jgralab.greql.schema.IsPartOf;
import de.uni_koblenz.jgralab.greql.schema.IsPathOf;
import de.uni_koblenz.jgralab.greql.schema.IsQuantifiedDeclOf;
import de.uni_koblenz.jgralab.greql.schema.IsQuantifierOf;
import de.uni_koblenz.jgralab.greql.schema.IsQueryExprOf;
import de.uni_koblenz.jgralab.greql.schema.IsRecordElementOf;
import de.uni_koblenz.jgralab.greql.schema.IsRecordExprOf;
import de.uni_koblenz.jgralab.greql.schema.IsRecordIdOf;
import de.uni_koblenz.jgralab.greql.schema.IsRoleIdOf;
import de.uni_koblenz.jgralab.greql.schema.IsSequenceElementOf;
import de.uni_koblenz.jgralab.greql.schema.IsSimpleDeclOf;
import de.uni_koblenz.jgralab.greql.schema.IsStartExprOf;
import de.uni_koblenz.jgralab.greql.schema.IsStartRestrOf;
import de.uni_koblenz.jgralab.greql.schema.IsSubPathOf;
import de.uni_koblenz.jgralab.greql.schema.IsSubgraphDefiningExpression;
import de.uni_koblenz.jgralab.greql.schema.IsSubgraphDefinitionOf;
import de.uni_koblenz.jgralab.greql.schema.IsTableHeaderOf;
import de.uni_koblenz.jgralab.greql.schema.IsTargetExprOf;
import de.uni_koblenz.jgralab.greql.schema.IsTransposedPathOf;
import de.uni_koblenz.jgralab.greql.schema.IsTrueExprOf;
import de.uni_koblenz.jgralab.greql.schema.IsTypeExprOfDeclaration;
import de.uni_koblenz.jgralab.greql.schema.IsTypeExprOfFunction;
import de.uni_koblenz.jgralab.greql.schema.IsTypeIdOf;
import de.uni_koblenz.jgralab.greql.schema.IsTypeRestrOfExpression;
import de.uni_koblenz.jgralab.greql.schema.IsValueExprOfComprehension;
import de.uni_koblenz.jgralab.greql.schema.IsValueExprOfConstruction;
import de.uni_koblenz.jgralab.greql.schema.IsVarOf;
import de.uni_koblenz.jgralab.greql.schema.IteratedPathDescription;
import de.uni_koblenz.jgralab.greql.schema.IterationType;
import de.uni_koblenz.jgralab.greql.schema.LetExpression;
import de.uni_koblenz.jgralab.greql.schema.ListComprehension;
import de.uni_koblenz.jgralab.greql.schema.ListRangeConstruction;
import de.uni_koblenz.jgralab.greql.schema.LongLiteral;
import de.uni_koblenz.jgralab.greql.schema.MapComprehension;
import de.uni_koblenz.jgralab.greql.schema.MapConstruction;
import de.uni_koblenz.jgralab.greql.schema.OptionalPathDescription;
import de.uni_koblenz.jgralab.greql.schema.PathDescription;
import de.uni_koblenz.jgralab.greql.schema.PathExistence;
import de.uni_koblenz.jgralab.greql.schema.PrimaryPathDescription;
import de.uni_koblenz.jgralab.greql.schema.QuantificationType;
import de.uni_koblenz.jgralab.greql.schema.QuantifiedExpression;
import de.uni_koblenz.jgralab.greql.schema.Quantifier;
import de.uni_koblenz.jgralab.greql.schema.RecordConstruction;
import de.uni_koblenz.jgralab.greql.schema.RecordElement;
import de.uni_koblenz.jgralab.greql.schema.RecordId;
import de.uni_koblenz.jgralab.greql.schema.RoleId;
import de.uni_koblenz.jgralab.greql.schema.SequentialPathDescription;
import de.uni_koblenz.jgralab.greql.schema.SimpleDeclaration;
import de.uni_koblenz.jgralab.greql.schema.SimplePathDescription;
import de.uni_koblenz.jgralab.greql.schema.SourcePosition;
import de.uni_koblenz.jgralab.greql.schema.StringLiteral;
import de.uni_koblenz.jgralab.greql.schema.SubgraphDefinition;
import de.uni_koblenz.jgralab.greql.schema.SubgraphRestrictedExpression;
import de.uni_koblenz.jgralab.greql.schema.ThisEdge;
import de.uni_koblenz.jgralab.greql.schema.ThisVertex;
import de.uni_koblenz.jgralab.greql.schema.TransposedPathDescription;
import de.uni_koblenz.jgralab.greql.schema.TupleConstruction;
import de.uni_koblenz.jgralab.greql.schema.TypeId;
import de.uni_koblenz.jgralab.greql.schema.TypeOrRoleId;
import de.uni_koblenz.jgralab.greql.schema.UndefinedLiteral;
import de.uni_koblenz.jgralab.greql.schema.ValueConstruction;
import de.uni_koblenz.jgralab.greql.schema.Variable;
import de.uni_koblenz.jgralab.greql.schema.WhereExpression;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.pcollections.PSet;
import org.pcollections.PVector;

public class GreqlParser
extends ParserHelper {
    private static final GreqlSchema SCHEMA = GreqlSchema.instance();
    private final Map<RuleEnum, int[]> testedRules = new HashMap<RuleEnum, int[]>();
    private List<Token> tokens = null;
    private int current = 0;
    private int farestOffset = 0;
    private ParsingException farestException = null;
    private final Stack<Integer> parsingStack;
    private final Stack<Boolean> predicateStack;
    private boolean predicateFulfilled = true;
    private Set<String> subQueryNames = null;

    public final Set<String> getValidVariables() {
        return this.duringParsingvariableSymbolTable.getKnownIdentifierSet();
    }

    private final void ruleSucceeds(RuleEnum rule, int pos) {
        int[] maySucceedArray = this.testedRules.get((Object)rule);
        maySucceedArray[pos] = this.current;
    }

    private final int alreadySucceeded(RuleEnum rule) {
        int[] maySucceedArray = this.testedRules.get((Object)rule);
        if (maySucceedArray == null) {
            maySucceedArray = new int[this.tokens.size() + 1];
            for (int i = 0; i < maySucceedArray.length; ++i) {
                maySucceedArray[i] = -1;
            }
            this.testedRules.put(rule, maySucceedArray);
        }
        int positionOfTokenAfterRule = maySucceedArray[this.current];
        if (this.inPredicateMode()) {
            if (positionOfTokenAfterRule == -1) {
                maySucceedArray[this.current] = -2;
            } else {
                if (positionOfTokenAfterRule == -2) {
                    this.fail("Rule " + rule.toString() + " already tested at position " + this.current + " Current Token " + (Object)((Object)this.lookAhead(0)));
                    return -2;
                }
                this.current = positionOfTokenAfterRule;
                return -1;
            }
        }
        return this.current;
    }

    private final boolean skipRule(int pos) {
        return pos < 0 && this.inPredicateMode();
    }

    public GreqlParser(String source) {
        this(source, null);
    }

    public GreqlParser(String source, Set<String> subQueryNames) {
        this.query = source;
        this.parsingStack = new Stack();
        this.predicateStack = new Stack();
        this.graph = SCHEMA.createGreqlGraph(ImplementationType.STANDARD);
        this.tokens = GreqlLexer.scan(source);
        this.afterParsingvariableSymbolTable = new SymbolTable();
        this.duringParsingvariableSymbolTable = new SimpleSymbolTable();
        this.duringParsingvariableSymbolTable.blockBegin();
        this.functionSymbolTable = new HashMap();
        this.graphCleaned = false;
        this.lookAhead = this.tokens.get(0);
        this.subQueryNames = subQueryNames;
    }

    protected final boolean isFunctionName(String ident) {
        return this.subQueryNames != null && this.subQueryNames.contains(ident) || FunLib.contains(ident);
    }

    public void parse() {
        try {
            this.parseQuery();
        }
        catch (ParsingException ex) {
            if (this.farestException != null) {
                throw this.farestException;
            }
            throw ex;
        }
    }

    @Override
    protected void debug(String s) {
        for (int i = 0; i < this.parsingStack.size(); ++i) {
            System.out.print("    ");
        }
        System.out.println(s);
    }

    private final TokenTypes lookAhead(int i) {
        if (this.current + i < this.tokens.size()) {
            return this.tokens.get((int)(this.current + i)).type;
        }
        return TokenTypes.EOF;
    }

    protected final PVector<SourcePosition> createSourcePositionList(int startOffset) {
        PVector list = JGraLab.vector();
        return list.plus(new SourcePosition(this.getCurrentOffset() - startOffset, startOffset));
    }

    public static GreqlGraph parse(String query) {
        return GreqlParser.parse(query, null);
    }

    public static GreqlGraph parse(String query, Set<String> subQueryNames) {
        GreqlParser parser = new GreqlParser(query, subQueryNames);
        parser.parse();
        return parser.getGraph();
    }

    private final ValueConstruction createPartsOfValueConstruction(List<VertexPosition<Expression>> expressions, ValueConstruction parent) {
        return (ValueConstruction)this.createMultipleEdgesToParent(expressions, parent, IsPartOf.EC);
    }

    private final Vertex createMultipleEdgesToParent(List<VertexPosition<Expression>> expressions, Vertex parent, EdgeClass edgeClass) {
        if (expressions != null) {
            for (VertexPosition<Expression> expr : expressions) {
                GreqlAggregation edge = (GreqlAggregation)this.graph.createEdge(edgeClass, (Vertex)expr.node, parent);
                edge.set_sourcePositions(this.createSourcePositionList(expr.length, expr.offset));
            }
        }
        return parent;
    }

    private final Vertex createMultipleEdgesToParent(List<VertexPosition<TypeId>> expressions, Vertex parent, EdgeClass edgeClass, int i) {
        if (expressions != null) {
            for (VertexPosition<TypeId> expr : expressions) {
                GreqlAggregation edge = (GreqlAggregation)this.graph.createEdge(edgeClass, (Vertex)expr.node, parent);
                edge.set_sourcePositions(this.createSourcePositionList(expr.length, expr.offset));
            }
        }
        return parent;
    }

    private final Vertex createMultipleEdgesToParent(List<VertexPosition<SimpleDeclaration>> expressions, Vertex parent, EdgeClass edgeClass, boolean b) {
        if (expressions != null) {
            for (VertexPosition<SimpleDeclaration> expr : expressions) {
                GreqlAggregation edge = (GreqlAggregation)this.graph.createEdge(edgeClass, (Vertex)expr.node, parent);
                edge.set_sourcePositions(this.createSourcePositionList(expr.length, expr.offset));
            }
        }
        return parent;
    }

    private final Vertex createMultipleEdgesToParent(List<VertexPosition<Variable>> expressions, Vertex parent, EdgeClass edgeClass, String s) {
        if (expressions != null) {
            for (VertexPosition<Variable> expr : expressions) {
                GreqlAggregation edge = (GreqlAggregation)this.graph.createEdge(edgeClass, (Vertex)expr.node, parent);
                edge.set_sourcePositions(this.createSourcePositionList(expr.length, expr.offset));
            }
        }
        return parent;
    }

    private final void predicateStart() {
        this.parsingStack.push(this.current);
        this.predicateStack.push(this.predicateFulfilled);
        this.predicateFulfilled = true;
    }

    private final void match() {
        ++this.current;
        this.lookAhead = this.current < this.tokens.size() ? this.tokens.get(this.current) : null;
    }

    @Override
    protected boolean inPredicateMode() {
        return !this.predicateStack.isEmpty();
    }

    private final boolean predicateHolds() {
        return this.predicateFulfilled;
    }

    private final boolean predicateEnd() {
        this.current = this.parsingStack.pop();
        this.lookAhead = this.current < this.tokens.size() ? this.tokens.get(this.current) : null;
        boolean success = this.predicateFulfilled;
        this.predicateFulfilled = this.predicateStack.pop();
        return success;
    }

    private final void fail(String msg) {
        int offset = this.query.length();
        int length = -1;
        String tokenText = "";
        if (this.lookAhead != null) {
            offset = this.lookAhead.getOffset();
            length = this.lookAhead.getLength();
            tokenText = this.lookAhead.getValue();
        } else {
            tokenText = this.lookAhead(0).name();
        }
        ParsingException ex = new ParsingException(msg + " " + (Object)((Object)this.lookAhead(0)), tokenText, offset, length, this.query);
        this.predicateFulfilled = false;
        if (this.getCurrentOffset() > this.farestOffset) {
            this.farestException = ex;
            this.farestOffset = this.getCurrentOffset();
        }
        throw ex;
    }

    private final String matchIdentifier() {
        String name;
        if (this.lookAhead(0) == TokenTypes.IDENTIFIER && GreqlParser.isValidIdentifier(name = this.lookAhead.getValue())) {
            this.match();
            return name;
        }
        this.fail("expected identifier, but found");
        return null;
    }

    private final String matchSimpleName() {
        String name;
        if (this.lookAhead(0) == TokenTypes.IDENTIFIER && GreqlParser.isValidSimpleName(name = this.lookAhead.getValue())) {
            this.match();
            return name;
        }
        this.fail("expected simple name, but found");
        return null;
    }

    private final void match(TokenTypes type) {
        if (this.lookAhead(0) == type) {
            this.match();
        } else {
            this.fail("expected " + (Object)((Object)type) + ", but found");
        }
    }

    private static final boolean isValidName(TokenTypes token) {
        switch (token) {
            case MAP: 
            case AS: 
            case IMPORT: 
            case IN: 
            case SET: 
            case LIST: 
            case REC: 
            case FROM: 
            case WITH: 
            case REPORT: 
            case WHERE: 
            case LET: {
                return true;
            }
        }
        return false;
    }

    private final String matchPackageName() {
        if ((this.lookAhead(0) == TokenTypes.IDENTIFIER || GreqlParser.isValidName(this.lookAhead(0))) && GreqlParser.isValidPackageName(this.getLookAheadValue(0))) {
            StringBuilder name = new StringBuilder();
            name.append(this.lookAhead.getValue());
            this.match();
            boolean ph = true;
            do {
                if (this.lookAhead(0) == TokenTypes.DOT) {
                    if ((this.lookAhead(1) == TokenTypes.IDENTIFIER || GreqlParser.isValidName(this.lookAhead(1))) && GreqlParser.isValidPackageName(this.getLookAheadValue(1))) {
                        ph = true;
                        this.match(TokenTypes.DOT);
                        name.append(".");
                        name.append(this.lookAhead.getValue());
                        this.match();
                        continue;
                    }
                    ph = false;
                    continue;
                }
                ph = false;
            } while (ph);
            return name.toString();
        }
        this.fail("Package or type name expected, but found");
        return null;
    }

    private String getLookAheadValue(int i) {
        if (this.current + i < this.tokens.size()) {
            Token t = this.tokens.get(this.current + i);
            return t.getValue();
        }
        return null;
    }

    private final String matchQualifiedName() {
        StringBuilder name = new StringBuilder();
        this.predicateStart();
        try {
            this.matchPackageName();
            this.match(TokenTypes.DOT);
        }
        catch (ParsingException parsingException) {
            // empty catch block
        }
        if (this.predicateEnd()) {
            name.append(this.matchPackageName());
            name.append(".");
            this.match(TokenTypes.DOT);
        }
        name.append(this.matchSimpleName());
        return name.toString();
    }

    private static final boolean isValidPackageName(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        char[] chars = s.toCharArray();
        if (!Character.isLetter(chars[0]) || !Character.isLowerCase(chars[0]) || chars[0] > '\u007f') {
            return false;
        }
        for (int i = 1; i < chars.length; ++i) {
            if ((Character.isLowerCase(chars[i]) || Character.isDigit(chars[i]) || chars[i] == '_') && chars[i] <= '\u007f') continue;
            return false;
        }
        return true;
    }

    private static final boolean isValidSimpleName(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        char[] chars = s.toCharArray();
        if (!Character.isLetter(chars[0]) || !Character.isUpperCase(chars[0]) || chars[0] > '\u007f') {
            return false;
        }
        for (int i = 1; i < chars.length; ++i) {
            if (chars[i] <= '\u007f') continue;
            return false;
        }
        return true;
    }

    private static final boolean isValidIdentifier(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        char[] chars = s.toCharArray();
        if (!Character.isJavaIdentifierStart(chars[0])) {
            return false;
        }
        for (int i = 1; i < chars.length; ++i) {
            if (Character.isJavaIdentifierPart(chars[i])) continue;
            return false;
        }
        return true;
    }

    private final void parseQuery() {
        if (this.lookAhead(0) == TokenTypes.EOF) {
            return;
        }
        GreqlExpression rootExpr = this.graph.createGreqlExpression();
        rootExpr.set_importedTypes(this.parseImports());
        if (this.lookAhead(0) == TokenTypes.USING) {
            this.match();
            List<VertexPosition<Variable>> varList = this.parseVariableList();
            for (VertexPosition<Variable> var : varList) {
                IsBoundVarOf isVarOf = this.graph.createIsBoundVarOf((Variable)var.node, rootExpr);
                isVarOf.set_sourcePositions(this.createSourcePositionList(var.length, var.offset));
            }
            this.match(TokenTypes.COLON);
        }
        int offset = this.getCurrentOffset();
        Expression expr = this.parseExpression();
        if (expr == null) {
            return;
        }
        IsQueryExprOf e = this.graph.createIsQueryExprOf(expr, rootExpr);
        e.set_sourcePositions(this.createSourcePositionList(offset));
        if (this.lookAhead(0) == TokenTypes.STORE) {
            this.match();
            this.match(TokenTypes.AS);
            Identifier ident = this.graph.createIdentifier();
            offset = this.getCurrentOffset();
            ident.set_name(this.matchIdentifier());
            IsIdOfStoreClause isId = this.graph.createIsIdOfStoreClause(ident, rootExpr);
            isId.set_sourcePositions(this.createSourcePositionList(offset));
        }
        this.match(TokenTypes.EOF);
        this.testIllegalThisLiterals();
        this.mergeVariablesInGreqlExpression(rootExpr);
    }

    private final PSet<String> parseImports() {
        PSet<String> importedTypes = JGraLab.set();
        while (this.lookAhead(0) == TokenTypes.IMPORT) {
            this.match(TokenTypes.IMPORT);
            StringBuilder importedType = new StringBuilder();
            importedType.append(this.matchPackageName());
            this.match(TokenTypes.DOT);
            if (this.lookAhead(0) == TokenTypes.STAR) {
                this.match(TokenTypes.STAR);
                importedType.append(".*");
            } else {
                importedType.append(".");
                importedType.append(this.matchSimpleName());
            }
            importedTypes = importedTypes.plus(importedType.toString());
            this.match(TokenTypes.SEMI);
        }
        return importedTypes;
    }

    private final List<VertexPosition<Variable>> parseVariableList() {
        ArrayList<VertexPosition<Variable>> vlist = new ArrayList<VertexPosition<Variable>>();
        int offset = this.getCurrentOffset();
        vlist.add(new VertexPosition<Variable>(this.parseVariable(true), this.getLength(offset), offset));
        while (this.lookAhead(0) == TokenTypes.COMMA) {
            this.match();
            vlist.add(new VertexPosition<Variable>(this.parseVariable(true), this.getLength(offset), offset));
        }
        return vlist;
    }

    private final Variable parseVariable(boolean inDeclaration) {
        Variable var;
        block4: {
            String varName = this.matchIdentifier();
            var = null;
            if (!this.inPredicateMode()) {
                var = this.graph.createVariable();
                var.set_name(varName);
            }
            if (inDeclaration) {
                try {
                    this.duringParsingvariableSymbolTable.insert(varName, var);
                }
                catch (DuplicateVariableException e) {
                    if (this.inPredicateMode()) break block4;
                    throw e;
                }
            }
        }
        return var;
    }

    private final Expression parseExpression() {
        int pos = this.alreadySucceeded(RuleEnum.EXPRESSION);
        if (this.skipRule(pos)) {
            return null;
        }
        Expression expr = this.parseSubgraphRestrictedExpression();
        this.ruleSucceeds(RuleEnum.EXPRESSION, pos);
        return expr;
    }

    private final SubgraphDefinition parseSubgraphDefinition() {
        ExpressionDefinedSubgraph definition = null;
        int exprOffset = this.getCurrentOffset();
        Expression traversalContextExpr = this.parseExpression();
        if (!this.inPredicateMode()) {
            int exprLength = this.getLength(exprOffset);
            definition = this.graph.createExpressionDefinedSubgraph();
            IsSubgraphDefiningExpression isSubgraphDefExpr = this.graph.createIsSubgraphDefiningExpression(traversalContextExpr, definition);
            isSubgraphDefExpr.set_sourcePositions(this.createSourcePositionList(exprLength, exprOffset));
        }
        return definition;
    }

    private final Expression parseSubgraphRestrictedExpression() {
        int pos = this.alreadySucceeded(RuleEnum.SUBGRAPHRESTRICTEDEXPRESSION);
        if (this.skipRule(pos)) {
            return null;
        }
        Expression result = null;
        if (this.lookAhead(0) == TokenTypes.ON) {
            this.match();
            int offsetDef = this.getCurrentOffset();
            SubgraphDefinition subgraphDef = this.parseSubgraphDefinition();
            this.match(TokenTypes.COLON);
            int lengthDef = this.getLength(offsetDef);
            int offsetRestrExpr = this.getCurrentOffset();
            Expression restrictedExpr = this.parseWhereExpression();
            if (!this.inPredicateMode()) {
                int lengthRestrExpr = this.getLength(offsetRestrExpr);
                SubgraphRestrictedExpression subgraphRestrExpr = this.graph.createSubgraphRestrictedExpression();
                IsSubgraphDefinitionOf subgraphDefOf = this.graph.createIsSubgraphDefinitionOf(subgraphDef, subgraphRestrExpr);
                subgraphDefOf.set_sourcePositions(this.createSourcePositionList(lengthDef, offsetDef));
                IsExpressionOnSubgraph exprOnSubgraph = this.graph.createIsExpressionOnSubgraph(restrictedExpr, subgraphRestrExpr);
                exprOnSubgraph.set_sourcePositions(this.createSourcePositionList(lengthRestrExpr, offsetRestrExpr));
                result = subgraphRestrExpr;
            }
        } else {
            result = this.parseLetExpression();
        }
        this.ruleSucceeds(RuleEnum.SUBGRAPHRESTRICTEDEXPRESSION, pos);
        return result;
    }

    private final boolean tryMatch(TokenTypes type) {
        if (this.lookAhead(0) == type) {
            this.match();
            return true;
        }
        return false;
    }

    private final Quantifier parseQuantifier() {
        QuantificationType type = null;
        if (this.tryMatch(TokenTypes.FORALL)) {
            type = QuantificationType.FORALL;
        } else if (this.tryMatch(TokenTypes.EXISTS_ONE)) {
            type = QuantificationType.EXISTSONE;
        } else if (this.tryMatch(TokenTypes.EXISTS)) {
            type = QuantificationType.EXISTS;
        }
        if (type != null) {
            if (!this.inPredicateMode()) {
                for (Quantifier quantifier : this.graph.getQuantifierVertices()) {
                    if (quantifier.get_type() != type) continue;
                    return quantifier;
                }
                Quantifier quantifier = this.graph.createQuantifier();
                quantifier.set_type(type);
                return quantifier;
            }
            return null;
        }
        this.fail("Expected a quantifier");
        return null;
    }

    private final Expression parseQuantifiedExpression() {
        if (this.lookAhead(0) == TokenTypes.EXISTS || this.lookAhead(0) == TokenTypes.EXISTS_ONE || this.lookAhead(0) == TokenTypes.FORALL) {
            int offsetQuantifier = this.getCurrentOffset();
            int offsetQuantifiedDecl = 0;
            int offsetQuantifiedExpr = 0;
            int lengthQuantifier = 0;
            int lengthQuantifiedDecl = 0;
            int lengthQuantifiedExpr = 0;
            Quantifier quantifier = this.parseQuantifier();
            lengthQuantifier = this.getLength(offsetQuantifier);
            offsetQuantifiedDecl = this.getCurrentOffset();
            Declaration decl = this.parseQuantifiedDeclaration();
            lengthQuantifiedDecl = this.getLength(offsetQuantifiedDecl);
            this.match(TokenTypes.AT);
            offsetQuantifiedExpr = this.getCurrentOffset();
            Expression boundExpr = this.parseSubgraphRestrictedExpression();
            lengthQuantifiedExpr = this.getLength(offsetQuantifiedExpr);
            QuantifiedExpression quantifiedExpr = null;
            if (!this.inPredicateMode()) {
                quantifiedExpr = this.graph.createQuantifiedExpression();
                IsQuantifierOf quantifierOf = this.graph.createIsQuantifierOf(quantifier, quantifiedExpr);
                quantifierOf.set_sourcePositions(this.createSourcePositionList(lengthQuantifier, offsetQuantifier));
                IsQuantifiedDeclOf quantifiedDeclOf = this.graph.createIsQuantifiedDeclOf(decl, quantifiedExpr);
                quantifiedDeclOf.set_sourcePositions(this.createSourcePositionList(lengthQuantifiedDecl, offsetQuantifiedDecl));
                IsBoundExprOfQuantifiedExpression boundExprOf = this.graph.createIsBoundExprOfQuantifiedExpression(boundExpr, quantifiedExpr);
                boundExprOf.set_sourcePositions(this.createSourcePositionList(lengthQuantifiedExpr, offsetQuantifiedExpr));
            }
            return quantifiedExpr;
        }
        return this.parseConditionalExpression();
    }

    private final Expression parseLetExpression() {
        if (this.lookAhead(0) == TokenTypes.LET) {
            this.match();
            List<VertexPosition<Definition>> defList = this.parseDefinitionList();
            this.match(TokenTypes.IN);
            int offset = this.getCurrentOffset();
            Expression boundExpr = this.parseLetExpression();
            LetExpression result = null;
            if (!this.inPredicateMode() && !defList.isEmpty()) {
                int length = this.getLength(offset);
                result = this.graph.createLetExpression();
                IsBoundExprOfDefinition exprOf = this.graph.createIsBoundExprOfDefinition(boundExpr, result);
                exprOf.set_sourcePositions(this.createSourcePositionList(length, offset));
                for (VertexPosition<Definition> def : defList) {
                    IsDefinitionOf definitionOf = this.graph.createIsDefinitionOf((Definition)def.node, result);
                    definitionOf.set_sourcePositions(this.createSourcePositionList(def.length, def.offset));
                }
            }
            return result;
        }
        return this.parseWhereExpression();
    }

    private final Expression parseWhereExpression() {
        int offset = this.getCurrentOffset();
        Expression expr = this.parseQuantifiedExpression();
        if (this.tryMatch(TokenTypes.WHERE)) {
            int length = this.getLength(offset);
            List<VertexPosition<Definition>> defList = this.parseDefinitionList();
            WhereExpression result = null;
            if (!this.inPredicateMode()) {
                result = this.graph.createWhereExpression();
                IsBoundExprOfDefinition exprOf = this.graph.createIsBoundExprOfDefinition(expr, result);
                exprOf.set_sourcePositions(this.createSourcePositionList(length, offset));
                for (VertexPosition<Definition> def : defList) {
                    IsDefinitionOf isDefOf = this.graph.createIsDefinitionOf((Definition)def.node, result);
                    isDefOf.set_sourcePositions(this.createSourcePositionList(length, offset));
                }
            }
            return result;
        }
        return expr;
    }

    private final List<VertexPosition<Definition>> parseDefinitionList() {
        ArrayList<VertexPosition<Definition>> definitions = null;
        if (!this.inPredicateMode()) {
            definitions = new ArrayList<VertexPosition<Definition>>();
        }
        do {
            int offset = this.getCurrentOffset();
            Definition v = this.parseDefinition();
            int length = this.getLength(offset);
            if (this.inPredicateMode()) continue;
            definitions.add(new VertexPosition<Definition>(v, offset, length));
        } while (this.tryMatch(TokenTypes.COMMA));
        return definitions;
    }

    private final Definition parseDefinition() {
        int offsetVar = this.getCurrentOffset();
        Variable var = this.parseVariable(true);
        int lengthVar = this.getLength(offsetVar);
        this.match(TokenTypes.ASSIGN);
        int offsetExpr = this.getCurrentOffset();
        Expression expr = this.parseExpression();
        int lengthExpr = this.getLength(offsetExpr);
        if (!this.inPredicateMode()) {
            Definition definition = this.graph.createDefinition();
            IsVarOf varOf = this.graph.createIsVarOf(var, definition);
            varOf.set_sourcePositions(this.createSourcePositionList(lengthVar, offsetVar));
            IsExprOf exprOf = this.graph.createIsExprOf(expr, definition);
            exprOf.set_sourcePositions(this.createSourcePositionList(lengthExpr, offsetExpr));
            return definition;
        }
        return null;
    }

    private final Expression parseConditionalExpression() {
        int offsetExpr = this.getCurrentOffset();
        Expression result = this.parseOrExpression();
        int lengthExpr = this.getLength(offsetExpr);
        if (this.tryMatch(TokenTypes.QUESTION)) {
            int offsetTrueExpr = this.getCurrentOffset();
            Expression trueExpr = this.parseConditionalExpression();
            int lengthTrueExpr = this.getLength(offsetTrueExpr);
            this.match(TokenTypes.COLON);
            int offsetFalseExpr = this.getCurrentOffset();
            Expression falseExpr = this.parseConditionalExpression();
            int lengthFalseExpr = this.getLength(offsetFalseExpr);
            if (!this.inPredicateMode()) {
                ConditionalExpression condExpr = this.graph.createConditionalExpression();
                IsConditionOf conditionOf = this.graph.createIsConditionOf(result, condExpr);
                conditionOf.set_sourcePositions(this.createSourcePositionList(lengthExpr, offsetExpr));
                IsTrueExprOf trueExprOf = this.graph.createIsTrueExprOf(trueExpr, condExpr);
                trueExprOf.set_sourcePositions(this.createSourcePositionList(lengthTrueExpr, offsetTrueExpr));
                IsFalseExprOf falseExprOf = this.graph.createIsFalseExprOf(falseExpr, condExpr);
                falseExprOf.set_sourcePositions(this.createSourcePositionList(lengthFalseExpr, offsetFalseExpr));
                result = condExpr;
            }
        }
        return result;
    }

    private final Expression parseOrExpression() {
        ParserHelper.FunctionConstruct construct = new ParserHelper.FunctionConstruct(this);
        construct.preArg1();
        Expression expr = this.parseXorExpression();
        construct.preOp(expr);
        if (this.tryMatch(TokenTypes.OR)) {
            construct.postOp("or");
            return construct.postArg2(this.parseOrExpression());
        }
        return expr;
    }

    private final Expression parseXorExpression() {
        ParserHelper.FunctionConstruct construct = new ParserHelper.FunctionConstruct(this);
        construct.preArg1();
        Expression expr = this.parseAndExpression();
        construct.preOp(expr);
        if (this.tryMatch(TokenTypes.XOR)) {
            construct.postOp("xor");
            return construct.postArg2(this.parseXorExpression());
        }
        return expr;
    }

    private final Expression parseAndExpression() {
        ParserHelper.FunctionConstruct construct = new ParserHelper.FunctionConstruct(this);
        construct.preArg1();
        Expression expr = this.parseEqualityExpression();
        construct.preOp(expr);
        if (this.tryMatch(TokenTypes.AND)) {
            construct.postOp("and");
            return construct.postArg2(this.parseAndExpression());
        }
        return expr;
    }

    private final Expression parseEqualityExpression() {
        ParserHelper.FunctionConstruct construct = new ParserHelper.FunctionConstruct(this);
        construct.preArg1();
        Expression expr = this.parseRelationalExpression();
        construct.preOp(expr);
        if (this.tryMatch(TokenTypes.EQUAL)) {
            construct.postOp("equals");
            return construct.postArg2(this.parseEqualityExpression());
        }
        if (this.tryMatch(TokenTypes.NOT_EQUAL)) {
            construct.postOp("nequals");
            return construct.postArg2(this.parseEqualityExpression());
        }
        return expr;
    }

    private final Expression parseRelationalExpression() {
        ParserHelper.FunctionConstruct construct = new ParserHelper.FunctionConstruct(this);
        construct.preArg1();
        Expression expr = this.parseAdditiveExpression();
        construct.preOp(expr);
        String name = null;
        if (this.tryMatch(TokenTypes.L_T)) {
            name = "leThan";
        } else if (this.tryMatch(TokenTypes.LE)) {
            name = "leEqual";
        } else if (this.tryMatch(TokenTypes.GE)) {
            name = "grEqual";
        } else if (this.tryMatch(TokenTypes.G_T)) {
            name = "grThan";
        } else if (this.tryMatch(TokenTypes.MATCH)) {
            name = "reMatch";
        }
        if (name != null) {
            construct.postOp(name);
            return construct.postArg2(this.parseRelationalExpression());
        }
        return expr;
    }

    private final Expression parseAdditiveExpression() {
        ParserHelper.FunctionConstruct construct = null;
        String name = null;
        Expression expr = null;
        do {
            if (construct == null) {
                construct = new ParserHelper.FunctionConstruct(this);
                construct.preArg1();
                expr = this.parseMultiplicativeExpression();
            } else {
                construct = new ParserHelper.FunctionConstruct(this, construct);
            }
            name = null;
            construct.preOp(expr);
            if (this.tryMatch(TokenTypes.PLUS)) {
                name = "add";
            } else if (this.tryMatch(TokenTypes.MINUS)) {
                name = "sub";
            } else if (this.tryMatch(TokenTypes.PLUSPLUS)) {
                name = "concat";
            }
            if (name == null) continue;
            construct.postOp(name);
            expr = construct.postArg2(this.parseMultiplicativeExpression());
        } while (name != null);
        return expr;
    }

    private final Expression parseMultiplicativeExpression() {
        ParserHelper.FunctionConstruct construct = null;
        String name = null;
        Expression expr = null;
        do {
            if (construct == null) {
                construct = new ParserHelper.FunctionConstruct(this);
                construct.preArg1();
                expr = this.parseUnaryExpression();
            } else {
                construct = new ParserHelper.FunctionConstruct(this, construct);
            }
            name = null;
            construct.preOp(expr);
            if (this.tryMatch(TokenTypes.STAR)) {
                name = "mul";
            } else if (this.tryMatch(TokenTypes.MOD)) {
                name = "mod";
            } else if (this.tryMatch(TokenTypes.DIV)) {
                name = "div";
            }
            if (name == null) continue;
            construct.postOp(name);
            expr = construct.postArg2(this.parseUnaryExpression());
        } while (name != null);
        return expr;
    }

    private final Expression parseUnaryExpression() {
        ParserHelper.FunctionConstruct construct = null;
        if (this.lookAhead(0) == TokenTypes.NOT || this.lookAhead(0) == TokenTypes.MINUS) {
            construct = new ParserHelper.FunctionConstruct(this);
            construct.preUnaryOp();
            String opName = null;
            if (this.tryMatch(TokenTypes.NOT)) {
                opName = "not";
            } else if (this.tryMatch(TokenTypes.MINUS)) {
                opName = "neg";
            }
            if (!this.inPredicateMode()) {
                this.getFunctionId(opName);
            }
            construct.postOp(opName);
        }
        Expression expr = this.parsePathExpression();
        if (construct != null) {
            return construct.postArg2(expr);
        }
        return expr;
    }

    private final RoleId parseRoleId() {
        String ident = this.matchIdentifier();
        if (!this.inPredicateMode()) {
            RoleId roleId = this.graph.createRoleId();
            roleId.set_name(ident);
            return roleId;
        }
        return null;
    }

    private final Identifier parseIdentifier() {
        String name = this.matchIdentifier();
        if (!this.inPredicateMode()) {
            Identifier ident = this.graph.createIdentifier();
            ident.set_name(name);
            return ident;
        }
        return null;
    }

    private final Expression parseValueAccess() {
        int offset = this.getCurrentOffset();
        Expression expr = this.parsePrimaryExpression();
        int length = this.getLength(offset);
        boolean secondPart = false;
        if (this.lookAhead(0) == TokenTypes.DOT) {
            secondPart = true;
        }
        if (this.lookAhead(0) == TokenTypes.LBRACK) {
            this.predicateStart();
            try {
                this.match(TokenTypes.LBRACK);
                this.parsePrimaryPathDescription();
            }
            catch (ParsingException ex) {
                // empty catch block
            }
            if (!this.predicateEnd()) {
                secondPart = true;
            }
        }
        if (secondPart) {
            return this.parseValueAccess2(expr, offset, length);
        }
        return expr;
    }

    private final Expression parseValueAccess2(Expression arg1, int offsetArg1, int lengthArg1) {
        String name = "get";
        int offsetOperator = this.getCurrentOffset();
        int lengthOperator = 0;
        int lengthArg2 = 0;
        int offsetArg2 = 0;
        Expression arg2 = null;
        if (this.tryMatch(TokenTypes.DOT)) {
            name = "getValue";
            lengthOperator = 1;
            offsetArg2 = this.getCurrentOffset();
            arg2 = this.parseIdentifier();
        } else if (this.tryMatch(TokenTypes.LBRACK)) {
            offsetArg2 = this.getCurrentOffset();
            arg2 = this.parseExpression();
            lengthArg2 = this.getLength(offsetArg2);
            this.match(TokenTypes.RBRACK);
            lengthOperator = this.getLength(offsetOperator);
        }
        FunctionApplication result = null;
        if (!this.inPredicateMode()) {
            result = this.createFunctionIdAndArgumentOf(this.getFunctionId(name), offsetOperator, lengthOperator, arg1, offsetArg1, lengthArg1, arg2, offsetArg2, lengthArg2, true);
        }
        boolean secondPart = false;
        if (this.lookAhead(0) == TokenTypes.DOT) {
            secondPart = true;
        }
        if (this.lookAhead(0) == TokenTypes.LBRACK) {
            this.predicateStart();
            try {
                this.match(TokenTypes.LBRACK);
                this.parsePrimaryPathDescription();
            }
            catch (ParsingException ex) {
                // empty catch block
            }
            if (!this.predicateEnd()) {
                secondPart = true;
            }
        }
        if (secondPart) {
            return this.parseValueAccess2(result, offsetArg1, this.getLength(offsetArg2));
        }
        return result;
    }

    private final Expression parsePrimaryExpression() {
        if (this.lookAhead(0) == TokenTypes.LPAREN) {
            return this.parseParenthesedExpression();
        }
        if (this.lookAhead(0) == TokenTypes.V || this.lookAhead(0) == TokenTypes.E) {
            return this.parseRangeExpression();
        }
        this.predicateStart();
        try {
            this.parseAltPathDescription();
        }
        catch (ParsingException ex) {
            // empty catch block
        }
        if (this.predicateEnd()) {
            return this.parseAltPathDescription();
        }
        if (!(this.lookAhead(0) != TokenTypes.IDENTIFIER && this.lookAhead(0) != TokenTypes.AND && this.lookAhead(0) != TokenTypes.NOT && this.lookAhead(0) != TokenTypes.XOR && this.lookAhead(0) != TokenTypes.OR || this.lookAhead(1) != TokenTypes.LCURLY && this.lookAhead(1) != TokenTypes.LPAREN)) {
            this.predicateStart();
            try {
                this.parseFunctionApplication();
            }
            catch (ParsingException ex) {
                // empty catch block
            }
            if (this.predicateEnd()) {
                return this.parseFunctionApplication();
            }
        }
        this.predicateStart();
        try {
            this.parseValueConstruction();
        }
        catch (ParsingException ex) {
            // empty catch block
        }
        if (this.predicateEnd()) {
            return this.parseValueConstruction();
        }
        this.predicateStart();
        try {
            this.parseVariable(false);
        }
        catch (ParsingException ex) {
            // empty catch block
        }
        if (this.predicateEnd()) {
            return this.parseVariable(false);
        }
        this.predicateStart();
        try {
            this.parseLiteral();
        }
        catch (ParsingException parsingException) {
            // empty catch block
        }
        if (this.predicateEnd()) {
            return this.parseLiteral();
        }
        if (this.lookAhead(0) == TokenTypes.FROM) {
            return this.parseFWRExpression();
        }
        this.fail("Unrecognized token");
        return null;
    }

    private final Expression parseParenthesedExpression() {
        this.predicateStart();
        try {
            this.parseAltPathDescription();
        }
        catch (ParsingException ex) {
            // empty catch block
        }
        if (this.predicateEnd()) {
            PathDescription expr = this.parseAltPathDescription();
            return expr;
        }
        this.match(TokenTypes.LPAREN);
        Expression expr = this.parseExpression();
        this.match(TokenTypes.RPAREN);
        return expr;
    }

    private final PathDescription parseAltPathDescription() {
        int pos = this.alreadySucceeded(RuleEnum.ALTERNATIVE_PATH_DESCRIPTION);
        if (this.skipRule(pos)) {
            return null;
        }
        int offsetPart1 = this.getCurrentOffset();
        PathDescription part1 = this.parseIntermediateVertexPathDescription();
        int lengthPart1 = this.getLength(offsetPart1);
        if (this.tryMatch(TokenTypes.BOR)) {
            int offsetPart2 = this.getCurrentOffset();
            PathDescription part2 = this.parseAltPathDescription();
            int lengthPart2 = this.getLength(offsetPart2);
            if (!this.inPredicateMode()) {
                part1 = this.addPathElement(AlternativePathDescription.VC, IsAlternativePathOf.EC, null, part1, offsetPart1, lengthPart1, part2, offsetPart2, lengthPart2);
            }
        }
        this.ruleSucceeds(RuleEnum.ALTERNATIVE_PATH_DESCRIPTION, pos);
        return part1;
    }

    private final PathDescription parseIntermediateVertexPathDescription() {
        int offsetPart1 = this.getCurrentOffset();
        PathDescription part1 = this.parseSequentialPathDescription();
        int lengthPart1 = this.getLength(offsetPart1);
        this.predicateStart();
        try {
            this.parseValueAccess();
            if (this.predicateHolds()) {
                this.parseSequentialPathDescription();
            }
        }
        catch (ParsingException ex) {
            // empty catch block
        }
        if (this.predicateEnd()) {
            int offsetExpr = this.getCurrentOffset();
            Expression restrExpr = this.parseValueAccess();
            int lengthExpr = this.getLength(offsetExpr);
            int offsetPart2 = this.getCurrentOffset();
            PathDescription part2 = this.parseIntermediateVertexPathDescription();
            int lengthPart2 = this.getLength(offsetPart2);
            IntermediateVertexPathDescription result = null;
            if (!this.inPredicateMode()) {
                result = (IntermediateVertexPathDescription)this.addPathElement(IntermediateVertexPathDescription.VC, IsSubPathOf.EC, null, part1, offsetPart1, lengthPart1, part2, offsetPart2, lengthPart2);
                IsIntermediateVertexOf intermediateVertexOf = this.graph.createIsIntermediateVertexOf(restrExpr, result);
                intermediateVertexOf.set_sourcePositions(this.createSourcePositionList(lengthExpr, offsetExpr));
            }
            return result;
        }
        return part1;
    }

    private final PathDescription parseSequentialPathDescription() {
        int offsetPart1 = this.getCurrentOffset();
        PathDescription part1 = this.parseStartRestrictedPathDescription();
        int lengthPart1 = this.getLength(offsetPart1);
        this.predicateStart();
        try {
            this.parseSequentialPathDescription();
        }
        catch (ParsingException ex) {
            // empty catch block
        }
        if (this.predicateEnd()) {
            int offsetPart2 = this.getCurrentOffset();
            PathDescription part2 = this.parseSequentialPathDescription();
            int lengthPart2 = this.getLength(offsetPart2);
            if (!this.inPredicateMode()) {
                return this.addPathElement(SequentialPathDescription.VC, IsSequenceElementOf.EC, null, part1, offsetPart1, lengthPart1, part2, offsetPart2, lengthPart2);
            }
            return null;
        }
        return part1;
    }

    private final PathDescription parseStartRestrictedPathDescription() {
        int offsetRest = this.getCurrentOffset();
        List<VertexPosition<? extends TypeOrRoleId>> typeIds = null;
        Expression expr = null;
        int lengthRestr = 0;
        int offsetRestr = 0;
        if (this.tryMatch(TokenTypes.LCURLY)) {
            this.predicateStart();
            try {
                this.parseTypeAndRoleExpressionList();
            }
            catch (ParsingException ex) {
                // empty catch block
            }
            if (this.predicateEnd()) {
                typeIds = this.parseTypeAndRoleExpressionList();
            }
            if (this.tryMatch(TokenTypes.AT)) {
                offsetRestr = this.getCurrentOffset();
                expr = this.parseExpression();
                lengthRestr = this.getLength(offsetRestr);
            }
            this.match(TokenTypes.RCURLY);
            this.match(TokenTypes.AMP);
        }
        PathDescription pathDescr = this.parseGoalRestrictedPathDescription();
        if (!this.inPredicateMode()) {
            if (expr != null) {
                IsStartRestrOf startRestrOf = this.graph.createIsStartRestrOf(expr, pathDescr);
                startRestrOf.set_sourcePositions(this.createSourcePositionList(lengthRestr, offsetRest));
            }
            if (typeIds != null) {
                for (VertexPosition<? extends TypeOrRoleId> t : typeIds) {
                    IsStartRestrOf startRestrOf = this.graph.createIsStartRestrOf((Expression)t.node, pathDescr);
                    startRestrOf.set_sourcePositions(this.createSourcePositionList(t.length, t.offset));
                }
            }
        }
        return pathDescr;
    }

    private final PathDescription parseGoalRestrictedPathDescription() {
        PathDescription pathDescr = this.parseIteratedOrTransposedPathDescription();
        if (this.tryMatch(TokenTypes.AMP)) {
            IsGoalRestrOf goalRestrOf;
            this.match(TokenTypes.LCURLY);
            this.predicateStart();
            try {
                this.parseTypeAndRoleExpressionList();
            }
            catch (ParsingException ex) {
                // empty catch block
            }
            if (this.predicateEnd()) {
                List<VertexPosition<? extends TypeOrRoleId>> typeIds = this.parseTypeAndRoleExpressionList();
                if (!this.inPredicateMode()) {
                    for (VertexPosition<? extends TypeOrRoleId> t : typeIds) {
                        goalRestrOf = this.graph.createIsGoalRestrOf((Expression)t.node, pathDescr);
                        goalRestrOf.set_sourcePositions(this.createSourcePositionList(t.length, t.offset));
                    }
                }
            }
            if (this.tryMatch(TokenTypes.AT)) {
                int offset = this.getCurrentOffset();
                Expression expr = this.parseExpression();
                int length = this.getLength(offset);
                if (!this.inPredicateMode()) {
                    goalRestrOf = this.graph.createIsGoalRestrOf(expr, pathDescr);
                    goalRestrOf.set_sourcePositions(this.createSourcePositionList(length, offset));
                }
            }
            this.match(TokenTypes.RCURLY);
        }
        return pathDescr;
    }

    private final PathDescription parseIteratedOrTransposedPathDescription() {
        int offsetPath = this.getCurrentOffset();
        PathDescription pathDescr = this.parsePrimaryPathDescription();
        int lengthPath = this.getLength(offsetPath);
        if (this.lookAhead(0) == TokenTypes.STAR || this.lookAhead(0) == TokenTypes.PLUS || this.lookAhead(0) == TokenTypes.TRANSPOSED || this.lookAhead(0) == TokenTypes.CARET) {
            return this.parseIteration(pathDescr, offsetPath, lengthPath);
        }
        return pathDescr;
    }

    private final PathDescription parseIteration(PathDescription iteratedPath, int offsetPath, int lengthPath) {
        IterationType iteration = null;
        PathDescription result = null;
        if (this.tryMatch(TokenTypes.STAR)) {
            iteration = IterationType.STAR;
        } else if (this.tryMatch(TokenTypes.PLUS)) {
            iteration = IterationType.PLUS;
        }
        if (iteration != null) {
            if (!this.inPredicateMode()) {
                IteratedPathDescription ipd = this.graph.createIteratedPathDescription();
                ipd.set_times(iteration);
                IsIteratedPathOf iteratedPathOf = this.graph.createIsIteratedPathOf(iteratedPath, ipd);
                iteratedPathOf.set_sourcePositions(this.createSourcePositionList(lengthPath, offsetPath));
                result = ipd;
            }
        } else if (this.tryMatch(TokenTypes.TRANSPOSED)) {
            if (!this.inPredicateMode()) {
                TransposedPathDescription tpd = this.graph.createTransposedPathDescription();
                IsTransposedPathOf transposedPathOf = this.graph.createIsTransposedPathOf(iteratedPath, tpd);
                transposedPathOf.set_sourcePositions(this.createSourcePositionList(lengthPath, offsetPath));
                result = tpd;
            }
        } else if (this.tryMatch(TokenTypes.CARET)) {
            int offsetExpr = this.getCurrentOffset();
            Expression ie = this.parseNumericLiteral();
            if (!this.inPredicateMode()) {
                if (!(ie instanceof IntLiteral)) {
                    this.fail("Expected integer constant as iteration quantifier or T, but found");
                }
                int lengthExpr = this.getLength(offsetExpr);
                ExponentiatedPathDescription epd = this.graph.createExponentiatedPathDescription();
                IsExponentiatedPathOf exponentiatedPathOf = this.graph.createIsExponentiatedPathOf(iteratedPath, epd);
                exponentiatedPathOf.set_sourcePositions(this.createSourcePositionList(lengthPath, offsetPath));
                IsExponentOf exponentOf = this.graph.createIsExponentOf((IntLiteral)ie, epd);
                exponentOf.set_sourcePositions(this.createSourcePositionList(lengthExpr, offsetExpr));
                result = epd;
            }
        } else {
            this.fail("No iteration or transposition at iterated path description");
        }
        if (this.lookAhead(0) == TokenTypes.STAR || this.lookAhead(0) == TokenTypes.PLUS || this.lookAhead(0) == TokenTypes.CARET) {
            return this.parseIteration(result, offsetPath, this.getLength(offsetPath));
        }
        return result;
    }

    private final PathDescription parsePrimaryPathDescription() {
        if (this.lookAhead(0) == TokenTypes.LPAREN) {
            this.predicateStart();
            try {
                this.match(TokenTypes.LPAREN);
                this.parseAltPathDescription();
            }
            catch (ParsingException ex) {
                // empty catch block
            }
            if (this.predicateEnd()) {
                this.match(TokenTypes.LPAREN);
                PathDescription pathDescr = this.parseAltPathDescription();
                this.match(TokenTypes.RPAREN);
                return pathDescr;
            }
        }
        if (this.lookAhead(0) == TokenTypes.OUTAGGREGATION || this.lookAhead(0) == TokenTypes.INAGGREGATION) {
            return this.parseAggregationPathDescription();
        }
        if (this.lookAhead(0) == TokenTypes.RARROW || this.lookAhead(0) == TokenTypes.LARROW || this.lookAhead(0) == TokenTypes.ARROW) {
            return this.parseSimplePathDescription();
        }
        if (this.lookAhead(0) == TokenTypes.EDGESTART || this.lookAhead(0) == TokenTypes.EDGEEND || this.lookAhead(0) == TokenTypes.EDGE) {
            return this.parseEdgePathDescription();
        }
        if (this.tryMatch(TokenTypes.LBRACK)) {
            int offset = this.getCurrentOffset();
            PathDescription pathDescr = this.parseAltPathDescription();
            int length = this.getLength(offset);
            this.match(TokenTypes.RBRACK);
            if (!this.inPredicateMode()) {
                OptionalPathDescription optPathDescr = this.graph.createOptionalPathDescription();
                IsOptionalPathOf optionalPathOf = this.graph.createIsOptionalPathOf(pathDescr, optPathDescr);
                optionalPathOf.set_sourcePositions(this.createSourcePositionList(length, offset));
                return optPathDescr;
            }
            return null;
        }
        this.fail("Unrecognized token");
        return null;
    }

    private final PrimaryPathDescription parseSimplePathDescription() {
        Direction dir = null;
        EdgeRestriction edgeRestr = null;
        GReQLDirection direction = GReQLDirection.INOUT;
        int offsetDir = this.getCurrentOffset();
        int offsetEdgeRestr = 0;
        int lengthEdgeRestr = 0;
        if (this.tryMatch(TokenTypes.RARROW)) {
            direction = GReQLDirection.OUT;
        } else if (this.tryMatch(TokenTypes.LARROW)) {
            direction = GReQLDirection.IN;
        } else {
            this.match(TokenTypes.ARROW);
        }
        if (this.tryMatch(TokenTypes.LCURLY)) {
            offsetEdgeRestr = this.getCurrentOffset();
            edgeRestr = this.parseEdgeRestriction();
            lengthEdgeRestr = this.getLength(offsetEdgeRestr);
            this.match(TokenTypes.RCURLY);
        }
        if (!this.inPredicateMode()) {
            SimplePathDescription result = this.graph.createSimplePathDescription();
            for (dir = (Direction)this.graph.getFirstVertex(Direction.VC); dir != null && !dir.get_dirValue().equals((Object)direction); dir = dir.getNextDirection()) {
            }
            if (dir == null) {
                dir = this.graph.createDirection();
                dir.set_dirValue(direction);
            }
            IsDirectionOf directionOf = this.graph.createIsDirectionOf(dir, result);
            directionOf.set_sourcePositions(this.createSourcePositionList(0, offsetDir));
            if (edgeRestr != null) {
                IsEdgeRestrOf edgeRestrOf = this.graph.createIsEdgeRestrOf(edgeRestr, result);
                edgeRestrOf.set_sourcePositions(this.createSourcePositionList(lengthEdgeRestr, offsetEdgeRestr));
            }
            return result;
        }
        return null;
    }

    private final PrimaryPathDescription parseAggregationPathDescription() {
        boolean outAggregation = true;
        EdgeRestriction edgeRestr = null;
        int restrOffset = 0;
        int restrLength = 0;
        if (this.tryMatch(TokenTypes.INAGGREGATION)) {
            outAggregation = false;
        } else {
            this.match(TokenTypes.OUTAGGREGATION);
        }
        if (this.tryMatch(TokenTypes.LCURLY)) {
            restrOffset = this.getCurrentOffset();
            edgeRestr = this.parseEdgeRestriction();
            restrLength = this.getLength(restrOffset);
            this.match(TokenTypes.RCURLY);
        }
        if (!this.inPredicateMode()) {
            AggregationPathDescription result = this.graph.createAggregationPathDescription();
            result.set_outAggregation(outAggregation);
            if (edgeRestr != null) {
                IsEdgeRestrOf edgeRestrOf = this.graph.createIsEdgeRestrOf(edgeRestr, result);
                edgeRestrOf.set_sourcePositions(this.createSourcePositionList(restrLength, restrOffset));
            }
            return result;
        }
        return null;
    }

    private final EdgePathDescription parseEdgePathDescription() {
        Direction dir = null;
        boolean edgeStart = false;
        boolean edgeEnd = false;
        GReQLDirection direction = GReQLDirection.INOUT;
        int offsetDir = this.getCurrentOffset();
        if (this.tryMatch(TokenTypes.EDGESTART)) {
            edgeStart = true;
        } else {
            this.match(TokenTypes.EDGE);
        }
        int offsetExpr = this.getCurrentOffset();
        Expression expr = this.parseExpression();
        int lengthExpr = this.getLength(offsetExpr);
        if (this.tryMatch(TokenTypes.EDGEEND)) {
            edgeEnd = true;
        } else {
            this.match(TokenTypes.EDGE);
        }
        if (!this.inPredicateMode()) {
            int lengthDir = this.getLength(offsetDir);
            EdgePathDescription result = this.graph.createEdgePathDescription();
            if (edgeStart && !edgeEnd) {
                direction = GReQLDirection.IN;
            } else if (!edgeStart && edgeEnd) {
                direction = GReQLDirection.OUT;
            }
            for (dir = (Direction)this.graph.getFirstVertex(Direction.VC); dir != null && !dir.get_dirValue().equals((Object)direction); dir = dir.getNextDirection()) {
            }
            if (dir == null) {
                dir = this.graph.createDirection();
                dir.set_dirValue(direction);
            }
            IsDirectionOf directionOf = this.graph.createIsDirectionOf(dir, result);
            directionOf.set_sourcePositions(this.createSourcePositionList(lengthDir, offsetDir));
            IsEdgeExprOf edgeExprOf = this.graph.createIsEdgeExprOf(expr, result);
            edgeExprOf.set_sourcePositions(this.createSourcePositionList(lengthExpr, offsetExpr));
            return result;
        }
        return null;
    }

    private final FunctionApplication parseFunctionApplication() {
        List<VertexPosition<TypeId>> typeIds = null;
        if (!(this.lookAhead(0) != TokenTypes.IDENTIFIER && this.lookAhead(0) != TokenTypes.AND && this.lookAhead(0) != TokenTypes.NOT && this.lookAhead(0) != TokenTypes.XOR && this.lookAhead(0) != TokenTypes.OR || !this.isFunctionName(this.lookAhead.getValue()) || this.lookAhead(1) != TokenTypes.LCURLY && this.lookAhead(1) != TokenTypes.LPAREN)) {
            int offset = this.getCurrentOffset();
            String name = this.lookAhead.getValue();
            this.match();
            int length = this.getLength(offset);
            if (this.tryMatch(TokenTypes.LCURLY)) {
                typeIds = this.parseTypeExpressionList();
                this.match(TokenTypes.RCURLY);
            }
            this.match(TokenTypes.LPAREN);
            List<VertexPosition<Expression>> expressions = null;
            if (this.lookAhead(0) != TokenTypes.RPAREN) {
                expressions = this.parseExpressionList(TokenTypes.COMMA);
            }
            this.match(TokenTypes.RPAREN);
            if (!this.inPredicateMode()) {
                FunctionApplication funApp = this.graph.createFunctionApplication();
                FunctionId functionId = this.getFunctionId(name);
                IsFunctionIdOf functionIdOf = this.graph.createIsFunctionIdOf(functionId, funApp);
                functionIdOf.set_sourcePositions(this.createSourcePositionList(length, offset));
                if (typeIds != null) {
                    for (VertexPosition<Expression> vertexPosition : typeIds) {
                        IsTypeExprOfFunction typeOf = this.graph.createIsTypeExprOfFunction((Expression)vertexPosition.node, funApp);
                        typeOf.set_sourcePositions(this.createSourcePositionList(vertexPosition.length, vertexPosition.offset));
                    }
                }
                if (expressions != null) {
                    for (VertexPosition<Expression> vertexPosition : expressions) {
                        IsArgumentOf argOf = this.graph.createIsArgumentOf((Expression)vertexPosition.node, funApp);
                        argOf.set_sourcePositions(this.createSourcePositionList(vertexPosition.length, vertexPosition.offset));
                    }
                }
                return funApp;
            }
            return null;
        }
        this.fail("No function application");
        return null;
    }

    private final Expression parseValueConstruction() {
        if (this.lookAhead(0) != null) {
            switch (this.lookAhead(0)) {
                case REC: {
                    return this.parseRecordConstruction();
                }
                case MAP: {
                    return this.parseMapConstruction();
                }
                case LIST: {
                    return this.parseListConstruction();
                }
                case SET: {
                    this.match();
                    this.match(TokenTypes.LPAREN);
                    if (this.tryMatch(TokenTypes.RPAREN)) {
                        return this.graph.createSetConstruction();
                    }
                    List<VertexPosition<Expression>> expressions = this.parseExpressionList(TokenTypes.COMMA);
                    this.match(TokenTypes.RPAREN);
                    if (!this.inPredicateMode()) {
                        return this.createPartsOfValueConstruction(expressions, this.graph.createSetConstruction());
                    }
                    return null;
                }
                case TUP: {
                    this.match();
                    this.match(TokenTypes.LPAREN);
                    if (this.tryMatch(TokenTypes.RPAREN)) {
                        return this.graph.createTupleConstruction();
                    }
                    List<VertexPosition<Expression>> expressions = this.parseExpressionList(TokenTypes.COMMA);
                    this.match(TokenTypes.RPAREN);
                    if (!this.inPredicateMode()) {
                        return this.createPartsOfValueConstruction(expressions, this.graph.createTupleConstruction());
                    }
                    return null;
                }
            }
        }
        this.fail("Expected value construction, but found");
        return null;
    }

    private final MapConstruction parseMapConstruction() {
        IsValueExprOfConstruction valueEdge;
        IsKeyExprOfConstruction keyEdge;
        this.match(TokenTypes.MAP);
        this.match(TokenTypes.LPAREN);
        if (this.tryMatch(TokenTypes.RPAREN)) {
            return this.graph.createMapConstruction();
        }
        MapConstruction mapConstr = null;
        if (!this.inPredicateMode()) {
            mapConstr = this.graph.createMapConstruction();
        }
        int offsetKey = this.getCurrentOffset();
        Expression keyExpr = this.parseExpression();
        int lengthKey = this.getLength(offsetKey);
        this.match(TokenTypes.EDGEEND);
        int offsetValue = this.getCurrentOffset();
        Expression valueExpr = this.parseExpression();
        int lengthValue = this.getLength(offsetValue);
        if (!this.inPredicateMode()) {
            keyEdge = this.graph.createIsKeyExprOfConstruction(keyExpr, mapConstr);
            keyEdge.set_sourcePositions(this.createSourcePositionList(lengthKey, offsetKey));
            valueEdge = this.graph.createIsValueExprOfConstruction(valueExpr, mapConstr);
            valueEdge.set_sourcePositions(this.createSourcePositionList(lengthValue, offsetValue));
        }
        while (this.tryMatch(TokenTypes.COMMA)) {
            offsetKey = this.getCurrentOffset();
            keyExpr = this.parseExpression();
            lengthKey = this.getLength(offsetKey);
            this.match(TokenTypes.EDGEEND);
            offsetValue = this.getCurrentOffset();
            valueExpr = this.parseExpression();
            lengthValue = this.getLength(offsetValue);
            if (this.inPredicateMode()) continue;
            keyEdge = this.graph.createIsKeyExprOfConstruction(keyExpr, mapConstr);
            keyEdge.set_sourcePositions(this.createSourcePositionList(lengthKey, offsetKey));
            valueEdge = this.graph.createIsValueExprOfConstruction(valueExpr, mapConstr);
            valueEdge.set_sourcePositions(this.createSourcePositionList(lengthValue, offsetValue));
        }
        this.match(TokenTypes.RPAREN);
        return mapConstr;
    }

    private final ValueConstruction parseListConstruction() {
        this.match(TokenTypes.LIST);
        this.match(TokenTypes.LPAREN);
        if (this.tryMatch(TokenTypes.RPAREN)) {
            return this.graph.createListConstruction();
        }
        ValueConstruction result = null;
        int offsetStart = this.getCurrentOffset();
        Expression startExpr = this.parseExpression();
        int lengthStart = this.getLength(offsetStart);
        if (this.tryMatch(TokenTypes.DOTDOT)) {
            int offsetEnd = this.getCurrentOffset();
            Expression endExpr = this.parseExpression();
            int lengthEnd = this.getLength(offsetEnd);
            if (!this.inPredicateMode()) {
                result = this.graph.createListRangeConstruction();
                IsFirstValueOf firstValueOf = this.graph.createIsFirstValueOf(startExpr, (ListRangeConstruction)result);
                firstValueOf.set_sourcePositions(this.createSourcePositionList(lengthStart, offsetStart));
                IsLastValueOf lastValueOf = this.graph.createIsLastValueOf(endExpr, (ListRangeConstruction)result);
                lastValueOf.set_sourcePositions(this.createSourcePositionList(lengthEnd, offsetEnd));
            }
        } else {
            List<VertexPosition<Expression>> allExpressions = null;
            if (this.tryMatch(TokenTypes.COMMA)) {
                allExpressions = this.parseExpressionList(TokenTypes.COMMA);
            }
            if (!this.inPredicateMode()) {
                VertexPosition<Expression> v = new VertexPosition<Expression>(startExpr, lengthStart, offsetStart);
                if (allExpressions == null) {
                    allExpressions = new ArrayList<VertexPosition<Expression>>(1);
                }
                allExpressions.add(0, v);
                result = this.createPartsOfValueConstruction(allExpressions, this.graph.createListConstruction());
            }
        }
        this.match(TokenTypes.RPAREN);
        return result;
    }

    private final ValueConstruction parseRecordConstruction() {
        this.match(TokenTypes.REC);
        this.match(TokenTypes.LPAREN);
        ArrayList<VertexPosition<RecordElement>> elements = new ArrayList<VertexPosition<RecordElement>>();
        do {
            int offset = this.getCurrentOffset();
            RecordElement recElem = this.parseRecordElement();
            int n = this.getLength(offset);
            elements.add(new VertexPosition<RecordElement>(recElem, n, offset));
        } while (this.tryMatch(TokenTypes.COMMA));
        this.match(TokenTypes.RPAREN);
        if (!this.inPredicateMode()) {
            RecordConstruction valueConstr = this.graph.createRecordConstruction();
            if (elements != null) {
                for (VertexPosition vertexPosition : elements) {
                    IsRecordElementOf exprOf = this.graph.createIsRecordElementOf((RecordElement)vertexPosition.node, valueConstr);
                    exprOf.set_sourcePositions(this.createSourcePositionList(vertexPosition.length, vertexPosition.offset));
                }
            }
            return valueConstr;
        }
        return null;
    }

    private final RecordElement parseRecordElement() {
        int offsetRecId = this.getCurrentOffset();
        String recIdName = this.matchIdentifier();
        int lengthRecId = this.getLength(offsetRecId);
        this.match(TokenTypes.COLON);
        int offsetExpr = this.getCurrentOffset();
        Expression expr = this.parseExpression();
        int lengthExpr = this.getLength(offsetExpr);
        if (!this.inPredicateMode()) {
            RecordId recId = this.graph.createRecordId();
            recId.set_name(recIdName);
            RecordElement recElement = this.graph.createRecordElement();
            IsRecordIdOf recIdOf = this.graph.createIsRecordIdOf(recId, recElement);
            recIdOf.set_sourcePositions(this.createSourcePositionList(lengthRecId, offsetRecId));
            IsRecordExprOf exprOf = this.graph.createIsRecordExprOf(expr, recElement);
            exprOf.set_sourcePositions(this.createSourcePositionList(lengthExpr, offsetExpr));
            return recElement;
        }
        return null;
    }

    private final Declaration parseQuantifiedDeclaration() {
        List<VertexPosition<SimpleDeclaration>> declarations = this.parseDeclarationList();
        Declaration declaration = null;
        if (!this.inPredicateMode()) {
            declaration = (Declaration)this.createMultipleEdgesToParent(declarations, (Vertex)this.graph.createDeclaration(), IsSimpleDeclOf.EC, false);
        }
        while (this.tryMatch(TokenTypes.COMMA)) {
            int offsetConstraint = this.getCurrentOffset();
            Expression constraintExpr = this.parseExpression();
            int lengthConstraint = this.getLength(offsetConstraint);
            if (!this.inPredicateMode()) {
                IsConstraintOf constraintOf = this.graph.createIsConstraintOf(constraintExpr, declaration);
                constraintOf.set_sourcePositions(this.createSourcePositionList(lengthConstraint, offsetConstraint));
            }
            this.predicateStart();
            try {
                this.match(TokenTypes.COMMA);
                this.parseSimpleDeclaration();
            }
            catch (ParsingException ex) {
                // empty catch block
            }
            if (!this.predicateEnd()) continue;
            this.match(TokenTypes.COMMA);
            declarations = this.parseDeclarationList();
            if (this.inPredicateMode()) continue;
            this.createMultipleEdgesToParent(declarations, (Vertex)declaration, IsSimpleDeclOf.EC, false);
        }
        return declaration;
    }

    private final List<VertexPosition<SimpleDeclaration>> parseDeclarationList() {
        ArrayList<VertexPosition<SimpleDeclaration>> declList = new ArrayList<VertexPosition<SimpleDeclaration>>();
        int offset = this.getCurrentOffset();
        SimpleDeclaration decl = this.parseSimpleDeclaration();
        int length = this.getLength(offset);
        declList.add(new VertexPosition<SimpleDeclaration>(decl, length, offset));
        if (this.lookAhead(0) == TokenTypes.COMMA) {
            this.predicateStart();
            try {
                this.match(TokenTypes.COMMA);
                this.parseSimpleDeclaration();
            }
            catch (ParsingException ex) {
                // empty catch block
            }
            if (this.predicateEnd()) {
                this.match(TokenTypes.COMMA);
                declList.addAll(this.parseDeclarationList());
            }
        }
        return declList;
    }

    private final SimpleDeclaration parseSimpleDeclaration() {
        List<VertexPosition<Variable>> variables = this.parseVariableList();
        this.match(TokenTypes.COLON);
        int offset = this.getCurrentOffset();
        Expression expr = this.parseExpression();
        int length = this.getLength(offset);
        if (!this.inPredicateMode()) {
            SimpleDeclaration simpleDecl = (SimpleDeclaration)this.createMultipleEdgesToParent(variables, (Vertex)this.graph.createSimpleDeclaration(), IsDeclaredVarOf.EC, "");
            IsTypeExprOfDeclaration typeExprOf = this.graph.createIsTypeExprOfDeclaration(expr, simpleDecl);
            typeExprOf.set_sourcePositions(this.createSourcePositionList(length, offset));
            return simpleDecl;
        }
        return null;
    }

    private final List<VertexPosition<Expression>> parseExpressionList(TokenTypes separator) {
        int pos = this.alreadySucceeded(RuleEnum.EXPRESSION_LIST);
        if (this.skipRule(pos)) {
            return null;
        }
        ArrayList<VertexPosition<Expression>> list = new ArrayList<VertexPosition<Expression>>();
        do {
            int offset = this.getCurrentOffset();
            Expression expr = this.parseExpression();
            int length = this.getLength(offset);
            list.add(new VertexPosition<Expression>(expr, length, offset));
        } while (this.tryMatch(separator));
        this.ruleSucceeds(RuleEnum.EXPRESSION_LIST, pos);
        return list;
    }

    private final Expression parseRangeExpression() {
        ElementSetExpression expr = null;
        if (this.tryMatch(TokenTypes.V)) {
            if (!this.inPredicateMode()) {
                expr = this.graph.createVertexSetExpression();
            }
        } else {
            this.match(TokenTypes.E);
            if (!this.inPredicateMode()) {
                expr = this.graph.createEdgeSetExpression();
            }
        }
        if (this.tryMatch(TokenTypes.LCURLY) && !this.tryMatch(TokenTypes.RCURLY)) {
            List<VertexPosition<TypeId>> typeIds = this.parseTypeExpressionList();
            this.match(TokenTypes.RCURLY);
            if (!this.inPredicateMode()) {
                this.createMultipleEdgesToParent(typeIds, (Vertex)expr, IsTypeRestrOfExpression.EC, 0);
            }
        }
        return expr;
    }

    private final List<VertexPosition<TypeId>> parseTypeExpressionList() {
        ArrayList<VertexPosition<TypeId>> list = new ArrayList<VertexPosition<TypeId>>();
        do {
            int offset = this.getCurrentOffset();
            TypeId t = this.parseTypeId();
            int length = this.getLength(offset);
            list.add(new VertexPosition<TypeId>(t, length, offset));
        } while (this.tryMatch(TokenTypes.COMMA));
        return list;
    }

    private final TypeId parseTypeId() {
        TypeId type = null;
        if (!this.inPredicateMode()) {
            type = this.graph.createTypeId();
        }
        if (this.tryMatch(TokenTypes.CARET) && !this.inPredicateMode()) {
            type.set_excluded(true);
        }
        String s = this.matchQualifiedName();
        if (!this.inPredicateMode()) {
            type.set_name(s);
        }
        if (this.tryMatch(TokenTypes.EXCL) && !this.inPredicateMode()) {
            type.set_type(true);
        }
        return type;
    }

    private TypeOrRoleId parseTypeOrRoleId() {
        TypeOrRoleId id = null;
        this.predicateStart();
        try {
            this.parseTypeId();
        }
        catch (ParsingException parsingException) {
            // empty catch block
        }
        id = this.predicateEnd() ? this.parseTypeId() : this.parseRoleId();
        return id;
    }

    private final List<VertexPosition<? extends TypeOrRoleId>> parseTypeAndRoleExpressionList() {
        ArrayList<VertexPosition<? extends TypeOrRoleId>> list = new ArrayList<VertexPosition<? extends TypeOrRoleId>>();
        do {
            int offset = this.getCurrentOffset();
            TypeOrRoleId id = this.parseTypeOrRoleId();
            int length = this.getLength(offset);
            list.add(new VertexPosition<TypeOrRoleId>(id, length, offset));
        } while (this.tryMatch(TokenTypes.COMMA));
        return list;
    }

    private final EdgeRestriction parseEdgeRestriction() {
        List<VertexPosition<? extends TypeOrRoleId>> typeOrRoleIds;
        ArrayList<VertexPosition<TypeOrRoleId>> typeIds = null;
        ArrayList<VertexPosition<TypeOrRoleId>> roleIds = null;
        Expression predicate = null;
        int predicateOffset = 0;
        int predicateLength = 0;
        this.predicateStart();
        try {
            this.parseTypeOrRoleId();
        }
        catch (ParsingException ex) {
            // empty catch block
        }
        if (this.predicateEnd() && (typeOrRoleIds = this.parseTypeAndRoleExpressionList()) != null) {
            typeIds = new ArrayList<VertexPosition<TypeOrRoleId>>();
            roleIds = new ArrayList<VertexPosition<TypeOrRoleId>>();
            for (VertexPosition<TypeOrRoleId> vertexPosition : typeOrRoleIds) {
                if (vertexPosition.node instanceof TypeId) {
                    typeIds.add(vertexPosition);
                    continue;
                }
                roleIds.add(vertexPosition);
            }
        }
        if (this.tryMatch(TokenTypes.AT)) {
            predicateOffset = this.getCurrentOffset();
            predicate = this.parseExpression();
            predicateLength = this.getLength(predicateOffset);
        }
        EdgeRestriction er = null;
        if (!this.inPredicateMode()) {
            er = this.graph.createEdgeRestriction();
            if (typeIds != null) {
                for (VertexPosition<TypeOrRoleId> vertexPosition : typeIds) {
                    IsTypeIdOf typeIdOf = this.graph.createIsTypeIdOf((TypeId)vertexPosition.node, er);
                    typeIdOf.set_sourcePositions(this.createSourcePositionList(vertexPosition.length, vertexPosition.offset));
                }
            }
            if (roleIds != null) {
                for (VertexPosition<TypeOrRoleId> vertexPosition : roleIds) {
                    IsRoleIdOf roleIdOf = this.graph.createIsRoleIdOf((RoleId)vertexPosition.node, er);
                    roleIdOf.set_sourcePositions(this.createSourcePositionList(vertexPosition.length, vertexPosition.offset));
                }
            }
            if (predicate != null) {
                IsBooleanPredicateOfEdgeRestriction edge = this.graph.createIsBooleanPredicateOfEdgeRestriction(predicate, er);
                edge.set_sourcePositions(this.createSourcePositionList(predicateLength, predicateOffset));
            }
        }
        return er;
    }

    private final Comprehension parseLabeledReportList() {
        TupleConstruction tupConstr = null;
        boolean hasLabel = false;
        int offsetExpr = 0;
        int offset = 0;
        int offsetAsExpr = 0;
        int lengthAsExpr = 0;
        ListComprehension listCompr = null;
        Expression expr = null;
        int lengthExpr = 0;
        Expression asExpr = null;
        this.match(TokenTypes.REPORT);
        do {
            hasLabel = false;
            offset = offsetExpr = this.getCurrentOffset();
            expr = this.parseExpression();
            lengthExpr = this.getLength(offsetExpr);
            if (this.tryMatch(TokenTypes.AS)) {
                offsetAsExpr = this.getCurrentOffset();
                asExpr = this.parseExpression();
                lengthAsExpr = this.getLength(offsetAsExpr);
                hasLabel = true;
            }
            if (this.inPredicateMode()) continue;
            if (listCompr == null) {
                listCompr = this.graph.createListComprehension();
                tupConstr = this.graph.createTupleConstruction();
                IsCompResultDefOf e = this.graph.createIsCompResultDefOf(tupConstr, listCompr);
                e.set_sourcePositions(this.createSourcePositionList(this.getLength(offset), offset));
            }
            IsPartOf partOf = this.graph.createIsPartOf(expr, tupConstr);
            partOf.set_sourcePositions(this.createSourcePositionList(lengthExpr, offsetExpr));
            if (!hasLabel) continue;
            IsTableHeaderOf tableHeaderOf = this.graph.createIsTableHeaderOf(asExpr, listCompr);
            tableHeaderOf.set_sourcePositions(this.createSourcePositionList(lengthAsExpr, offsetAsExpr));
        } while (this.tryMatch(TokenTypes.COMMA));
        if (!this.inPredicateMode() && tupConstr.getDegree(EdgeDirection.IN) == 1) {
            Vertex v = tupConstr.getFirstIncidence(EdgeDirection.IN).getAlpha();
            Edge e2 = tupConstr.getFirstIncidence(EdgeDirection.OUT);
            e2.setAlpha(v);
            tupConstr.delete();
        }
        return listCompr;
    }

    private final Comprehension parseReportClause() {
        Comprehension comprehension = null;
        boolean map = false;
        TokenTypes separator = TokenTypes.COMMA;
        TokenTypes comprehensionType = this.lookAhead(0);
        switch (comprehensionType) {
            case REPORT: {
                return this.parseLabeledReportList();
            }
            case REPORTLIST: 
            case REPORTLISTN: {
                if (!this.inPredicateMode()) {
                    comprehension = this.graph.createListComprehension();
                }
                this.match();
                if (comprehensionType != TokenTypes.REPORTLISTN) break;
                Expression limit = this.parseExpression();
                if (!this.inPredicateMode()) {
                    comprehension.add_maxCount(limit);
                }
                this.match(TokenTypes.COLON);
                break;
            }
            case REPORTSET: 
            case REPORTSETN: {
                if (!this.inPredicateMode()) {
                    comprehension = this.graph.createSetComprehension();
                }
                this.match();
                if (comprehensionType != TokenTypes.REPORTSETN) break;
                Expression limit = this.parseExpression();
                if (!this.inPredicateMode()) {
                    comprehension.add_maxCount(limit);
                }
                this.match(TokenTypes.COLON);
                break;
            }
            case REPORTMAP: 
            case REPORTMAPN: {
                if (!this.inPredicateMode()) {
                    comprehension = this.graph.createMapComprehension();
                }
                map = true;
                separator = TokenTypes.EDGEEND;
                this.match();
                if (comprehensionType != TokenTypes.REPORTMAPN) break;
                Expression limit = this.parseExpression();
                if (!this.inPredicateMode()) {
                    comprehension.add_maxCount(limit);
                }
                this.match(TokenTypes.COLON);
                break;
            }
            default: {
                this.fail("Unrecognized token");
            }
        }
        int offset = this.getCurrentOffset();
        List<VertexPosition<Expression>> reportList = this.parseExpressionList(separator);
        int length = this.getLength(offset);
        IsCompResultDefOf e = null;
        if (map) {
            if (!this.inPredicateMode()) {
                if (reportList.size() != 2) {
                    this.fail("reportMap keyExpr -> valueExpr must be followed by exactly two arguments");
                }
                IsKeyExprOfComprehension keyEdge = this.graph.createIsKeyExprOfComprehension((Expression)reportList.get((int)0).node, (MapComprehension)comprehension);
                IsValueExprOfComprehension valueEdge = this.graph.createIsValueExprOfComprehension((Expression)reportList.get((int)1).node, (MapComprehension)comprehension);
                keyEdge.set_sourcePositions(this.createSourcePositionList(reportList.get((int)0).length, reportList.get((int)0).offset));
                valueEdge.set_sourcePositions(this.createSourcePositionList(reportList.get((int)1).length, reportList.get((int)1).offset));
            }
        } else if (!this.inPredicateMode()) {
            if (reportList.size() > 1) {
                TupleConstruction tupConstr = (TupleConstruction)this.createMultipleEdgesToParent(reportList, this.graph.createTupleConstruction(), IsPartOf.EC);
                e = this.graph.createIsCompResultDefOf(tupConstr, comprehension);
            } else {
                e = this.graph.createIsCompResultDefOf((Expression)reportList.get((int)0).node, comprehension);
            }
            e.set_sourcePositions(this.createSourcePositionList(length, offset));
        }
        return comprehension;
    }

    private final Comprehension parseFWRExpression() {
        this.match(TokenTypes.FROM);
        int offsetDecl = this.getCurrentOffset();
        List<VertexPosition<SimpleDeclaration>> declarations = this.parseDeclarationList();
        int lengthDecl = this.getLength(offsetDecl);
        Declaration declaration = null;
        if (!this.inPredicateMode()) {
            declaration = this.graph.createDeclaration();
            this.createMultipleEdgesToParent(declarations, (Vertex)declaration, IsSimpleDeclOf.EC, false);
        }
        if (this.tryMatch(TokenTypes.WITH)) {
            int offsetConstraint = this.getCurrentOffset();
            Expression constraintExpr = this.parseExpression();
            int lengthConstraint = this.getLength(offsetConstraint);
            lengthDecl += lengthConstraint;
            if (!this.inPredicateMode()) {
                IsConstraintOf constraintOf = this.graph.createIsConstraintOf(constraintExpr, declaration);
                constraintOf.set_sourcePositions(this.createSourcePositionList(lengthConstraint, offsetConstraint));
            }
        }
        Comprehension comprehension = this.parseReportClause();
        if (!this.inPredicateMode()) {
            IsCompDeclOf comprDeclOf = this.graph.createIsCompDeclOf(declaration, comprehension);
            comprDeclOf.set_sourcePositions(this.createSourcePositionList(lengthDecl, offsetDecl));
        }
        this.match(TokenTypes.END);
        return comprehension;
    }

    private final Expression parsePathExpression() {
        int pos = this.alreadySucceeded(RuleEnum.PATH_EXPRESSION);
        if (this.skipRule(pos)) {
            return null;
        }
        Expression expr = null;
        this.predicateStart();
        try {
            this.parseAltPathDescription();
            if (!this.tryMatch(TokenTypes.SMILEY)) {
                this.parseValueAccess();
            }
        }
        catch (ParsingException ex) {
            // empty catch block
        }
        if (this.predicateEnd()) {
            expr = this.parseRegBackwardVertexSetOrPathSystem();
        } else {
            this.predicateStart();
            try {
                this.parseValueAccess();
            }
            catch (ParsingException ex) {
                // empty catch block
            }
            if (this.predicateEnd()) {
                int offsetArg1 = this.getCurrentOffset();
                expr = this.parseValueAccess();
                int lengthArg1 = this.getLength(offsetArg1);
                if (this.lookAhead(0) == TokenTypes.SMILEY) {
                    expr = this.parseRegPathOrPathSystem(expr, offsetArg1, lengthArg1);
                } else {
                    this.predicateStart();
                    try {
                        this.parseAltPathDescription();
                    }
                    catch (ParsingException ex) {
                        // empty catch block
                    }
                    if (this.predicateEnd()) {
                        expr = this.parseRegPathExistenceOrForwardVertexSet(expr, offsetArg1, lengthArg1);
                    }
                }
            } else {
                expr = this.parseAltPathDescription();
            }
        }
        this.ruleSucceeds(RuleEnum.PATH_EXPRESSION, pos);
        return expr;
    }

    private final Expression parseRegPathExistenceOrForwardVertexSet(Expression expr, int offsetArg1, int lengthArg1) {
        int offsetExpr = this.getCurrentOffset();
        int offsetPathDescr = this.getCurrentOffset();
        PathDescription pathDescr = this.parseAltPathDescription();
        int lengthPathDescr = this.getLength(offsetPathDescr);
        Expression restrExpr = null;
        this.predicateStart();
        try {
            this.parsePrimaryExpression();
        }
        catch (ParsingException ex) {
            // empty catch block
        }
        if (this.predicateEnd()) {
            restrExpr = this.parseValueAccess();
            if (!this.inPredicateMode()) {
                int lengthExpr = this.getLength(offsetExpr);
                PathExistence pe = this.graph.createPathExistence();
                IsStartExprOf startVertexOf = this.graph.createIsStartExprOf(expr, pe);
                startVertexOf.set_sourcePositions(this.createSourcePositionList(lengthArg1, offsetArg1));
                IsTargetExprOf targetVertexOf = this.graph.createIsTargetExprOf(restrExpr, pe);
                targetVertexOf.set_sourcePositions(this.createSourcePositionList(lengthExpr, offsetExpr));
                IsPathOf pathOf = this.graph.createIsPathOf(pathDescr, pe);
                pathOf.set_sourcePositions(this.createSourcePositionList(lengthPathDescr, offsetPathDescr));
                return pe;
            }
            return null;
        }
        if (!this.inPredicateMode()) {
            ForwardVertexSet fvs = this.graph.createForwardVertexSet();
            IsStartExprOf startVertexOf = this.graph.createIsStartExprOf(expr, fvs);
            startVertexOf.set_sourcePositions(this.createSourcePositionList(lengthArg1, offsetArg1));
            IsPathOf pathOf = this.graph.createIsPathOf(pathDescr, fvs);
            pathOf.set_sourcePositions(this.createSourcePositionList(lengthPathDescr, offsetPathDescr));
            return fvs;
        }
        return null;
    }

    private final Expression parseRegPathOrPathSystem(Expression arg1, int offsetArg1, int lengthArg1) {
        boolean isPath = false;
        int offsetOperator1 = this.getCurrentOffset();
        int offsetExpr = offsetArg1;
        int lengthExpr = 0;
        Expression restrExpr = null;
        this.match(TokenTypes.SMILEY);
        int offsetPathDescr = this.getCurrentOffset();
        PathDescription pathDescr = this.parseAltPathDescription();
        int lengthPathDescr = this.getLength(offsetPathDescr);
        int offsetOperator2 = this.getCurrentOffset();
        if (this.tryMatch(TokenTypes.SMILEY)) {
            offsetExpr = this.getCurrentOffset();
            restrExpr = this.parseValueAccess();
            lengthExpr = this.getLength(offsetExpr);
        }
        if (!this.inPredicateMode()) {
            FunctionId funId = this.getFunctionId("pathSystem");
            FunctionApplication result = this.createFunctionIdAndArgumentOf(funId, offsetOperator1, 3, arg1, offsetArg1, lengthArg1, pathDescr, offsetPathDescr, lengthPathDescr, true);
            if (isPath) {
                result = this.createFunctionIdAndArgumentOf(funId, offsetOperator1, 3, result, offsetArg1, -offsetArg1 + offsetOperator2 + 3, restrExpr, offsetExpr, lengthExpr, true);
            }
            return result;
        }
        return null;
    }

    private final Expression parseRegBackwardVertexSetOrPathSystem() {
        boolean isPathSystem = false;
        int offsetPathDescr = this.getCurrentOffset();
        PathDescription pathDescr = this.parseAltPathDescription();
        int lengthPathDescr = this.getLength(offsetPathDescr);
        int offsetOperator = this.getCurrentOffset();
        if (this.tryMatch(TokenTypes.SMILEY)) {
            isPathSystem = true;
        }
        int offsetExpr = this.getCurrentOffset();
        Expression restrExpr = this.parseValueAccess();
        int lengthExpr = this.getLength(offsetExpr);
        if (!this.inPredicateMode()) {
            if (isPathSystem) {
                FunctionId f = this.getFunctionId("pathSystem");
                return this.createFunctionIdAndArgumentOf(f, offsetOperator, 3, pathDescr, offsetPathDescr, lengthPathDescr, restrExpr, offsetExpr, lengthExpr, true);
            }
            BackwardVertexSet bs = this.graph.createBackwardVertexSet();
            IsTargetExprOf targetVertexOf = this.graph.createIsTargetExprOf(restrExpr, bs);
            targetVertexOf.set_sourcePositions(this.createSourcePositionList(lengthExpr, offsetExpr));
            IsPathOf pathOf = this.graph.createIsPathOf(pathDescr, bs);
            pathOf.set_sourcePositions(this.createSourcePositionList(lengthPathDescr, offsetPathDescr));
            return bs;
        }
        return null;
    }

    private final Expression parseNumericLiteral() {
        if (this.lookAhead(0) == TokenTypes.DOUBLELITERAL) {
            double value = ((DoubleToken)this.lookAhead).getNumber();
            this.match();
            if (!this.inPredicateMode()) {
                DoubleLiteral literal = this.graph.createDoubleLiteral();
                literal.set_doubleValue(value);
                return literal;
            }
            return null;
        }
        if (this.lookAhead(0) == TokenTypes.LONGLITERAL) {
            long value = ((LongToken)this.lookAhead).getNumber();
            this.match();
            if (!this.inPredicateMode()) {
                if (value <= Integer.MAX_VALUE && value >= Integer.MIN_VALUE) {
                    IntLiteral literal = this.graph.createIntLiteral();
                    literal.set_intValue((int)value);
                    return literal;
                }
                LongLiteral literal = this.graph.createLongLiteral();
                literal.set_longValue(value);
                return literal;
            }
            return null;
        }
        this.fail("Unrecognized literal");
        return null;
    }

    private final Expression parseLiteral() {
        if (this.lookAhead(0) != null) {
            switch (this.lookAhead(0)) {
                case UNDEFINED: {
                    UndefinedLiteral ul = null;
                    if (!this.inPredicateMode() && (ul = this.graph.getFirstUndefinedLiteral()) == null) {
                        ul = this.graph.createUndefinedLiteral();
                    }
                    this.match();
                    return ul;
                }
                case DOUBLELITERAL: 
                case LONGLITERAL: {
                    return this.parseNumericLiteral();
                }
                case STRING: {
                    StringLiteral sl = null;
                    if (!this.inPredicateMode()) {
                        sl = this.graph.createStringLiteral();
                        sl.set_stringValue(this.lookAhead.getValue());
                    }
                    this.match();
                    return sl;
                }
                case THISEDGE: {
                    this.match();
                    ThisEdge te = null;
                    if (!this.inPredicateMode() && (te = this.graph.getFirstThisEdge()) == null) {
                        te = this.graph.createThisEdge();
                    }
                    return te;
                }
                case THISVERTEX: {
                    this.match();
                    ThisVertex tv = null;
                    if (!this.inPredicateMode() && (tv = this.graph.getFirstThisVertex()) == null) {
                        tv = this.graph.createThisVertex();
                    }
                    return tv;
                }
                case TRUE: {
                    this.match();
                    BoolLiteral tl = null;
                    if (!this.inPredicateMode()) {
                        for (tl = this.graph.getFirstBoolLiteral(); tl != null && !tl.is_boolValue(); tl = tl.getNextBoolLiteral()) {
                        }
                        if (tl == null) {
                            tl = this.graph.createBoolLiteral();
                            tl.set_boolValue(true);
                        }
                    }
                    return tl;
                }
                case FALSE: {
                    this.match();
                    BoolLiteral fl = null;
                    if (!this.inPredicateMode()) {
                        for (fl = this.graph.getFirstBoolLiteral(); fl != null && fl.is_boolValue(); fl = fl.getNextBoolLiteral()) {
                        }
                        if (fl == null) {
                            fl = this.graph.createBoolLiteral();
                            fl.set_boolValue(false);
                        }
                    }
                    return fl;
                }
            }
        }
        this.fail("Unrecognized literal");
        return null;
    }

    public GreqlSchema getSchema() {
        return SCHEMA;
    }
}

