/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.parser;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.exception.DuplicateVariableException;
import de.uni_koblenz.jgralab.greql.exception.ParsingException;
import de.uni_koblenz.jgralab.greql.exception.UndefinedVariableException;
import de.uni_koblenz.jgralab.greql.parser.SimpleSymbolTable;
import de.uni_koblenz.jgralab.greql.parser.SymbolTable;
import de.uni_koblenz.jgralab.greql.parser.Token;
import de.uni_koblenz.jgralab.greql.schema.Comprehension;
import de.uni_koblenz.jgralab.greql.schema.Declaration;
import de.uni_koblenz.jgralab.greql.schema.Definition;
import de.uni_koblenz.jgralab.greql.schema.DefinitionExpression;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.FunctionApplication;
import de.uni_koblenz.jgralab.greql.schema.FunctionId;
import de.uni_koblenz.jgralab.greql.schema.GreqlAggregation;
import de.uni_koblenz.jgralab.greql.schema.GreqlExpression;
import de.uni_koblenz.jgralab.greql.schema.GreqlGraph;
import de.uni_koblenz.jgralab.greql.schema.GreqlVertex;
import de.uni_koblenz.jgralab.greql.schema.IsArgumentOf;
import de.uni_koblenz.jgralab.greql.schema.IsBooleanPredicateOfEdgeRestriction;
import de.uni_koblenz.jgralab.greql.schema.IsBoundExprOfDefinition;
import de.uni_koblenz.jgralab.greql.schema.IsBoundExprOfQuantifiedExpression;
import de.uni_koblenz.jgralab.greql.schema.IsBoundVarOf;
import de.uni_koblenz.jgralab.greql.schema.IsCompDeclOf;
import de.uni_koblenz.jgralab.greql.schema.IsCompResultDefOf;
import de.uni_koblenz.jgralab.greql.schema.IsConstraintOf;
import de.uni_koblenz.jgralab.greql.schema.IsDeclaredVarOf;
import de.uni_koblenz.jgralab.greql.schema.IsDefinitionOf;
import de.uni_koblenz.jgralab.greql.schema.IsExprOf;
import de.uni_koblenz.jgralab.greql.schema.IsFunctionIdOf;
import de.uni_koblenz.jgralab.greql.schema.IsGoalRestrOf;
import de.uni_koblenz.jgralab.greql.schema.IsKeyExprOfComprehension;
import de.uni_koblenz.jgralab.greql.schema.IsQuantifiedDeclOf;
import de.uni_koblenz.jgralab.greql.schema.IsQueryExprOf;
import de.uni_koblenz.jgralab.greql.schema.IsSimpleDeclOf;
import de.uni_koblenz.jgralab.greql.schema.IsStartRestrOf;
import de.uni_koblenz.jgralab.greql.schema.IsTableHeaderOf;
import de.uni_koblenz.jgralab.greql.schema.IsValueExprOfComprehension;
import de.uni_koblenz.jgralab.greql.schema.IsVarOf;
import de.uni_koblenz.jgralab.greql.schema.ListComprehension;
import de.uni_koblenz.jgralab.greql.schema.MapComprehension;
import de.uni_koblenz.jgralab.greql.schema.PathDescription;
import de.uni_koblenz.jgralab.greql.schema.QuantifiedExpression;
import de.uni_koblenz.jgralab.greql.schema.SimpleDeclaration;
import de.uni_koblenz.jgralab.greql.schema.SourcePosition;
import de.uni_koblenz.jgralab.greql.schema.ThisEdge;
import de.uni_koblenz.jgralab.greql.schema.ThisLiteral;
import de.uni_koblenz.jgralab.greql.schema.ThisVertex;
import de.uni_koblenz.jgralab.greql.schema.Variable;
import de.uni_koblenz.jgralab.greql.schema.WhereExpression;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.VertexClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.pcollections.PVector;

public abstract class ParserHelper {
    protected String query = null;
    protected GreqlGraph graph;
    protected SymbolTable afterParsingvariableSymbolTable = null;
    protected SimpleSymbolTable duringParsingvariableSymbolTable = null;
    protected Map<String, FunctionId> functionSymbolTable;
    protected boolean graphCleaned = false;
    protected Token lookAhead = null;

    protected abstract boolean inPredicateMode();

    protected final int getCurrentOffset() {
        if (this.lookAhead != null) {
            return this.lookAhead.getOffset();
        }
        return this.query.length();
    }

    protected final int getLength(int offset) {
        return this.getCurrentOffset() - offset;
    }

    public PathDescription addPathElement(VertexClass vc, EdgeClass ec, PathDescription pathDescr, PathDescription part1, int offsetPart1, int lengthPart1, PathDescription part2, int offsetPart2, int lengthPart2) {
        GreqlAggregation edge = null;
        if (pathDescr == null) {
            pathDescr = (PathDescription)this.graph.createVertex(vc);
            edge = (GreqlAggregation)this.graph.createEdge(ec, part1, pathDescr);
            edge.set_sourcePositions(this.createSourcePositionList(lengthPart1, offsetPart1));
        }
        edge = (GreqlAggregation)this.graph.createEdge(ec, part2, pathDescr);
        edge.set_sourcePositions(this.createSourcePositionList(lengthPart2, offsetPart2));
        return pathDescr;
    }

    public GreqlGraph getGraph() {
        if (this.graph == null) {
            return null;
        }
        this.cleanGraph();
        return this.graph;
    }

    private void cleanGraph() {
        if (!this.graphCleaned) {
            HashSet<Vertex> reachableVertices = new HashSet<Vertex>();
            LinkedList<Vertex> queue = new LinkedList<Vertex>();
            GreqlExpression root = this.graph.getFirstGreqlExpression();
            queue.add(root);
            while (!queue.isEmpty()) {
                Vertex current = (Vertex)queue.poll();
                if (current == null) continue;
                for (Edge e : current.incidences()) {
                    if (reachableVertices.contains(e.getThat())) continue;
                    queue.add(e.getThat());
                    reachableVertices.add(e.getThat());
                }
            }
            Vertex deleteCandidate = this.graph.getFirstVertex();
            while (deleteCandidate != null && !reachableVertices.contains(deleteCandidate)) {
                deleteCandidate.delete();
                deleteCandidate = this.graph.getFirstVertex();
            }
            while (deleteCandidate != null) {
                if (!reachableVertices.contains(deleteCandidate)) {
                    Vertex v = deleteCandidate.getNextVertex();
                    deleteCandidate.delete();
                    deleteCandidate = v;
                    continue;
                }
                deleteCandidate = deleteCandidate.getNextVertex();
            }
            this.replaceDefinitionExpressions();
            this.eliminateUnusedNodes();
        }
    }

    protected void replaceDefinitionExpressions() throws DuplicateVariableException, UndefinedVariableException {
        ArrayList<DefinitionExpression> list = new ArrayList<DefinitionExpression>();
        for (DefinitionExpression exp : this.graph.getDefinitionExpressionVertices()) {
            list.add(exp);
        }
        for (DefinitionExpression exp : list) {
            ArrayList<Definition> defList = new ArrayList<Definition>();
            for (IsDefinitionOf isDefOf : exp.getIsDefinitionOfIncidences(EdgeDirection.IN)) {
                Definition definition = isDefOf.getAlpha();
                defList.add(definition);
            }
            if (exp instanceof WhereExpression) {
                Collections.reverse(defList);
            }
            for (Definition definition : defList) {
                IsExprOf isExprOf = definition.getFirstIsExprOfIncidence(EdgeDirection.IN);
                IsVarOf isVarOf = definition.getFirstIsVarOfIncidence(EdgeDirection.IN);
                Expression expr = isExprOf.getAlpha();
                Variable variable = isVarOf.getAlpha();
                isVarOf.delete();
                isExprOf.delete();
                Edge e = variable.getFirstIncidence(EdgeDirection.OUT);
                while (e != null) {
                    e.setAlpha(expr);
                    e = variable.getFirstIncidence(EdgeDirection.OUT);
                }
                variable.delete();
            }
            Expression boundExpr = exp.getFirstIsBoundExprOfIncidence(EdgeDirection.IN).getAlpha();
            Edge e = exp.getFirstIncidence(EdgeDirection.OUT);
            while (e != null) {
                e.setAlpha(boundExpr);
                e = exp.getFirstIncidence(EdgeDirection.OUT);
            }
            exp.delete();
        }
    }

    protected void eliminateUnusedNodes() {
        ArrayList<Vertex> deleteList = new ArrayList<Vertex>();
        for (Vertex v : this.graph.vertices()) {
            if (v.getFirstIncidence() != null) continue;
            deleteList.add(v);
        }
        for (Vertex v : deleteList) {
            v.delete();
        }
    }

    private void mergeVariables(Vertex v, boolean separateScope) throws DuplicateVariableException, UndefinedVariableException {
        block4: {
            block8: {
                block9: {
                    block7: {
                        block6: {
                            block5: {
                                block3: {
                                    if (!(v instanceof DefinitionExpression)) break block3;
                                    this.mergeVariablesInDefinitionExpression((DefinitionExpression)v, separateScope);
                                    break block4;
                                }
                                if (!(v instanceof Comprehension)) break block5;
                                this.mergeVariablesInComprehension((Comprehension)v, separateScope);
                                break block4;
                            }
                            if (!(v instanceof QuantifiedExpression)) break block6;
                            this.mergeVariablesInQuantifiedExpression((QuantifiedExpression)v, separateScope);
                            break block4;
                        }
                        if (!(v instanceof GreqlExpression)) break block7;
                        this.mergeVariablesInGreqlExpression((GreqlExpression)v);
                        break block4;
                    }
                    if (v instanceof ThisLiteral) {
                        return;
                    }
                    if (!(v instanceof Variable)) break block8;
                    Vertex var = this.afterParsingvariableSymbolTable.lookup(((Variable)v).get_name());
                    if (var == null) break block9;
                    if (var == v) break block4;
                    Edge inc = v.getFirstIncidence(EdgeDirection.OUT);
                    inc.setAlpha(var);
                    if (v.getDegree() > 0) break block4;
                    v.delete();
                    break block4;
                }
                GreqlAggregation e = (GreqlAggregation)v.getFirstIncidence(EdgeDirection.OUT);
                throw new UndefinedVariableException((Variable)v, e.get_sourcePositions());
            }
            ArrayList<Edge> incidenceList = new ArrayList<Edge>();
            for (Edge inc : v.incidences(EdgeDirection.IN)) {
                incidenceList.add(inc);
            }
            for (Edge e : incidenceList) {
                this.mergeVariables(e.getAlpha(), true);
            }
        }
    }

    protected final void mergeVariablesInGreqlExpression(GreqlExpression root) throws DuplicateVariableException, UndefinedVariableException {
        this.afterParsingvariableSymbolTable.blockBegin();
        for (IsBoundVarOf isBoundVarOf : root.getIsBoundVarOfIncidences(EdgeDirection.IN)) {
            this.afterParsingvariableSymbolTable.insert(isBoundVarOf.getAlpha().get_name(), isBoundVarOf.getAlpha());
        }
        IsQueryExprOf isQueryExprOf = root.getFirstIsQueryExprOfIncidence(EdgeDirection.IN);
        this.mergeVariables(isQueryExprOf.getAlpha(), true);
        this.afterParsingvariableSymbolTable.blockEnd();
    }

    private void mergeVariablesInDefinitionExpression(DefinitionExpression v, boolean separateScope) throws DuplicateVariableException, UndefinedVariableException {
        if (separateScope) {
            this.afterParsingvariableSymbolTable.blockBegin();
        }
        for (IsDefinitionOf currentEdge : v.getIsDefinitionOfIncidences(EdgeDirection.IN)) {
            Definition definition = currentEdge.getAlpha();
            Variable variable = definition.getFirstIsVarOfIncidence(EdgeDirection.IN).getAlpha();
            this.afterParsingvariableSymbolTable.insert(variable.get_name(), variable);
        }
        IsBoundExprOfDefinition isBoundExprOf = v.getFirstIsBoundExprOfDefinitionIncidence(EdgeDirection.IN);
        this.mergeVariables(isBoundExprOf.getAlpha(), false);
        for (IsDefinitionOf currentEdge : v.getIsDefinitionOfIncidences(EdgeDirection.IN)) {
            Definition definition = currentEdge.getAlpha();
            Expression expr = definition.getFirstIsExprOfIncidence(EdgeDirection.IN).getAlpha();
            this.mergeVariables(expr, true);
        }
        if (separateScope) {
            this.afterParsingvariableSymbolTable.blockEnd();
        }
    }

    private void mergeVariablesInDeclaration(Declaration v) throws DuplicateVariableException, UndefinedVariableException {
        SimpleDeclaration simpleDecl;
        for (IsSimpleDeclOf currentEdge : v.getIsSimpleDeclOfIncidences(EdgeDirection.IN)) {
            simpleDecl = currentEdge.getAlpha();
            for (IsDeclaredVarOf isDeclaredVarOf : simpleDecl.getIsDeclaredVarOfIncidences(EdgeDirection.IN)) {
                Variable variable = isDeclaredVarOf.getAlpha();
                this.afterParsingvariableSymbolTable.insert(variable.get_name(), variable);
            }
        }
        for (IsSimpleDeclOf currentEdge : v.getIsSimpleDeclOfIncidences(EdgeDirection.IN)) {
            simpleDecl = currentEdge.getAlpha();
            Expression expr = simpleDecl.getFirstIsTypeExprOfIncidence(EdgeDirection.IN).getAlpha();
            this.mergeVariables(expr, true);
        }
        for (IsConstraintOf isConstraintOf : v.getIsConstraintOfIncidences(EdgeDirection.IN)) {
            this.mergeVariables(isConstraintOf.getAlpha(), true);
        }
    }

    private void mergeVariablesInQuantifiedExpression(QuantifiedExpression v, boolean separateScope) throws DuplicateVariableException, UndefinedVariableException {
        if (separateScope) {
            this.afterParsingvariableSymbolTable.blockBegin();
        }
        IsQuantifiedDeclOf isQuantifiedDeclOf = v.getFirstIsQuantifiedDeclOfIncidence(EdgeDirection.IN);
        this.mergeVariablesInDeclaration(isQuantifiedDeclOf.getAlpha());
        IsBoundExprOfQuantifiedExpression isBoundExprOfQuantifier = v.getFirstIsBoundExprOfQuantifiedExpressionIncidence(EdgeDirection.IN);
        this.mergeVariables(isBoundExprOfQuantifier.getAlpha(), true);
        if (separateScope) {
            this.afterParsingvariableSymbolTable.blockEnd();
        }
    }

    private void mergeVariablesInComprehension(Comprehension v, boolean separateScope) throws DuplicateVariableException, UndefinedVariableException {
        if (separateScope) {
            this.afterParsingvariableSymbolTable.blockBegin();
        }
        IsCompDeclOf IsCompDeclOf2 = v.getFirstIsCompDeclOfIncidence(EdgeDirection.IN);
        this.mergeVariablesInDeclaration((Declaration)IsCompDeclOf2.getAlpha());
        IsCompResultDefOf isCompResultDefOf = v.getFirstIsCompResultDefOfIncidence(EdgeDirection.IN);
        if (isCompResultDefOf != null) {
            this.mergeVariables(isCompResultDefOf.getAlpha(), true);
            if (v instanceof ListComprehension) {
                for (IsTableHeaderOf isTableHeaderOf = v.getFirstIsTableHeaderOfIncidence(EdgeDirection.IN); isTableHeaderOf != null; isTableHeaderOf = isTableHeaderOf.getNextIsTableHeaderOfIncidence(EdgeDirection.IN)) {
                    this.mergeVariables(isTableHeaderOf.getAlpha(), true);
                }
            }
        }
        if (v instanceof MapComprehension) {
            IsKeyExprOfComprehension keyEdge = ((MapComprehension)v).getFirstIsKeyExprOfComprehensionIncidence();
            this.mergeVariables(keyEdge.getAlpha(), true);
            IsValueExprOfComprehension valueEdge = ((MapComprehension)v).getFirstIsValueExprOfComprehensionIncidence();
            this.mergeVariables(valueEdge.getAlpha(), true);
        }
        if (separateScope) {
            this.afterParsingvariableSymbolTable.blockEnd();
        }
    }

    protected abstract void debug(String var1);

    protected final FunctionId getFunctionId(String name) {
        FunctionId functionId = this.functionSymbolTable.get(name);
        if (functionId == null) {
            functionId = this.graph.createFunctionId();
            functionId.set_name(name);
            this.functionSymbolTable.put(name, functionId);
        }
        return functionId;
    }

    protected FunctionApplication createFunctionIdAndArgumentOf(FunctionId functionId, int offsetOperator, int lengthOperator, Expression arg1, int offsetArg1, int lengthArg1, Expression arg2, int offsetArg2, int lengthArg2, boolean binary) {
        FunctionApplication fa = this.graph.createFunctionApplication();
        IsFunctionIdOf functionIdOf = this.graph.createIsFunctionIdOf(functionId, fa);
        functionIdOf.set_sourcePositions(this.createSourcePositionList(lengthOperator, offsetOperator));
        IsArgumentOf arg1Of = null;
        if (binary) {
            arg1Of = this.graph.createIsArgumentOf(arg1, fa);
            arg1Of.set_sourcePositions(this.createSourcePositionList(lengthArg1, offsetArg1));
        }
        IsArgumentOf arg2Of = this.graph.createIsArgumentOf(arg2, fa);
        arg2Of.set_sourcePositions(this.createSourcePositionList(lengthArg2, offsetArg2));
        return fa;
    }

    protected final PVector<SourcePosition> createSourcePositionList(int length, int offset) {
        PVector list = JGraLab.vector();
        return list.plus(new SourcePosition(length, offset));
    }

    /*
     * WARNING - void declaration
     */
    protected final void testIllegalThisLiterals() {
        GreqlVertex omega;
        GreqlVertex currentVertex;
        LinkedList<GreqlVertex> queue;
        HashSet<Class> allowedEdgesForThisVertex = new HashSet<Class>();
        HashSet<Class<IsBooleanPredicateOfEdgeRestriction>> allowedEdgesForThisEdge = new HashSet<Class<IsBooleanPredicateOfEdgeRestriction>>();
        allowedEdgesForThisVertex.add(IsGoalRestrOf.class);
        allowedEdgesForThisVertex.add(IsStartRestrOf.class);
        allowedEdgesForThisEdge.add(IsBooleanPredicateOfEdgeRestriction.class);
        for (ThisLiteral thisLiteral : this.graph.getThisVertexVertices()) {
            for (Edge sourcePositionEdge : thisLiteral.incidences(EdgeDirection.OUT)) {
                queue = new LinkedList<GreqlVertex>();
                queue.add(thisLiteral);
                while (!queue.isEmpty()) {
                    currentVertex = (GreqlVertex)queue.poll();
                    for (Edge edge : currentVertex.incidences(EdgeDirection.OUT)) {
                        if (allowedEdgesForThisVertex.contains(edge.getSchemaClass())) continue;
                        omega = (GreqlVertex)edge.getOmega();
                        if (omega instanceof GreqlExpression) {
                            throw new ParsingException("This literals must not be used outside pathdescriptions", thisLiteral.get_name(), ((SourcePosition)((GreqlAggregation)sourcePositionEdge).get_sourcePositions().get(0)).get_offset(), ((SourcePosition)((GreqlAggregation)sourcePositionEdge).get_sourcePositions().get(0)).get_length(), this.query);
                        }
                        queue.add(omega);
                    }
                }
            }
        }
        for (ThisLiteral thisLiteral : this.graph.getThisEdgeVertices()) {
            for (Edge sourcePositionEdge : thisLiteral.incidences(EdgeDirection.OUT)) {
                queue = new LinkedList();
                queue.add(thisLiteral);
                while (!queue.isEmpty()) {
                    currentVertex = (GreqlVertex)queue.poll();
                    for (Edge edge : currentVertex.incidences(EdgeDirection.OUT)) {
                        if (allowedEdgesForThisEdge.contains(edge.getSchemaClass())) continue;
                        omega = (GreqlVertex)edge.getOmega();
                        if (omega instanceof GreqlExpression) {
                            throw new ParsingException("This literals must not be used outside pathdescriptions", thisLiteral.get_name(), ((SourcePosition)((GreqlAggregation)sourcePositionEdge).get_sourcePositions().get(0)).get_offset(), ((SourcePosition)((GreqlAggregation)sourcePositionEdge).get_sourcePositions().get(0)).get_length(), this.query);
                        }
                        queue.add(omega);
                    }
                }
            }
        }
        LinkedList<ThisLiteral> literalsToDelete = new LinkedList<ThisLiteral>();
        Object var4_7 = null;
        for (ThisVertex thisVertex : this.graph.getThisVertexVertices()) {
            void var4_8;
            if (var4_8 == null) {
                ThisVertex thisVertex2 = thisVertex;
                continue;
            }
            while (thisVertex.getFirstIncidence() != null) {
                Edge e = thisVertex.getFirstIncidence();
                e.setThis((Vertex)var4_8);
            }
            literalsToDelete.add(thisVertex);
        }
        ThisEdge firstThisEdge = null;
        for (ThisEdge thisEdge : this.graph.getThisEdgeVertices()) {
            if (firstThisEdge == null) {
                firstThisEdge = thisEdge;
                continue;
            }
            while (thisEdge.getFirstIncidence() != null) {
                Edge e = thisEdge.getFirstIncidence();
                e.setThis(firstThisEdge);
            }
            literalsToDelete.add(thisEdge);
        }
        while (!literalsToDelete.isEmpty()) {
            ((Vertex)literalsToDelete.getFirst()).delete();
        }
    }

    class FunctionConstruct {
        String operatorName = null;
        Expression arg1 = null;
        Expression arg2 = null;
        FunctionId op = null;
        int offsetArg1 = 0;
        int lengthArg1 = 0;
        int offsetOperator = 0;
        int offsetArg2 = 0;
        int lengthOperator = 0;
        int lengthArg2 = 0;
        boolean binary = true;

        public FunctionConstruct(FunctionConstruct leftPart) {
            this.offsetArg1 = leftPart.offsetArg1;
        }

        public FunctionConstruct() {
        }

        public boolean isValidFunction() {
            return this.operatorName != null;
        }

        public void preUnaryOp() {
            this.binary = false;
            this.offsetOperator = ParserHelper.this.getCurrentOffset();
        }

        public void preArg1() {
            this.offsetArg1 = ParserHelper.this.getCurrentOffset();
        }

        public void preOp(Expression arg1) {
            this.binary = true;
            this.arg1 = arg1;
            this.lengthArg1 = ParserHelper.this.getLength(this.offsetArg1);
            this.offsetOperator = ParserHelper.this.getCurrentOffset();
        }

        public void postOp(String op) {
            this.lengthOperator = ParserHelper.this.getLength(this.offsetOperator);
            this.offsetArg2 = ParserHelper.this.getCurrentOffset();
            this.operatorName = op;
        }

        public FunctionApplication postArg2(Expression arg2) {
            if (ParserHelper.this.inPredicateMode()) {
                return null;
            }
            this.lengthArg2 = ParserHelper.this.getLength(this.offsetArg2);
            this.op = ParserHelper.this.getFunctionId(this.operatorName);
            return ParserHelper.this.createFunctionIdAndArgumentOf(this.op, this.offsetOperator, this.lengthOperator, this.arg1, this.offsetArg1, this.lengthArg1, arg2, this.offsetArg2, this.lengthArg2, this.binary);
        }
    }
}

