/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.serialising;

import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.greql.exception.GreqlException;
import de.uni_koblenz.jgralab.greql.schema.AggregationPathDescription;
import de.uni_koblenz.jgralab.greql.schema.AlternativePathDescription;
import de.uni_koblenz.jgralab.greql.schema.BackwardVertexSet;
import de.uni_koblenz.jgralab.greql.schema.BoolLiteral;
import de.uni_koblenz.jgralab.greql.schema.Comprehension;
import de.uni_koblenz.jgralab.greql.schema.ConditionalExpression;
import de.uni_koblenz.jgralab.greql.schema.Declaration;
import de.uni_koblenz.jgralab.greql.schema.Definition;
import de.uni_koblenz.jgralab.greql.schema.DefinitionExpression;
import de.uni_koblenz.jgralab.greql.schema.Direction;
import de.uni_koblenz.jgralab.greql.schema.DoubleLiteral;
import de.uni_koblenz.jgralab.greql.schema.EdgePathDescription;
import de.uni_koblenz.jgralab.greql.schema.EdgeRestriction;
import de.uni_koblenz.jgralab.greql.schema.EdgeSetExpression;
import de.uni_koblenz.jgralab.greql.schema.EdgeTypeSubgraph;
import de.uni_koblenz.jgralab.greql.schema.ElementSetExpression;
import de.uni_koblenz.jgralab.greql.schema.ExponentiatedPathDescription;
import de.uni_koblenz.jgralab.greql.schema.Expression;
import de.uni_koblenz.jgralab.greql.schema.ExpressionDefinedSubgraph;
import de.uni_koblenz.jgralab.greql.schema.ForwardVertexSet;
import de.uni_koblenz.jgralab.greql.schema.FunctionApplication;
import de.uni_koblenz.jgralab.greql.schema.FunctionId;
import de.uni_koblenz.jgralab.greql.schema.GReQLDirection;
import de.uni_koblenz.jgralab.greql.schema.GreqlExpression;
import de.uni_koblenz.jgralab.greql.schema.GreqlGraph;
import de.uni_koblenz.jgralab.greql.schema.GreqlVertex;
import de.uni_koblenz.jgralab.greql.schema.Identifier;
import de.uni_koblenz.jgralab.greql.schema.IntLiteral;
import de.uni_koblenz.jgralab.greql.schema.IntermediateVertexPathDescription;
import de.uni_koblenz.jgralab.greql.schema.IsExpressionOnSubgraph;
import de.uni_koblenz.jgralab.greql.schema.IsSubgraphDefiningExpression;
import de.uni_koblenz.jgralab.greql.schema.IsSubgraphDefinitionOf;
import de.uni_koblenz.jgralab.greql.schema.IsTableHeaderOf;
import de.uni_koblenz.jgralab.greql.schema.IsTypeExprOfFunction;
import de.uni_koblenz.jgralab.greql.schema.IteratedPathDescription;
import de.uni_koblenz.jgralab.greql.schema.IterationType;
import de.uni_koblenz.jgralab.greql.schema.LetExpression;
import de.uni_koblenz.jgralab.greql.schema.ListComprehension;
import de.uni_koblenz.jgralab.greql.schema.ListConstruction;
import de.uni_koblenz.jgralab.greql.schema.ListRangeConstruction;
import de.uni_koblenz.jgralab.greql.schema.Literal;
import de.uni_koblenz.jgralab.greql.schema.LongLiteral;
import de.uni_koblenz.jgralab.greql.schema.MapComprehension;
import de.uni_koblenz.jgralab.greql.schema.MapConstruction;
import de.uni_koblenz.jgralab.greql.schema.OptionalPathDescription;
import de.uni_koblenz.jgralab.greql.schema.PathDescription;
import de.uni_koblenz.jgralab.greql.schema.PathExistence;
import de.uni_koblenz.jgralab.greql.schema.PathExpression;
import de.uni_koblenz.jgralab.greql.schema.PrimaryPathDescription;
import de.uni_koblenz.jgralab.greql.schema.QuantifiedExpression;
import de.uni_koblenz.jgralab.greql.schema.Quantifier;
import de.uni_koblenz.jgralab.greql.schema.RecordConstruction;
import de.uni_koblenz.jgralab.greql.schema.RecordElement;
import de.uni_koblenz.jgralab.greql.schema.RoleId;
import de.uni_koblenz.jgralab.greql.schema.SequentialPathDescription;
import de.uni_koblenz.jgralab.greql.schema.SetComprehension;
import de.uni_koblenz.jgralab.greql.schema.SetConstruction;
import de.uni_koblenz.jgralab.greql.schema.SimpleDeclaration;
import de.uni_koblenz.jgralab.greql.schema.SimplePathDescription;
import de.uni_koblenz.jgralab.greql.schema.StringLiteral;
import de.uni_koblenz.jgralab.greql.schema.SubgraphDefinition;
import de.uni_koblenz.jgralab.greql.schema.SubgraphRestrictedExpression;
import de.uni_koblenz.jgralab.greql.schema.ThisEdge;
import de.uni_koblenz.jgralab.greql.schema.ThisVertex;
import de.uni_koblenz.jgralab.greql.schema.TransposedPathDescription;
import de.uni_koblenz.jgralab.greql.schema.TupleConstruction;
import de.uni_koblenz.jgralab.greql.schema.TypeId;
import de.uni_koblenz.jgralab.greql.schema.UndefinedLiteral;
import de.uni_koblenz.jgralab.greql.schema.ValueConstruction;
import de.uni_koblenz.jgralab.greql.schema.Variable;
import de.uni_koblenz.jgralab.greql.schema.VertexSetExpression;
import de.uni_koblenz.jgralab.greql.schema.VertexTypeSubgraph;
import de.uni_koblenz.jgralab.greql.schema.WhereExpression;
import java.util.Iterator;
import org.pcollections.PSet;

public class GreqlSerializer {
    private StringBuilder sb = null;

    public static String serializeGraph(GreqlGraph greqlGraph) {
        GreqlSerializer s = new GreqlSerializer();
        return s.serializeGreqlVertex(greqlGraph.getFirstGreqlExpression());
    }

    public static String serializeVertex(GreqlVertex v) {
        GreqlSerializer s = new GreqlSerializer();
        return s.serializeGreqlVertex(v);
    }

    public String serializeGreqlVertex(GreqlVertex v) {
        this.sb = new StringBuilder();
        this.serializeGreqlVertex(v, false);
        return this.sb.toString();
    }

    private void serializeGreqlVertex(GreqlVertex v, boolean addSpace) {
        if (v instanceof Declaration) {
            Declaration d = (Declaration)v;
            if (d.getFirstIsQuantifiedDeclOfIncidence() != null) {
                this.serializeDeclaration((Declaration)v, false);
            } else {
                this.serializeDeclaration((Declaration)v, true);
            }
        } else if (v instanceof Definition) {
            this.serializeDefinition((Definition)v);
        } else if (v instanceof Direction) {
            this.serializeDirection((Direction)v);
        } else if (v instanceof EdgeRestriction) {
            this.serializeEdgeRestriction((EdgeRestriction)v);
        } else if (v instanceof GreqlExpression) {
            this.serializeGreqlExpression((GreqlExpression)v);
        } else if (v instanceof Quantifier) {
            this.serializeQuantifier((Quantifier)v);
        } else if (v instanceof RecordElement) {
            this.serializeRecordElement((RecordElement)v);
        } else if (v instanceof SimpleDeclaration) {
            this.serializeSimpleDeclaration((SimpleDeclaration)v);
        } else if (v instanceof Expression) {
            this.serializeExpression((Expression)v, false);
        } else {
            throw new GreqlException("Unknown GreqlVertex " + v + ".");
        }
        if (addSpace) {
            this.sb.append(' ');
        }
    }

    private void serializeSimpleDeclaration(SimpleDeclaration v) {
        boolean first = true;
        for (Variable var : v.get_declaredVar()) {
            if (first) {
                first = false;
            } else {
                this.sb.append(", ");
            }
            this.serializeVariable(var);
        }
        this.sb.append(": ");
        this.serializeExpression(v.get_typeExpr(), false);
    }

    private void serializeRecordElement(RecordElement v) {
        this.serializeIdentifier(v.get_recordId());
        this.sb.append(" : ");
        this.serializeExpression(v.get_recordExpr(), false);
    }

    private void serializeQuantifier(Quantifier v) {
        switch (v.get_type()) {
            case EXISTS: {
                this.sb.append("exists");
                break;
            }
            case EXISTSONE: {
                this.sb.append("exists!");
                break;
            }
            case FORALL: {
                this.sb.append("forall");
                break;
            }
            default: {
                throw new RuntimeException("FIXME: Unhandled QuantificationType: " + (Object)((Object)v.get_type()));
            }
        }
    }

    private void serializeEdgeRestriction(EdgeRestriction v) {
        String delim = "";
        for (TypeId tid : v.get_typeId()) {
            this.sb.append(delim);
            this.serializeIdentifier(tid);
            delim = ",";
        }
        for (RoleId rid : v.get_roleId()) {
            this.sb.append(delim);
            delim = ",";
            this.serializeIdentifier(rid);
        }
        Expression predicate = v.get_booleanPredicate();
        if (predicate != null) {
            this.sb.append(" @ ");
            this.serializeExpression(predicate, false);
        }
    }

    private void serializeDirection(Direction v) {
        this.sb.append((Object)v.get_dirValue());
    }

    private void serializeDefinition(Definition v) {
        this.serializeVariable(v.get_var());
        this.sb.append(" := ");
        this.serializeExpression(v.get_expr(), false);
    }

    private void serializeDeclaration(Declaration v, boolean declOfFWR) {
        boolean first = true;
        for (SimpleDeclaration sd : v.get_simpleDecl()) {
            if (first) {
                first = false;
            } else {
                this.sb.append(", ");
            }
            this.serializeSimpleDeclaration(sd);
        }
        first = true;
        for (Expression constraint : v.get_constraint()) {
            if (declOfFWR) {
                this.sb.append(" with ");
            } else {
                this.sb.append(", ");
            }
            this.serializeExpression(constraint, false);
        }
    }

    private void serializeGreqlExpression(GreqlExpression greql2Expression) {
        Iterable boundVars = greql2Expression.get_boundVar();
        PSet<String> importedTypes = greql2Expression.get_importedTypes();
        if (importedTypes != null) {
            for (String impType : importedTypes) {
                this.sb.append("import ").append(impType).append(";\n");
            }
        }
        if (boundVars.iterator().hasNext()) {
            this.sb.append("using ");
            boolean first = true;
            for (Variable v : boundVars) {
                if (first) {
                    first = false;
                } else {
                    this.sb.append(", ");
                }
                this.serializeVariable(v);
            }
            this.sb.append(':');
        }
        this.serializeExpression(greql2Expression.get_queryExpr(), false);
    }

    private void serializeExpression(Expression exp, boolean addSpace) {
        if (exp instanceof ConditionalExpression) {
            this.serializeConditionalExpression((ConditionalExpression)exp);
        } else if (exp instanceof FunctionApplication) {
            this.serializeFunctionApplication((FunctionApplication)exp);
        } else if (exp instanceof Literal) {
            this.serializeLiteral((Literal)exp);
        } else if (exp instanceof Variable) {
            this.serializeVariable((Variable)exp);
        } else if (exp instanceof Identifier) {
            this.serializeIdentifier((Identifier)exp);
        } else if (exp instanceof QuantifiedExpression) {
            this.serializeQuantifiedExpression((QuantifiedExpression)exp);
        } else if (exp instanceof Comprehension) {
            this.serializeComprehension((Comprehension)exp);
        } else if (exp instanceof DefinitionExpression) {
            this.serializeDefinitionExpression((DefinitionExpression)exp);
        } else if (exp instanceof ElementSetExpression) {
            this.serializeElementSetExpression((ElementSetExpression)exp);
        } else if (exp instanceof PathDescription) {
            this.serializePathDescription((PathDescription)exp);
        } else if (exp instanceof PathExpression) {
            this.serializePathExpression((PathExpression)exp);
        } else if (exp instanceof SubgraphRestrictedExpression) {
            this.serializeSubgraphRestrictedExpression((SubgraphRestrictedExpression)exp);
        } else if (exp instanceof ValueConstruction) {
            this.serializeValueConstruction((ValueConstruction)exp);
        } else {
            throw new GreqlException("Unknown Expression " + exp + ". Serialization so far: " + this.sb.toString());
        }
        if (addSpace) {
            this.sb.append(' ');
        }
    }

    private void serializeValueConstruction(ValueConstruction exp) {
        if (exp instanceof ListConstruction) {
            this.serializeListConstruction((ListConstruction)exp);
        } else if (exp instanceof MapConstruction) {
            this.serializeMapConstruction((MapConstruction)exp);
        } else if (exp instanceof RecordConstruction) {
            this.serializeRecordConstruction((RecordConstruction)exp);
        } else if (exp instanceof SetConstruction) {
            this.serializeSetConstruction((SetConstruction)exp);
        } else if (exp instanceof TupleConstruction) {
            this.serializeTupleConstruction((TupleConstruction)exp);
        } else {
            throw new GreqlException("Unknown ValueConstruction " + exp + ".");
        }
    }

    private void serializeTupleConstruction(TupleConstruction exp) {
        this.sb.append("tup(");
        boolean first = true;
        for (Expression val : exp.get_part()) {
            if (first) {
                first = false;
            } else {
                this.sb.append(", ");
            }
            this.serializeExpression(val, false);
        }
        this.sb.append(")");
    }

    private void serializeSetConstruction(SetConstruction exp) {
        this.sb.append("set(");
        boolean first = true;
        for (Expression val : exp.get_part()) {
            if (first) {
                first = false;
            } else {
                this.sb.append(", ");
            }
            this.serializeExpression(val, false);
        }
        this.sb.append(")");
    }

    private void serializeRecordConstruction(RecordConstruction exp) {
        this.sb.append("rec(");
        boolean first = true;
        for (RecordElement re : exp.get_recordElement()) {
            if (first) {
                first = false;
            } else {
                this.sb.append(", ");
            }
            this.serializeRecordElement(re);
        }
        this.sb.append(')');
    }

    private void serializeMapConstruction(MapConstruction exp) {
        this.sb.append("map(");
        Iterator vals = exp.get_valueExpr().iterator();
        String sep = "";
        for (Expression key : exp.get_keyExpr()) {
            this.sb.append(sep);
            sep = ", ";
            this.serializeExpression(key, true);
            this.sb.append("-> ");
            this.serializeExpression((Expression)vals.next(), false);
        }
        this.sb.append(")");
    }

    private void serializeListConstruction(ListConstruction exp) {
        this.sb.append("list(");
        if (exp instanceof ListRangeConstruction) {
            ListRangeConstruction lrc = (ListRangeConstruction)exp;
            this.serializeExpression(lrc.get_firstValue(), false);
            this.sb.append("..");
            this.serializeExpression(lrc.get_lastValue(), false);
        } else {
            boolean first = true;
            for (Expression val : exp.get_part()) {
                if (first) {
                    first = false;
                } else {
                    this.sb.append(", ");
                }
                this.serializeExpression(val, false);
            }
        }
        this.sb.append(")");
    }

    private void serializeSubgraphRestrictedExpression(SubgraphRestrictedExpression exp) {
        this.sb.append("on ");
        IsSubgraphDefinitionOf isSubgraphDefOf = exp.getFirstIsSubgraphDefinitionOfIncidence(EdgeDirection.IN);
        this.serializeSubgraphDefinition((SubgraphDefinition)isSubgraphDefOf.getThat());
        this.sb.append(": ");
        IsExpressionOnSubgraph isExprOnSubgraph = exp.getFirstIsExpressionOnSubgraphIncidence(EdgeDirection.IN);
        this.serializeExpression((Expression)isExprOnSubgraph.getThat(), true);
    }

    private void serializeSubgraphDefinition(SubgraphDefinition def) {
        if (def instanceof EdgeTypeSubgraph || def instanceof VertexTypeSubgraph) {
            if (def instanceof EdgeTypeSubgraph) {
                this.sb.append("e");
            } else {
                this.sb.append("v");
            }
            this.sb.append("Subgraph{");
            boolean first = true;
            for (TypeId t : def.get_typeRestr()) {
                if (first) {
                    first = false;
                } else {
                    this.sb.append(", ");
                }
                this.serializeIdentifier(t);
            }
            this.sb.append('}');
        } else {
            IsSubgraphDefiningExpression isDefExpr = ((ExpressionDefinedSubgraph)def).getFirstIsSubgraphDefiningExpressionIncidence(EdgeDirection.IN);
            this.serializeExpression(isDefExpr.getAlpha(), true);
        }
    }

    private void serializePathExpression(PathExpression exp) {
        if (exp instanceof BackwardVertexSet) {
            this.serializeBackwardVertexSet((BackwardVertexSet)exp);
        } else if (exp instanceof ForwardVertexSet) {
            this.serializeForwardVertexSet((ForwardVertexSet)exp);
        } else if (exp instanceof PathExistence) {
            this.serializePathExistence((PathExistence)exp);
        } else {
            throw new GreqlException("Unknown PathExpression " + exp + ".");
        }
    }

    private void serializePathExistence(PathExistence exp) {
        this.serializeExpression(exp.get_startExpr(), true);
        this.serializeExpression(exp.get_path(), true);
        this.serializeExpression(exp.get_targetExpr(), false);
    }

    private void serializeForwardVertexSet(ForwardVertexSet exp) {
        this.serializeExpression(exp.get_startExpr(), true);
        this.serializeExpression(exp.get_path(), false);
    }

    private void serializeBackwardVertexSet(BackwardVertexSet exp) {
        this.serializeExpression(exp.get_path(), true);
        this.serializeExpression(exp.get_targetExpr(), false);
    }

    private void serializePathDescription(PathDescription exp) {
        if (!(exp instanceof PrimaryPathDescription) && !(exp instanceof OptionalPathDescription)) {
            this.sb.append('(');
        }
        boolean hasStartRestr = false;
        for (Expression e : exp.get_startRestr()) {
            if (!hasStartRestr) {
                this.sb.append(" {");
            }
            if (!(e instanceof TypeId)) {
                if (hasStartRestr) {
                    this.sb.append(" ");
                }
                this.sb.append("@ ");
            } else if (hasStartRestr) {
                this.sb.append(", ");
            }
            this.serializeExpression(e, false);
            hasStartRestr = true;
        }
        if (hasStartRestr) {
            this.sb.append("} & ");
        }
        if (exp instanceof AlternativePathDescription) {
            this.serializeAlternativePathDescription((AlternativePathDescription)exp);
        } else if (exp instanceof ExponentiatedPathDescription) {
            this.serializeExponentiatedPathDescription((ExponentiatedPathDescription)exp);
        } else if (exp instanceof IntermediateVertexPathDescription) {
            this.serializeIntermediateVertexPathDescription((IntermediateVertexPathDescription)exp);
        } else if (exp instanceof IteratedPathDescription) {
            this.serializeIteratedPathDescription((IteratedPathDescription)exp);
        } else if (exp instanceof OptionalPathDescription) {
            this.serializeOptionalPathDescription((OptionalPathDescription)exp);
        } else if (exp instanceof SequentialPathDescription) {
            this.serializeSequentialPathDescription((SequentialPathDescription)exp);
        } else if (exp instanceof TransposedPathDescription) {
            this.serializeTransposedPathDescription((TransposedPathDescription)exp);
        } else if (exp instanceof PrimaryPathDescription) {
            this.serializePrimaryPathDescription((PrimaryPathDescription)exp);
        } else {
            throw new GreqlException("Unknown PathDescription " + exp + ".");
        }
        boolean hasGoalRestr = false;
        for (Expression e : exp.get_goalRestr()) {
            if (!hasGoalRestr) {
                this.sb.append(" & {");
            }
            if (!(e instanceof TypeId)) {
                if (hasGoalRestr) {
                    this.sb.append(" ");
                }
                this.sb.append("@ ");
            } else if (hasGoalRestr) {
                this.sb.append(", ");
            }
            this.serializeExpression(e, false);
            hasGoalRestr = true;
        }
        if (hasGoalRestr) {
            this.sb.append("}");
        }
        if (!(exp instanceof PrimaryPathDescription) && !(exp instanceof OptionalPathDescription)) {
            this.sb.append(')');
        }
    }

    private void serializePrimaryPathDescription(PrimaryPathDescription exp) {
        if (exp instanceof EdgePathDescription) {
            this.serializeEdgePathDescription((EdgePathDescription)exp);
        } else if (exp instanceof SimplePathDescription) {
            this.serializeSimplePathDescription((SimplePathDescription)exp);
        } else if (exp instanceof AggregationPathDescription) {
            this.serializeAggregationPathDescription((AggregationPathDescription)exp);
        } else {
            throw new GreqlException("Unknown PrimaryPathDescription " + exp + ".");
        }
        if (exp.get_edgeRestr().iterator().hasNext()) {
            this.sb.append("{");
            boolean first = true;
            for (EdgeRestriction er : exp.get_edgeRestr()) {
                if (first) {
                    first = false;
                } else {
                    this.sb.append(", ");
                }
                this.serializeEdgeRestriction(er);
            }
            this.sb.append("}");
        }
    }

    private void serializeAggregationPathDescription(AggregationPathDescription exp) {
        if (exp.is_outAggregation()) {
            this.sb.append("<>--");
        } else {
            this.sb.append("--<>");
        }
    }

    private void serializeSimplePathDescription(SimplePathDescription exp) {
        GReQLDirection dir = exp.get_direction().get_dirValue();
        switch (dir) {
            case OUT: {
                this.sb.append("-->");
                break;
            }
            case IN: {
                this.sb.append("<--");
                break;
            }
            default: {
                this.sb.append("<->");
            }
        }
    }

    private void serializeEdgePathDescription(EdgePathDescription exp) {
        GReQLDirection dir = exp.get_direction().get_dirValue();
        switch (dir) {
            case OUT: {
                this.sb.append("--");
                this.serializeExpression(exp.get_edgeExpr(), false);
                this.sb.append("->");
                break;
            }
            case IN: {
                this.sb.append("<-");
                this.serializeExpression(exp.get_edgeExpr(), false);
                this.sb.append("--");
                break;
            }
            default: {
                this.sb.append("<-");
                this.serializeExpression(exp.get_edgeExpr(), false);
                this.sb.append("->");
            }
        }
    }

    private void serializeTransposedPathDescription(TransposedPathDescription exp) {
        this.serializePathDescription(exp.get_transposedPath());
        this.sb.append("^T");
    }

    private void serializeSequentialPathDescription(SequentialPathDescription exp) {
        for (PathDescription pd : exp.get_sequenceElement()) {
            this.serializePathDescription(pd);
            this.sb.append(' ');
        }
    }

    private void serializeOptionalPathDescription(OptionalPathDescription exp) {
        this.sb.append('[');
        this.serializePathDescription(exp.get_optionalPath());
        this.sb.append(']');
    }

    private void serializeIteratedPathDescription(IteratedPathDescription exp) {
        this.serializePathDescription(exp.get_iteratedPath());
        this.sb.append(exp.get_times() == IterationType.STAR ? (char)'*' : '+');
    }

    private void serializeIntermediateVertexPathDescription(IntermediateVertexPathDescription exp) {
        Iterator sub = exp.get_subPath().iterator();
        this.serializePathDescription((PathDescription)sub.next());
        this.serializeExpression(exp.get_intermediateVertex(), false);
        this.serializePathDescription((PathDescription)sub.next());
    }

    private void serializeExponentiatedPathDescription(ExponentiatedPathDescription exp) {
        this.serializePathDescription(exp.get_exponentiatedPath());
        this.sb.append('^');
        this.serializeLiteral(exp.get_exponent());
    }

    private void serializeAlternativePathDescription(AlternativePathDescription exp) {
        boolean first = true;
        for (PathDescription a : exp.get_alternatePath()) {
            if (first) {
                first = false;
            } else {
                this.sb.append(" | ");
            }
            this.serializePathDescription(a);
        }
    }

    private void serializeElementSetExpression(ElementSetExpression exp) {
        if (exp instanceof VertexSetExpression) {
            this.sb.append("V");
        } else if (exp instanceof EdgeSetExpression) {
            this.sb.append("E");
        } else {
            throw new GreqlException("Unknown ElementSetExpression " + exp + ".");
        }
        Iterable typeRestrictions = exp.get_typeRestr();
        if (!typeRestrictions.iterator().hasNext()) {
            return;
        }
        this.sb.append("{");
        String sep = "";
        for (TypeId t : typeRestrictions) {
            this.sb.append(sep);
            sep = ", ";
            this.serializeIdentifier(t);
        }
        this.sb.append("}");
    }

    private void serializeDefinitionExpression(DefinitionExpression exp) {
        if (exp instanceof LetExpression) {
            this.serializeLetExpression((LetExpression)exp);
        } else if (exp instanceof WhereExpression) {
            this.serializeWhereExpression((WhereExpression)exp);
        } else {
            throw new GreqlException("Unknown DefinitionExpression " + exp + ".");
        }
    }

    private void serializeWhereExpression(WhereExpression exp) {
        this.serializeExpression(exp.get_boundExprOfDefinition(), true);
        this.sb.append("where ");
        boolean first = true;
        for (Definition def : exp.get_definition()) {
            if (first) {
                first = false;
            } else {
                this.sb.append(", ");
            }
            this.serializeDefinition(def);
        }
    }

    private void serializeLetExpression(LetExpression exp) {
        this.sb.append("let ");
        boolean first = true;
        for (Definition def : exp.get_definition()) {
            if (first) {
                first = false;
            } else {
                this.sb.append(", ");
            }
            this.serializeDefinition(def);
        }
        this.sb.append(" in ");
        this.serializeExpression(exp.get_boundExprOfDefinition(), true);
    }

    private void serializeComprehension(Comprehension exp) {
        this.sb.append("from ");
        this.serializeDeclaration(exp.get_compDecl(), true);
        if (exp instanceof SetComprehension) {
            this.sb.append(" reportSet");
        } else if (exp instanceof ListComprehension) {
            this.sb.append(" report");
        } else {
            if (exp instanceof MapComprehension) {
                this.sb.append(" reportMap");
                this.serializeLimitedComprehension(exp);
                MapComprehension mc = (MapComprehension)exp;
                this.serializeExpression(mc.get_keyExpr(), false);
                this.sb.append(", ");
                this.serializeExpression(mc.get_valueExpr(), true);
                this.sb.append("end");
                return;
            }
            throw new GreqlException("Unknown Comprehension " + exp + ".");
        }
        this.serializeLimitedComprehension(exp);
        Expression result = exp.get_compResultDef();
        IsTableHeaderOf isTableHeaderOf = exp.getFirstIsTableHeaderOfIncidence(EdgeDirection.IN);
        if (result instanceof TupleConstruction) {
            boolean first = true;
            for (Expression val : ((TupleConstruction)result).get_part()) {
                if (first) {
                    first = false;
                } else {
                    this.sb.append(", ");
                }
                this.serializeExpression(val, false);
                if (isTableHeaderOf == null) continue;
                this.sb.append(" as ");
                this.serializeExpression(isTableHeaderOf.getAlpha(), false);
                isTableHeaderOf = isTableHeaderOf.getNextIsTableHeaderOfIncidence(EdgeDirection.IN);
            }
            this.sb.append(' ');
        } else {
            this.serializeExpression(result, true);
            if (isTableHeaderOf != null) {
                this.sb.append(" as ");
                this.serializeExpression(isTableHeaderOf.getAlpha(), false);
                this.sb.append(" ");
            }
        }
        this.sb.append("end");
    }

    private void serializeLimitedComprehension(Comprehension exp) {
        Expression maxCount = exp.get_maxCount();
        if (maxCount != null) {
            this.sb.append("N ");
            this.serializeExpression(maxCount, false);
            this.sb.append(":");
        }
        this.sb.append(" ");
    }

    private void serializeQuantifiedExpression(QuantifiedExpression exp) {
        this.sb.append('(');
        this.serializeQuantifier(exp.get_quantifier());
        this.sb.append(' ');
        this.serializeDeclaration(exp.get_quantifiedDecl(), false);
        this.sb.append(" @ ");
        this.serializeExpression(exp.get_boundExprOfQuantifier(), false);
        this.sb.append(')');
    }

    private void serializeLiteral(Literal exp) {
        if (exp instanceof BoolLiteral) {
            this.sb.append(((BoolLiteral)exp).is_boolValue());
        } else if (exp instanceof IntLiteral) {
            this.sb.append(((IntLiteral)exp).get_intValue());
        } else if (exp instanceof LongLiteral) {
            this.sb.append(((LongLiteral)exp).get_longValue());
        } else if (exp instanceof UndefinedLiteral) {
            this.sb.append("undefined");
        } else if (exp instanceof DoubleLiteral) {
            this.sb.append(((DoubleLiteral)exp).get_doubleValue());
        } else if (exp instanceof StringLiteral) {
            this.sb.append(GraphIO.toUtfString(((StringLiteral)exp).get_stringValue()));
        } else if (exp instanceof ThisEdge) {
            this.sb.append("thisEdge");
        } else if (exp instanceof ThisVertex) {
            this.sb.append("thisVertex");
        } else {
            throw new GreqlException("Unknown Literal " + exp + ".");
        }
    }

    private void serializeIdentifier(Identifier exp) {
        if (exp instanceof TypeId) {
            TypeId ti = (TypeId)exp;
            if (ti.is_excluded()) {
                this.sb.append("^");
            }
            this.sb.append(ti.get_name());
            if (ti.is_type()) {
                this.sb.append("!");
            }
        } else {
            this.sb.append(exp.get_name());
        }
    }

    private void serializeFunctionApplication(FunctionApplication exp) {
        FunctionId fid = exp.get_functionId();
        String id = fid.get_name();
        if (id.equals("add")) {
            this.serializeFunctionApplicationInfix(exp, "+");
            return;
        }
        if (id.equals("sub")) {
            this.serializeFunctionApplicationInfix(exp, "-");
            return;
        }
        if (id.equals("mul")) {
            this.serializeFunctionApplicationInfix(exp, "*");
            return;
        }
        if (id.equals("div")) {
            this.serializeFunctionApplicationInfix(exp, "/");
            return;
        }
        if (id.equals("equals")) {
            this.serializeFunctionApplicationInfix(exp, "=");
            return;
        }
        if (id.equals("nequals")) {
            this.serializeFunctionApplicationInfix(exp, "<>");
            return;
        }
        if (id.equals("grEqual")) {
            this.serializeFunctionApplicationInfix(exp, ">=");
            return;
        }
        if (id.equals("grThan")) {
            this.serializeFunctionApplicationInfix(exp, ">");
            return;
        }
        if (id.equals("leEqual")) {
            this.serializeFunctionApplicationInfix(exp, "<=");
            return;
        }
        if (id.equals("leThan")) {
            this.serializeFunctionApplicationInfix(exp, "<");
            return;
        }
        if (id.equals("reMatch")) {
            this.serializeFunctionApplicationInfix(exp, "=~");
            return;
        }
        if (id.equals("mod")) {
            this.serializeFunctionApplicationInfix(exp, "%");
            return;
        }
        if (id.equals("and")) {
            this.serializeFunctionApplicationInfix(exp, "and");
            return;
        }
        if (id.equals("or")) {
            this.serializeFunctionApplicationInfix(exp, "or");
            return;
        }
        if (id.equals("xor")) {
            this.serializeFunctionApplicationInfix(exp, "xor");
            return;
        }
        if (id.equals("concat")) {
            this.serializeFunctionApplicationInfix(exp, "++");
            return;
        }
        if (id.equals("getValue")) {
            this.serializeFunctionApplicationInfix(exp, ".");
            return;
        }
        this.serializeIdentifier(fid);
        String delim = "{";
        for (IsTypeExprOfFunction iteof : exp.getIsTypeExprOfFunctionIncidences(EdgeDirection.IN)) {
            Expression arg = (Expression)iteof.getThat();
            this.sb.append(delim);
            delim = ", ";
            this.serializeExpression(arg, false);
        }
        if (!delim.equals("{")) {
            this.sb.append("}");
        }
        this.sb.append('(');
        boolean first = true;
        for (Expression arg : exp.get_argument()) {
            if (first) {
                first = false;
            } else {
                this.sb.append(", ");
            }
            this.serializeExpression(arg, false);
        }
        this.sb.append(")");
    }

    private void serializeFunctionApplicationInfix(FunctionApplication exp, String operator) {
        this.sb.append("(");
        boolean first = true;
        for (Expression arg : exp.get_argument()) {
            if (first) {
                first = false;
            } else if (operator.equals(".")) {
                this.sb.append(operator);
            } else {
                this.sb.append(' ').append(operator).append(' ');
            }
            this.serializeExpression(arg, false);
        }
        this.sb.append(")");
    }

    private void serializeConditionalExpression(ConditionalExpression expression) {
        this.serializeExpression(expression.get_condition(), true);
        this.sb.append("? ");
        this.serializeExpression(expression.get_trueExpr(), true);
        this.sb.append(": ");
        this.serializeExpression(expression.get_falseExpr(), true);
    }

    private void serializeVariable(Variable v) {
        this.sb.append(v.get_name());
    }
}

