/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.serialising;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.Record;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.exception.SerialisingException;
import de.uni_koblenz.jgralab.greql.serialising.DefaultWriter;
import de.uni_koblenz.jgralab.greql.types.Path;
import de.uni_koblenz.jgralab.greql.types.PathSystem;
import de.uni_koblenz.jgralab.greql.types.Table;
import de.uni_koblenz.jgralab.greql.types.Tuple;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Map;
import org.pcollections.ArrayPMap;
import org.pcollections.PCollection;
import org.pcollections.PMap;
import org.pcollections.POrderedSet;
import org.pcollections.PSet;
import org.pcollections.PVector;

public class HTMLOutputWriter
extends DefaultWriter {
    private boolean createElementLinks = false;
    private boolean useCss = true;
    private PrintWriter out;

    public HTMLOutputWriter() {
        this(null);
    }

    public HTMLOutputWriter(Graph g) {
        super(g);
    }

    public void writeValue(Object value, File file) throws IOException, SerialisingException {
        this.out = null;
        try {
            this.out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8")));
            this.writeValue(value);
        }
        catch (SerialisingException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerialisingException("Unhandled Exception", this.rootValue, e);
        }
        finally {
            if (this.out != null) {
                this.out.close();
                this.out = null;
            }
        }
    }

    public boolean isCreateElementLinks() {
        return this.createElementLinks;
    }

    public void setCreateElementLinks(boolean createElementLinks) {
        this.createElementLinks = createElementLinks;
    }

    public boolean isUseCss() {
        return this.useCss;
    }

    public void setUseCss(boolean useCss) {
        this.useCss = useCss;
    }

    @Override
    protected void write(Object o) throws IOException {
        try {
            super.write(o);
        }
        catch (IOException e) {
            throw e;
        }
        catch (SerialisingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected Exception", e);
        }
    }

    @Override
    protected void writePathSystem(PathSystem p) throws Exception {
        this.writeDefaultObject(p);
    }

    private String htmlQuote(String string) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                result.append("&lt;");
                continue;
            }
            if (c == '>') {
                result.append("&gt;");
                continue;
            }
            if (c == '\"') {
                result.append("&quot;");
                continue;
            }
            if (c == '\'') {
                result.append("&apos;");
                continue;
            }
            if (c == '&') {
                result.append("&amp;");
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    @Override
    protected void pre() throws IOException {
        this.out.println(this.table(1, 2) + "<tr><td>");
    }

    @Override
    protected void post() throws IOException {
        this.out.println("</td></tr></table>");
    }

    @Override
    protected void inter() throws IOException {
        this.out.println("</td></tr><tr><td>");
    }

    @Override
    protected void writeTuple(Tuple t) throws IOException {
        this.out.println(this.table(1, 2) + "<tr><td>");
        boolean first = true;
        for (Object val : t) {
            if (first) {
                first = false;
            } else {
                this.out.println("</td><td>");
            }
            this.write(val);
        }
        this.out.println("</td></tr></table>");
    }

    @Override
    protected void writeRecord(Record r) throws IOException {
        this.out.println(this.table(1, 2) + "<tr><td>");
        boolean first = true;
        for (String compName : r.getComponentNames()) {
            if (first) {
                first = false;
            } else {
                this.out.println("</td><td>");
            }
            this.out.println(compName + ": ");
            this.write(r.getComponent(compName));
        }
        this.out.println("</td></tr></table>");
    }

    @Override
    protected void writeTable(Table<?> table) throws IOException {
        this.out.print(this.table(1, 2) + "<tr><th>");
        boolean first = true;
        for (Object e : table.getTitles()) {
            if (first) {
                first = false;
            } else {
                this.out.print("</th><th>");
            }
            this.write(e);
        }
        this.out.println("</th></tr>");
        for (Object object : table) {
            this.out.println("<tr><td>");
            if (object instanceof Tuple) {
                first = true;
                for (Object val : (Tuple)object) {
                    if (first) {
                        first = false;
                    } else {
                        this.out.println("</td><td>");
                    }
                    this.write(val);
                }
            } else {
                this.write(object);
            }
            this.out.println("</td></tr>");
        }
        this.out.println("</table>");
    }

    @Override
    protected void writePath(Path p) throws IOException {
        boolean first = true;
        this.pre();
        PVector<Edge> edges = p.getEdgeTrace();
        PVector<Vertex> vertices = p.getVertexTrace();
        for (int i = 0; i < vertices.size() - 1; ++i) {
            if (first) {
                first = false;
                this.write(vertices.get(i));
            }
            this.inter();
            this.write(edges.get(i));
            this.inter();
            this.write(vertices.get(i + 1));
        }
        this.post();
    }

    @Override
    protected void writeVertex(Vertex vertex) throws IOException {
        if (this.createElementLinks) {
            this.out.println("<a href=\"v" + vertex.getId() + "\">v" + vertex.getId() + ": " + vertex.getAttributedElementClass().getUniqueName() + "</a>");
        } else {
            this.out.println("v" + vertex.getId() + ": " + vertex.getAttributedElementClass().getUniqueName());
        }
    }

    @Override
    protected void writeEdge(Edge edge) throws IOException {
        if (this.createElementLinks) {
            this.out.println("<a href=\"e" + edge.getId() + "\">e" + edge.getId() + ": " + edge.getAttributedElementClass().getUniqueName() + "</a>");
        } else {
            this.out.println("e" + edge.getId() + ": " + edge.getAttributedElementClass().getUniqueName());
        }
    }

    @Override
    protected void writeInteger(Integer b) throws IOException {
        this.out.println(b.toString());
    }

    @Override
    protected void writeLong(Long b) throws IOException {
        this.out.println(b.toString());
    }

    @Override
    protected void writeDouble(Double b) throws IOException {
        this.out.println(b.toString());
    }

    @Override
    protected void writeString(String b) throws IOException {
        this.out.println(this.htmlQuote(b));
    }

    @Override
    protected void writeEnum(Enum<?> e) throws IOException {
        String b = e.toString();
        this.out.println(b);
    }

    @Override
    protected void writeGraph(Graph gr) throws IOException {
        if (this.createElementLinks) {
            this.out.println("<a href=\"g" + gr.getId() + "\">" + gr.getId() + ": " + gr.getAttributedElementClass().getUniqueName() + "</a>");
        } else {
            this.out.println(gr.getId() + ": " + gr.getAttributedElementClass().getUniqueName());
        }
    }

    @Override
    protected void writeBoolean(Boolean v) throws IOException {
        if (v != null) {
            this.out.println(v.toString());
        } else {
            this.out.println("null");
        }
    }

    @Override
    protected void writeDefaultObject(Object o) throws IOException {
        this.out.println("<pre>");
        this.out.println(this.htmlQuote(o.toString()));
        this.out.println("</pre>");
    }

    @Override
    protected void writeAttributedElementClass(AttributedElementClass<?, ?> c) throws IOException {
        this.out.println(c.getQualifiedName());
    }

    @Override
    protected void writePVector(PVector<?> b) throws Exception {
        if (b.size() > 0 && b.get(0) instanceof Tuple) {
            this.writeTableOfTuples(b);
        } else {
            super.writePVector(b);
        }
    }

    private void writeTableOfTuples(PCollection<?> c) throws IOException {
        this.out.print(this.table(1, 2));
        boolean first = true;
        for (Object o : c) {
            this.out.println("<tr><td>");
            if (o instanceof Tuple) {
                first = true;
                for (Object val : (Tuple)o) {
                    if (first) {
                        first = false;
                    } else {
                        this.out.println("</td><td>");
                    }
                    this.write(val);
                }
            } else {
                this.write(o);
            }
            this.out.println("</td></tr>");
        }
        this.out.println("</table>");
    }

    @Override
    protected void writePSet(PSet<?> s) throws Exception {
        if (s.size() > 0 && s instanceof POrderedSet && ((POrderedSet)s).get(0) instanceof Tuple) {
            this.writeTableOfTuples(s);
            return;
        }
        super.writePSet(s);
    }

    @Override
    protected void writePMap(PMap<?, ?> b) throws Exception {
        this.out.print(this.table(1, 2));
        if (b instanceof ArrayPMap) {
            ArrayPMap m = (ArrayPMap)b;
            for (Map.Entry e : m) {
                this.out.print("<tr><td>");
                this.write(e.getKey());
                this.out.print("</td><td>");
                this.write(e.getValue());
                this.out.print("</td></tr>");
            }
        } else {
            for (Map.Entry e : b.entrySet()) {
                this.out.print("<tr><td>");
                this.write(e.getKey());
                this.out.print("</td><td>");
                this.write(e.getValue());
                this.out.print("</td></tr>");
            }
        }
        this.out.print("</table>");
    }

    @Override
    protected void head() throws IOException {
        this.out.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        this.out.println("<html>");
        this.out.println("<head>");
        this.out.println("<meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\">");
        if (this.useCss) {
            this.out.println("<style type=\"text/css\">");
            this.out.println("table { border: thin gray solid; border-collapse: collapse; border-spacing: 2px }");
            this.out.println("td { border: thin gray solid; border-collapse: collapse; border-spacing: 2px }");
            this.out.println("th { border: thin gray solid; border-collapse: collapse; border-spacing: 2px }");
            this.out.println("</style>\n");
        }
        this.out.println("</head><body>");
        if (this.getGraph() != null) {
            this.out.print("<p>Graph id: " + this.getGraph().getId() + "</p>");
        }
        this.out.print("<p>Result size: ");
        if (this.rootValue instanceof PCollection) {
            this.out.println(Integer.toString(((PCollection)this.rootValue).size()));
        } else {
            this.out.println("1");
        }
        this.out.println("</p><hr/>");
    }

    private String table(int border, int padding) {
        return this.table(border, padding, 0);
    }

    private String table(int border, int padding, int spacing) {
        return "<table border=\"" + border + "\" cellpadding=\"" + padding + "\" cellspacing=\"" + spacing + "\">";
    }

    @Override
    protected void writeUndefined() throws Exception {
        this.out.print("&not;");
    }

    @Override
    protected void foot() throws IOException {
        this.out.println("</body></html>");
    }
}

