/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.types;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.EdgeDirection;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Vertex;
import java.util.HashSet;
import org.pcollections.PVector;

public class Path {
    private final PVector<Vertex> vertices;
    private final PVector<Edge> edges;

    private Path(PVector<Vertex> vs, PVector<Edge> es) {
        this.vertices = vs;
        this.edges = es;
    }

    public static Path start(Vertex v) {
        if (v == null || !v.isValid()) {
            throw new IllegalArgumentException("The vertex must be != null and valid");
        }
        PVector vs = JGraLab.vector();
        PVector<Edge> es = JGraLab.vector();
        return new Path(vs.plus(v), es);
    }

    public Path reverse() {
        int i;
        PVector<Vertex> vs = JGraLab.vector();
        PVector<Edge> es = JGraLab.vector();
        for (i = this.vertices.size() - 1; i >= 0; --i) {
            vs = vs.plus((Vertex)this.vertices.get(i));
        }
        for (i = this.edges.size() - 1; i >= 0; --i) {
            es = es.plus(((Edge)this.edges.get(i)).getReversedEdge());
        }
        return new Path(vs, es);
    }

    public Path append(Edge e) {
        if (e.getThis() != this.getEndVertex()) {
            throw new IllegalArgumentException("Can't append " + e + " to this Path (e.getThis() (" + e.getThis() + ") !=" + this.getEndVertex() + ")");
        }
        return new Path(this.vertices.plus(e.getThat()), this.edges.plus(e));
    }

    public Vertex getStartVertex() {
        return (Vertex)this.vertices.get(0);
    }

    public Vertex getEndVertex() {
        return (Vertex)this.vertices.get(this.vertices.size() - 1);
    }

    public int getLength() {
        return this.edges.size();
    }

    public Vertex getVertexAt(int i) {
        return (Vertex)this.vertices.get(i);
    }

    public Edge getEdgeAt(int i) {
        return (Edge)this.edges.get(i);
    }

    public boolean isTrail() {
        HashSet<Vertex> h = new HashSet<Vertex>();
        h.add(this.getStartVertex());
        for (Edge e : this.edges) {
            if (h.contains(e.getThat())) {
                return false;
            }
            h.add(e.getThat());
        }
        return true;
    }

    public PVector<Edge> getEdgeTrace() {
        return this.edges;
    }

    public PVector<Vertex> getVertexTrace() {
        return this.vertices;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Path)) {
            return false;
        }
        Path p = (Path)o;
        return this.vertices.equals(p.vertices) && this.edges.equals(p.edges);
    }

    public int hashCode() {
        return this.vertices.hashCode() + this.edges.hashCode();
    }

    public int degree(Vertex vertex, EdgeDirection dir) {
        int degree = 0;
        switch (dir) {
            case IN: {
                for (Edge e : this.edges) {
                    if (e.getOmega() != vertex) continue;
                    ++degree;
                }
                return degree;
            }
            case OUT: {
                for (Edge e : this.edges) {
                    if (e.getAlpha() != vertex) continue;
                    ++degree;
                }
                return degree;
            }
            case INOUT: {
                for (Edge e : this.edges) {
                    if (e.getOmega() == vertex) {
                        ++degree;
                        continue;
                    }
                    if (e.getAlpha() != vertex) continue;
                    ++degree;
                }
                return degree;
            }
        }
        throw new RuntimeException("FIXME: Unhandled EdgeDirection " + (Object)((Object)dir));
    }

    public boolean contains(GraphElement<?, ?> el) {
        return el instanceof Vertex ? this.containsVertex((Vertex)el) : this.containsEdge((Edge)el);
    }

    public boolean containsVertex(Vertex v) {
        return this.vertices.contains(v);
    }

    public boolean containsEdge(Edge e) {
        return this.edges.contains(e);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Path: ");
        if (this.vertices.isEmpty()) {
            sb.append("empty");
        } else {
            sb.append(this.vertices.get(0));
            for (Edge e : this.edges) {
                sb.append(" ").append(e).append(" ").append(e.getThat());
            }
        }
        return sb.toString();
    }
}

