/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.greql.types;

import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.types.Path;
import de.uni_koblenz.jgralab.schema.impl.DirectedAcyclicGraph;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.pcollections.PSet;

public class PathSystem {
    private final DirectedAcyclicGraph<PathSystemNode> dag = new DirectedAcyclicGraph();
    private final Map<Vertex, PathSystemNode> vertex2node;
    private PathSystemNode root;
    private boolean finished = false;
    private Set<PathSystemNode> leafNodes = new HashSet<PathSystemNode>();
    private static Logger logger = JGraLab.getLogger(PathSystem.class);

    public Vertex getRootVertex() {
        return this.root.currentVertex;
    }

    public PathSystemNode getRoot() {
        return this.root;
    }

    public int hashCode() {
        this.assertFinished();
        return this.extractPaths().hashCode();
    }

    public boolean equals(Object o) {
        this.assertFinished();
        if (o == null || !(o instanceof PathSystem)) {
            return false;
        }
        return this.extractPaths().equals(((PathSystem)o).extractPaths());
    }

    public PathSystem() {
        this.vertex2node = new HashMap<Vertex, PathSystemNode>();
    }

    public PathSystemNode setRootVertex(Vertex vertex, int stateNumber, boolean finalState) {
        this.assertUnfinished();
        this.root = new PathSystemNode(vertex, null, stateNumber);
        this.dag.createNode(this.root);
        if (finalState) {
            assert (this.root != null);
            this.leafNodes.add(this.root);
        }
        this.vertex2node.put(vertex, this.root);
        return this.root;
    }

    public PathSystemNode addVertex(Vertex vertex, int stateNumber, boolean finalState) {
        this.assertUnfinished();
        PathSystemNode currentNode = new PathSystemNode(vertex, stateNumber);
        this.dag.createNode(currentNode);
        if (finalState) {
            assert (currentNode != null);
            this.leafNodes.add(currentNode);
        }
        if (!this.vertex2node.containsKey(vertex)) {
            this.vertex2node.put(vertex, currentNode);
        }
        return currentNode;
    }

    public void addEdge(PathSystemNode child, PathSystemNode parent, Edge edge2Parent) {
        this.assertUnfinished();
        assert (child.edge2parent == null || child.edge2parent == edge2Parent);
        child.edge2parent = edge2Parent;
        if (!this.dag.getDirectSuccessors(parent).contains(child)) {
            this.dag.createEdge(parent, child);
        }
    }

    public void addLeaf(PathSystemNode newLeaf) {
        this.assertUnfinished();
        assert (newLeaf != null);
        if (!this.leafNodes.contains(newLeaf)) {
            this.leafNodes.add(newLeaf);
        }
    }

    public boolean isLeaf(PathSystemNode leaf) {
        return this.leafNodes.contains(leaf);
    }

    public Set<PathSystemNode> getParents(PathSystemNode pe) {
        return this.dag.getDirectPredecessors(pe);
    }

    public void finish() {
        this.dag.finish();
        this.finished = true;
    }

    public boolean contains(GraphElement<?, ?> elem) {
        this.assertFinished();
        for (PathSystemNode node : this.vertex2node.values()) {
            if (node.edge2parent == elem) {
                return true;
            }
            if (node.currentVertex != elem) continue;
            return true;
        }
        return false;
    }

    public PSet<Vertex> getLeaves() {
        this.assertFinished();
        PSet<Vertex> leaves = JGraLab.set();
        for (PathSystemNode leafNode : this.leafNodes) {
            leaves = leaves.plus(leafNode.currentVertex);
        }
        return leaves;
    }

    public PSet<PathSystemNode> getChildren(PathSystemNode currentNode) {
        this.assertFinished();
        return this.dag.getDirectSuccessors(currentNode);
    }

    public Path extractPath(Vertex vertex) {
        this.assertFinished();
        PathSystemNode currentNode = this.vertex2node.get(vertex);
        if (currentNode == null || this.leafNodes.contains(vertex)) {
            return null;
        }
        return this.extractPath(currentNode);
    }

    private Path extractPath(PathSystemNode currentNode) {
        this.assertFinished();
        Path path = Path.start(currentNode.currentVertex);
        while (currentNode != null) {
            if (currentNode.edge2parent != null) {
                PSet<PathSystemNode> predecessors = this.dag.getDirectPredecessors(currentNode);
                assert (predecessors.size() == 1) : currentNode + " has precessors: " + predecessors;
                path = path.append(currentNode.edge2parent.getReversedEdge());
                currentNode = predecessors.toArray(new PathSystemNode[1])[0];
                continue;
            }
            currentNode = null;
        }
        return path.reverse();
    }

    public PSet<Path> extractPaths() {
        this.assertFinished();
        PSet<Path> pathSet = JGraLab.set();
        for (PathSystemNode leaf : this.leafNodes) {
            pathSet = pathSet.plus(this.extractPath(leaf));
        }
        return pathSet;
    }

    public int getDepth() {
        this.assertFinished();
        int maxdepth = 0;
        HashMap<PathSystemNode, Integer> depth = new HashMap<PathSystemNode, Integer>();
        LinkedList<PathSystemNode> workingQueue = new LinkedList<PathSystemNode>();
        workingQueue.add(this.root);
        depth.put(this.root, 0);
        while (!workingQueue.isEmpty()) {
            PathSystemNode currentNode = (PathSystemNode)workingQueue.poll();
            int currentDepth = (Integer)depth.get(currentNode);
            if (currentDepth > maxdepth) {
                maxdepth = currentDepth;
            }
            for (PathSystemNode child : this.dag.getDirectSuccessors(currentNode)) {
                depth.put(child, currentDepth + 1);
                workingQueue.add(child);
            }
        }
        return maxdepth;
    }

    public int distance(Vertex vertex) {
        this.assertFinished();
        PathSystemNode node = this.vertex2node.get(vertex);
        if (node == null) {
            return -1;
        }
        int distance = 0;
        while (node != null && node.edge2parent != null) {
            PSet<PathSystemNode> parents = this.dag.getDirectPredecessors(node);
            assert (parents.size() == 1);
            node = parents.toArray(new PathSystemNode[1])[0];
            ++distance;
        }
        return distance;
    }

    public void printAscii() {
        this.assertFinished();
        PSet<Path> pathSet = this.extractPaths();
        for (Path path : pathSet) {
            logger.info(path.toString());
        }
    }

    public String toString() {
        StringBuilder returnString = new StringBuilder("PathSystem:\n");
        PSet<Path> pathSet = this.extractPaths();
        for (Path path : pathSet) {
            returnString.append(path.toString());
            returnString.append('\n');
        }
        return returnString.toString();
    }

    private void assertUnfinished() {
        if (this.finished) {
            throw new IllegalStateException("Cannot modify a finished path system");
        }
    }

    private void assertFinished() {
        if (!this.finished) {
            throw new IllegalStateException("Path System needs to be finished before it can be used. Use PathSystem.finish()");
        }
    }

    public PSet<Vertex> getVertices() {
        this.assertFinished();
        PSet returnSet = JGraLab.set();
        return returnSet.plusAll(this.vertex2node.keySet());
    }

    public PSet<Edge> getEdges() {
        this.assertFinished();
        PSet<Edge> resultSet = JGraLab.set();
        for (PathSystemNode node : this.dag.getNodesInTopologicalOrder()) {
            if (node.edge2parent == null) continue;
            resultSet = resultSet.plus(node.edge2parent);
        }
        return resultSet;
    }

    public class PathSystemNode {
        public Vertex currentVertex;
        public Edge edge2parent;
        public int state = -1;

        PathSystemNode(Vertex currentVertex, Edge edge2parent, int state) {
            this.currentVertex = currentVertex;
            this.edge2parent = edge2parent;
            this.state = state;
        }

        PathSystemNode(Vertex currentVertex, int state) {
            this.currentVertex = currentVertex;
            this.state = state;
        }

        public String toString() {
            return "(" + this.currentVertex + ", " + this.state + ") " + this.edge2parent;
        }
    }
}

