/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphIO;
import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.ExecuteTransformation;
import de.uni_koblenz.jgralab.gretl.GReTLException;
import de.uni_koblenz.jgralab.gretl.Transformation;
import de.uni_koblenz.jgralab.gretl.parser.TokenTypes;
import de.uni_koblenz.jgralab.impl.ConsoleProgressFunction;

public class AddSourceGraph
extends Transformation<Graph> {
    private String alias = null;
    private String graphFile = null;

    public AddSourceGraph(Context c, String alias, String graphFileName) {
        super(c);
        this.alias = alias;
        this.graphFile = graphFileName;
    }

    public AddSourceGraph(Context c, String graphFileName) {
        this(c, null, graphFileName);
    }

    public static AddSourceGraph parseAndCreate(ExecuteTransformation et) {
        String alias = null;
        if (et.tryMatchGraphAlias()) {
            alias = et.matchGraphAlias();
        }
        String graphFile = et.match((TokenTypes)TokenTypes.STRING).value;
        return new AddSourceGraph(et.context, alias, graphFile);
    }

    @Override
    protected Graph transform() {
        Graph g;
        if (this.alias != null) {
            if (this.context.getSourceGraph(this.alias) != null) {
                return this.context.getSourceGraph(this.alias);
            }
        } else if (this.context.getSourceGraph() != null) {
            return this.context.getSourceGraph();
        }
        try {
            g = GraphIO.loadGraphFromFile(this.graphFile, new ConsoleProgressFunction());
        }
        catch (Exception e) {
            throw new GReTLException("Something went wrong loading source graph from " + this.graphFile, e);
        }
        if (this.alias == null) {
            this.context.setSourceGraph(g);
        } else {
            this.context.addSourceGraph(this.alias, g);
        }
        return g;
    }
}

