/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.ExecuteTransformation;
import de.uni_koblenz.jgralab.gretl.Transformation;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.VertexClass;

public class AddSuperClass
extends Transformation<GraphElementClass<?, ?>> {
    private GraphElementClass<?, ?> subClass;
    private GraphElementClass<?, ?> superClass;

    public AddSuperClass(Context c, VertexClass subClass, VertexClass superClass) {
        super(c);
        this.subClass = subClass;
        this.superClass = superClass;
    }

    public AddSuperClass(Context c, EdgeClass subClass, EdgeClass superClass) {
        super(c);
        this.subClass = subClass;
        this.superClass = superClass;
    }

    public static AddSuperClass parseAndCreate(ExecuteTransformation et) {
        GraphElementClass<?, ?> subGec = et.matchGraphElementClass();
        if (subGec instanceof VertexClass) {
            VertexClass superVC = et.matchVertexClass();
            return new AddSuperClass(et.context, (VertexClass)subGec, superVC);
        }
        EdgeClass superEC = et.matchEdgeClass();
        return new AddSuperClass(et.context, (EdgeClass)subGec, superEC);
    }

    @Override
    protected GraphElementClass<?, ?> transform() {
        if (this.context.phase != Context.TransformationPhase.SCHEMA) {
            return this.subClass;
        }
        if (this.superClass instanceof VertexClass) {
            ((VertexClass)this.subClass).addSuperClass((VertexClass)this.superClass);
        } else {
            ((EdgeClass)this.subClass).addSuperClass((EdgeClass)this.superClass);
        }
        return this.subClass;
    }
}

