/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.jgralab.gretl.AddSuperClass;
import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.ExecuteTransformation;
import de.uni_koblenz.jgralab.gretl.Transformation;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.VertexClass;

public class AddSuperClasses
extends Transformation<GraphElementClass<?, ?>> {
    private GraphElementClass<?, ?> subClass;
    private GraphElementClass<?, ?>[] superClasses;

    public AddSuperClasses(Context c, VertexClass subClass, VertexClass ... superClasses) {
        super(c);
        this.subClass = subClass;
        this.superClasses = superClasses;
    }

    public AddSuperClasses(Context c, EdgeClass subClass, EdgeClass ... superClasses) {
        super(c);
        this.subClass = subClass;
        this.superClasses = superClasses;
    }

    public static AddSuperClasses parseAndCreate(ExecuteTransformation et) {
        GraphElementClass<?, ?> subGec = et.matchGraphElementClass();
        if (subGec instanceof VertexClass) {
            VertexClass[] superVCs = et.matchVertexClassArray();
            return new AddSuperClasses(et.context, (VertexClass)subGec, superVCs);
        }
        EdgeClass[] superECs = et.matchEdgeClassArray();
        return new AddSuperClasses(et.context, (EdgeClass)subGec, superECs);
    }

    @Override
    protected GraphElementClass<?, ?> transform() {
        for (GraphElementClass<?, ?> superCls : this.superClasses) {
            if (this.subClass instanceof VertexClass) {
                new AddSuperClass(this.context, (VertexClass)this.subClass, (VertexClass)superCls).execute();
                continue;
            }
            new AddSuperClass(this.context, (EdgeClass)this.subClass, (EdgeClass)superCls).execute();
        }
        return this.subClass;
    }
}

