/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.ImplementationType;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.greql.GreqlQuery;
import de.uni_koblenz.jgralab.greql.evaluator.GreqlEnvironmentAdapter;
import de.uni_koblenz.jgralab.greql.funlib.FunLib;
import de.uni_koblenz.jgralab.gretl.GReTLBijectionViolationException;
import de.uni_koblenz.jgralab.gretl.GReTLException;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.Schema;
import de.uni_koblenz.jgralab.schema.exception.SchemaException;
import de.uni_koblenz.jgralab.schema.impl.NamedElementImpl;
import de.uni_koblenz.jgralab.schema.impl.SchemaImpl;
import de.uni_koblenz.jgralab.schema.impl.compilation.SchemaClassManager;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pcollections.Empty;
import org.pcollections.PMap;

public class Context {
    private static Logger logger = JGraLab.getLogger(Context.class);
    public static final String DEFAULT_SOURCE_GRAPH_ALIAS = "default";
    public static final String DEFAULT_TARGET_GRAPH_ALIAS = "target";
    private static final Pattern QUERY_GRAPH_ALIAS_PATTERN = Pattern.compile("\\p{Space}*(#(\\p{Alnum}+)#\\p{Space}*).*", 32);
    private final Map<String, Graph> sourceGraphs = new HashMap<String, Graph>(1);
    private GreqlQuery query = null;
    Schema targetSchema = null;
    Graph targetGraph = null;
    TransformationPhase phase = TransformationPhase.SCHEMA;
    private String targetSchemaName;
    private String targetGraphClassName;
    boolean outermost = true;
    private final Map<AttributedElementClass<?, ?>, PMap<Object, AttributedElement<?, ?>>> imgMap = new HashMap();
    private final Map<AttributedElementClass<?, ?>, PMap<AttributedElement<?, ?>, Object>> archMap = new HashMap();
    private final Map<String, Object> greqlExtraVars = new HashMap<String, Object>();
    private final Set<String> greqlImports = new HashSet<String>();
    private final Random uniqueSeed = new Random();

    public final Schema getTargetSchema() {
        return this.targetSchema;
    }

    public final TransformationPhase getPhase() {
        return this.phase;
    }

    final void setGReQLVariable(String name, Object val) {
        this.greqlExtraVars.put(name, val);
    }

    final void setGReQLVariable(String name, String greqlExpression) {
        this.greqlExtraVars.put(name, this.evaluateGReQLQuery(greqlExpression));
    }

    final void setGReQLHelper(String name, String greqlExpression) {
        if (FunLib.contains(name)) {
            FunLib.removeGreqlQueryFunction(name);
        }
        GreqlQuery query = GreqlQuery.createQuery(greqlExpression);
        query.setName(name);
        FunLib.registerGreqlQueryFunction(query, true, 1L, 1L, 1.0);
    }

    final void addGReQLImport(String qualifiedName) {
        this.greqlImports.add(qualifiedName);
    }

    private final String getGreqlImportString(Graph graph) {
        StringBuilder sb = new StringBuilder();
        for (String s : this.greqlImports) {
            if (s.endsWith(".*") ? graph.getSchema().getPackage(s.replace(".*", "")) == null : graph.getSchema().getAttributedElementClass(s) == null) continue;
            sb.append("import ");
            sb.append(s);
            sb.append("; ");
        }
        return sb.toString();
    }

    public Context(String targetSchemaName, String targetGraphClassName) {
        this.targetSchemaName = targetSchemaName;
        this.targetGraphClassName = targetGraphClassName;
        try {
            Class<?> schemaClass = SchemaClassManager.instance(targetSchemaName).loadClass(targetSchemaName);
            Method schemaInstanceMethod = schemaClass.getMethod("instance", new Class[0]);
            this.targetSchema = (Schema)schemaInstanceMethod.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Context(Schema targetSchema) {
        this.targetSchema = targetSchema;
        this.targetSchemaName = targetSchema.getQualifiedName();
    }

    public Context(Graph g) {
        this.setTargetGraph(g);
        this.setSourceGraph(g);
    }

    public final PMap<AttributedElement<?, ?>, Object> getArch(AttributedElementClass<?, ?> aec) {
        PMap<AttributedElement<?, ?>, Object> result = this.archMap.get(aec);
        if (result == null) {
            result = Empty.orderedMap();
            this.archMap.put(aec, result);
        }
        return result;
    }

    public final PMap<Object, AttributedElement<?, ?>> getImg(AttributedElementClass<?, ?> aec) {
        PMap<Object, AttributedElement<?, ?>> result = this.imgMap.get(aec);
        if (result == null) {
            result = Empty.orderedMap();
            this.imgMap.put(aec, result);
        }
        return result;
    }

    final void ensureMappings(AttributedElementClass<?, ?> aec) {
        this.getImg(aec);
        this.getArch(aec);
    }

    public final void ensureAllMappings() {
        this.ensureMappings(this.targetSchema.getGraphClass());
        for (GraphElementClass<?, ?> gec : this.targetSchema.getGraphClass().getGraphElementClasses()) {
            this.ensureMappings(gec);
        }
    }

    public final void printImgMappings() {
        System.out.println("Image Mappings:");
        for (Map.Entry<AttributedElementClass<?, ?>, PMap<Object, AttributedElement<?, ?>>> e : this.imgMap.entrySet()) {
            AttributedElementClass<?, ?> aec = e.getKey();
            PMap<Object, AttributedElement<?, ?>> img = e.getValue();
            System.out.println("Mappings for: " + aec.getQualifiedName());
            for (Map.Entry entry : img.entrySet()) {
                System.out.println("    " + entry.getKey() + " ==> " + entry.getValue());
            }
        }
    }

    final void addMapping(AttributedElementClass<?, ?> attrElemClass, Object archetype, AttributedElement<?, ?> image) {
        this.addMappingToClass(attrElemClass, archetype, image);
        if (attrElemClass instanceof GraphElementClass) {
            this.addMappingsToSuperClasses((GraphElementClass)attrElemClass, archetype, (GraphElement)image);
        }
    }

    private final void addMappingsToSuperClasses(GraphElementClass<?, ?> subClass, Object archetype, GraphElement<?, ?> image) {
        for (AttributedElementClass superClass : subClass.getAllSuperClasses()) {
            this.addMappingToClass(superClass, archetype, image);
        }
    }

    private final void addMappingToClass(AttributedElementClass<?, ?> attrElemClass, Object archetype, AttributedElement<?, ?> image) {
        this.addArchMapping(attrElemClass, image, archetype);
        this.addImgMapping(attrElemClass, archetype, image);
    }

    private void addArchMapping(AttributedElementClass<?, ?> attrElemClass, AttributedElement<?, ?> image, Object archetype) {
        PMap<AttributedElement<?, ?>, Object> map = this.archMap.get(attrElemClass);
        if (map.containsKey(image)) {
            throw new GReTLBijectionViolationException(this, "'" + image + "' already maps to '" + map.get(image) + "' in " + Context.toGReTLVarNotation(attrElemClass.getQualifiedName(), GReTLVariableType.ARCH) + "! You wanted to create an archMap mapping from '" + image + "' to '" + archetype + "'.");
        }
        this.archMap.remove(map);
        map = map.plus(image, archetype);
        this.archMap.put(attrElemClass, map);
    }

    private void addImgMapping(AttributedElementClass<?, ?> attrElemClass, Object archetype, AttributedElement<?, ?> image) {
        PMap<Object, AttributedElement<?, ?>> map = this.imgMap.get(attrElemClass);
        if (map.containsKey(archetype)) {
            throw new GReTLBijectionViolationException(this, "'" + archetype + "' already maps to '" + map.get(archetype) + "' in " + Context.toGReTLVarNotation(attrElemClass.getQualifiedName(), GReTLVariableType.IMG) + "! You wanted to create an imgMap mapping from '" + archetype + "' to '" + image + "'.");
        }
        this.imgMap.remove(map);
        map = map.plus(archetype, image);
        this.imgMap.put(attrElemClass, map);
    }

    public String getUniqueString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<--[");
        sb.append(this.uniqueSeed.nextInt());
        sb.append("]--[");
        sb.append(System.currentTimeMillis());
        sb.append("]-->");
        return sb.toString();
    }

    public final void validateMappings() {
        if (this.imgMap.size() != this.archMap.size()) {
            Map<AttributedElementClass<?, ?>, PMap<Object, Object>> m = this.imgMap;
            Map<AttributedElementClass<?, ?>, PMap<Object, Object>> o = this.archMap;
            if (this.archMap.size() > this.imgMap.size()) {
                m = this.archMap;
                o = this.imgMap;
            }
            Set<AttributedElementClass<?, ?>> keySet = m.keySet();
            for (AttributedElementClass<?, ?> aec : keySet) {
                if (o.containsKey(aec)) continue;
                System.err.println(Context.toGReTLVarNotation(aec.getQualifiedName(), o == this.archMap ? GReTLVariableType.ARCH : GReTLVariableType.IMG) + " is missing");
            }
            throw new GReTLBijectionViolationException(this, "The imgMap and archMap mappings aren't valid! The sizes of imgMap (" + this.imgMap.size() + ") and archMap (" + this.archMap.size() + ") don't match!");
        }
        for (AttributedElementClass<?, ?> aec : this.archMap.keySet()) {
            if (!this.imgMap.containsKey(aec)) {
                throw new GReTLBijectionViolationException(this, "The imgMap and archMap mappings aren't valid! imgMap contains no mappings for '" + aec.getQualifiedName() + "'!");
            }
            Map arch = this.archMap.get(aec);
            Map img = this.imgMap.get(aec);
            if (arch.size() != img.size()) {
                throw new GReTLBijectionViolationException(this, "The imgMap and archMap mappings aren't valid! The sizes of '" + Context.toGReTLVarNotation(aec.getQualifiedName(), GReTLVariableType.IMG) + "' and '" + Context.toGReTLVarNotation(aec.getQualifiedName(), GReTLVariableType.ARCH) + "' don't match!");
            }
            Set entries = arch.entrySet();
            for (Map.Entry entry : entries) {
                if (!img.containsKey(entry.getValue())) {
                    throw new GReTLBijectionViolationException(this, "The imgMap and archMap mappings aren't valid! imgMap contains no mapping for '" + entry.getValue() + "'!");
                }
                if (img.get(entry.getValue()).equals(entry.getKey())) continue;
                throw new GReTLBijectionViolationException(this, "The imgMap and archMap mappings aren't valid! imgMap is not inverse to archMap for '" + Context.toGReTLVarNotation(aec.getQualifiedName(), GReTLVariableType.ARCH) + "'! " + "archMap: " + entry.getKey() + " --> " + entry.getValue() + ", but imgMap: " + entry.getValue() + " --> " + img.get(entry.getValue()));
            }
        }
    }

    public final Context swap() {
        logger.info("Swapping context...");
        logger.info("Old target schema name: " + this.targetSchema.getQualifiedName());
        this.sourceGraphs.clear();
        Graph oldTargetGraph = this.targetGraph;
        String newSchemaPackagePrefix = this.targetSchema.getPackagePrefix();
        Pattern stepSuffix = Pattern.compile(".*(_v(\\d+))$");
        Matcher matcher = stepSuffix.matcher(newSchemaPackagePrefix);
        int step = 1;
        if (matcher.matches()) {
            String matchGroup = matcher.group(2);
            step = Integer.parseInt(matchGroup);
            newSchemaPackagePrefix = newSchemaPackagePrefix.substring(0, newSchemaPackagePrefix.length() - matcher.group(1).length());
        }
        newSchemaPackagePrefix = newSchemaPackagePrefix + "_v" + ++step;
        this.targetSchemaName = newSchemaPackagePrefix + "." + this.targetSchema.getName();
        logger.info("New target schema name: " + this.targetSchemaName);
        this.setSourceGraph(oldTargetGraph);
        return this.reset(true);
    }

    public final Context reset(boolean forgetTargetSchema) {
        this.outermost = true;
        this.phase = TransformationPhase.SCHEMA;
        this.targetGraph = null;
        if (forgetTargetSchema) {
            this.targetSchema = null;
        }
        this.archMap.clear();
        this.imgMap.clear();
        this.greqlExtraVars.clear();
        this.greqlImports.clear();
        return this;
    }

    public final void setSourceGraph(Graph sourceGraph) {
        this.addSourceGraph(DEFAULT_SOURCE_GRAPH_ALIAS, sourceGraph);
    }

    public final void addSourceGraph(String alias, Graph sourceGraph) {
        if (this.sourceGraphs.containsKey(alias)) {
            throw new GReTLException(this, "There's already a source graph with name '" + alias + "'.");
        }
        if (!alias.matches("\\w+")) {
            throw new GReTLException(this, "Invalid source graph name '" + alias + "'. Must be only word characters.");
        }
        if (alias.equals(DEFAULT_TARGET_GRAPH_ALIAS)) {
            throw new GReTLException(this, "Invalid source graph name '" + alias + "'. That's the default alias for the target graph.");
        }
        if (sourceGraph.getSchema().getQualifiedName().equals(this.targetSchemaName) && this.targetSchema == null) {
            throw new SchemaException("The schema names of source and target have to be different. Currently both are named '" + this.targetSchemaName + "'.");
        }
        this.sourceGraphs.put(alias, sourceGraph);
    }

    public final Map<String, Graph> getSourceGraphs() {
        return this.sourceGraphs;
    }

    public final Graph getSourceGraph() {
        return this.getSourceGraph(DEFAULT_SOURCE_GRAPH_ALIAS);
    }

    public final Graph getSourceGraph(String alias) {
        return this.sourceGraphs.get(alias);
    }

    public final Graph getTargetGraph() {
        return this.targetGraph;
    }

    public final void setTargetGraph(Graph targetGraph) {
        this.targetGraph = targetGraph;
        this.targetSchema = targetGraph.getSchema();
    }

    final void createTargetSchema() {
        String[] qn = SchemaImpl.splitQualifiedName(this.targetSchemaName);
        this.targetSchema = new SchemaImpl(qn[1], qn[0]);
        GraphClass gc = this.targetSchema.createGraphClass(this.targetGraphClassName);
        this.ensureMappings(gc);
    }

    final void createTargetGraph() {
        this.targetSchema.finish();
        try {
            this.targetSchema.getGraphClass().getSchemaClass();
            logger.info("Schema '" + this.targetSchema.getQualifiedName() + "' is already compiled or in the CLASSPATH...");
            this.targetSchema.finish();
            this.targetGraph = this.targetSchema.createGraph(ImplementationType.STANDARD);
        }
        catch (Exception e) {
            logger.info("Schema '" + this.targetSchema.getQualifiedName() + "' is new, so instantiating a generic target graph...");
            this.targetGraph = this.targetSchema.createGraph(ImplementationType.GENERIC);
        }
        for (Map.Entry<String, Graph> e : this.sourceGraphs.entrySet()) {
            String sourceGraphName = e.getKey();
            Graph sourceGraph = e.getValue();
            if (!sourceGraphName.equals(DEFAULT_SOURCE_GRAPH_ALIAS)) continue;
            this.addMapping(this.targetGraph.getGraphClass(), sourceGraph, this.targetGraph);
        }
    }

    public static String toGReTLVarNotation(String qualifiedName, GReTLVariableType type) {
        String qName = NamedElementImpl.toUniqueNameNotation(qualifiedName);
        return type.toString().toLowerCase() + "_" + qName;
    }

    public final <T> T evaluateGReQLQuery(String greqlExpression) {
        if (this.phase == TransformationPhase.SCHEMA) {
            return null;
        }
        String name = DEFAULT_SOURCE_GRAPH_ALIAS;
        Matcher m = QUERY_GRAPH_ALIAS_PATTERN.matcher(greqlExpression);
        if (m.matches()) {
            greqlExpression = greqlExpression.replace(m.group(1), "");
            name = m.group(2);
            if (name.equals(DEFAULT_TARGET_GRAPH_ALIAS)) {
                return this.evalGReQLQuery(greqlExpression, this.targetGraph);
            }
            if (!this.sourceGraphs.containsKey(name)) {
                throw new GReTLException(this, "No source graph with name '" + name + "'.");
            }
        }
        return this.evalGReQLQuery(greqlExpression, this.sourceGraphs.get(name));
    }

    private final <T> T evalGReQLQuery(String semanticExpression, Graph graph) {
        if (this.phase == TransformationPhase.SCHEMA) {
            return null;
        }
        if (semanticExpression.isEmpty()) {
            logger.severe("The given semantic expression is empty!  Fix that!");
            return null;
        }
        PMap<String, Object> greqlMapping = this.getGreqlVariablesNeededByQuery(semanticExpression);
        StringBuilder sb = new StringBuilder();
        if (this.sourceGraphs.values().contains(graph)) {
            sb.append(this.getGreqlImportString(graph));
        }
        sb.append(this.getGreqlUsingString(greqlMapping));
        sb.append(semanticExpression);
        String query = sb.toString();
        logger.finest("GReQL: " + semanticExpression);
        this.query = GreqlQuery.createQuery(query);
        GreqlEnvironmentAdapter environment = new GreqlEnvironmentAdapter(greqlMapping);
        Object result = this.query.evaluate(graph, environment);
        return (T)result;
    }

    private final PMap<String, Object> getGreqlVariablesNeededByQuery(String query) {
        String varName;
        PMap<Object, Object> result = Empty.orderedMap();
        for (String string : this.greqlExtraVars.keySet()) {
            if (!query.contains(string)) continue;
            result = result.plus(string, this.greqlExtraVars.get(string));
        }
        for (Map.Entry entry : this.archMap.entrySet()) {
            varName = Context.toGReTLVarNotation(((AttributedElementClass)entry.getKey()).getQualifiedName(), GReTLVariableType.ARCH);
            if (!query.contains(varName)) continue;
            result = result.plus(varName, entry.getValue());
        }
        for (Map.Entry entry : this.imgMap.entrySet()) {
            varName = Context.toGReTLVarNotation(((AttributedElementClass)entry.getKey()).getQualifiedName(), GReTLVariableType.IMG);
            if (!query.contains(varName)) continue;
            result = result.plus(varName, entry.getValue());
        }
        return result;
    }

    private final String getGreqlUsingString(Map<String, Object> greqlMapping) {
        if (greqlMapping.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("using ");
        boolean first = true;
        for (String name : new TreeSet<String>(greqlMapping.keySet())) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(name);
        }
        sb.append(": ");
        return sb.toString();
    }

    public final void storeTrace(String fileName) {
    }

    public final void restoreTrace(String fileName) {
    }

    public static enum GReTLVariableType {
        ARCH,
        IMG;

    }

    public static enum TransformationPhase {
        SCHEMA,
        GRAPH;

    }
}

