/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.CreateEnumDomain;
import de.uni_koblenz.jgralab.gretl.CreateListDomain;
import de.uni_koblenz.jgralab.gretl.CreateMapDomain;
import de.uni_koblenz.jgralab.gretl.CreateRecordDomain;
import de.uni_koblenz.jgralab.gretl.CreateSetDomain;
import de.uni_koblenz.jgralab.gretl.ExecuteTransformation;
import de.uni_koblenz.jgralab.gretl.GReTLException;
import de.uni_koblenz.jgralab.gretl.Transformation;
import de.uni_koblenz.jgralab.schema.BooleanDomain;
import de.uni_koblenz.jgralab.schema.Domain;
import de.uni_koblenz.jgralab.schema.DoubleDomain;
import de.uni_koblenz.jgralab.schema.EnumDomain;
import de.uni_koblenz.jgralab.schema.IntegerDomain;
import de.uni_koblenz.jgralab.schema.ListDomain;
import de.uni_koblenz.jgralab.schema.LongDomain;
import de.uni_koblenz.jgralab.schema.MapDomain;
import de.uni_koblenz.jgralab.schema.RecordDomain;
import de.uni_koblenz.jgralab.schema.SetDomain;
import de.uni_koblenz.jgralab.schema.StringDomain;
import java.util.Collection;

public class CopyDomain
extends Transformation<Domain> {
    private Domain sourceDomain;

    public CopyDomain(Context c, Domain sourceDomain) {
        super(c);
        this.sourceDomain = sourceDomain;
    }

    public static CopyDomain parseAndCreate(ExecuteTransformation et) {
        Domain d = et.matchDomain();
        return new CopyDomain(et.context, d);
    }

    @Override
    protected Domain transform() {
        switch (this.context.phase) {
            case SCHEMA: {
                if (this.sourceDomain instanceof BooleanDomain) {
                    return this.getBooleanDomain();
                }
                if (this.sourceDomain instanceof DoubleDomain) {
                    return this.getDoubleDomain();
                }
                if (this.sourceDomain instanceof IntegerDomain) {
                    return this.getIntegerDomain();
                }
                if (this.sourceDomain instanceof LongDomain) {
                    return this.getLongDomain();
                }
                if (this.sourceDomain instanceof StringDomain) {
                    return this.getStringDomain();
                }
                if (this.sourceDomain instanceof ListDomain) {
                    return (Domain)new CreateListDomain(this.context, (Domain)new CopyDomain(this.context, ((ListDomain)this.sourceDomain).getBaseDomain()).execute()).execute();
                }
                if (this.sourceDomain instanceof SetDomain) {
                    return (Domain)new CreateSetDomain(this.context, (Domain)new CopyDomain(this.context, ((SetDomain)this.sourceDomain).getBaseDomain()).execute()).execute();
                }
                if (this.sourceDomain instanceof MapDomain) {
                    MapDomain source = (MapDomain)this.sourceDomain;
                    return (Domain)new CreateMapDomain(this.context, (Domain)new CopyDomain(this.context, source.getKeyDomain()).execute(), (Domain)new CopyDomain(this.context, source.getValueDomain()).execute()).execute();
                }
                if (this.sourceDomain instanceof RecordDomain) {
                    RecordDomain source = (RecordDomain)this.sourceDomain;
                    Collection<RecordDomain.RecordComponent> coll = source.getComponents();
                    RecordDomain.RecordComponent[] comps = new RecordDomain.RecordComponent[coll.size()];
                    int i = 0;
                    for (RecordDomain.RecordComponent curComp : coll) {
                        comps[i] = new RecordDomain.RecordComponent(curComp.getName(), (Domain)new CopyDomain(this.context, curComp.getDomain()).execute());
                        ++i;
                    }
                    return (Domain)new CreateRecordDomain(this.context, source.getQualifiedName(), comps).execute();
                }
                if (this.sourceDomain instanceof EnumDomain) {
                    EnumDomain source = (EnumDomain)this.sourceDomain;
                    new CreateEnumDomain(this.context, source.getQualifiedName(), source.getConsts().toArray(new String[0])).execute();
                } else {
                    throw new GReTLException(this.context, "Unknown Domain '" + this.sourceDomain + "'.");
                }
            }
            case GRAPH: {
                return this.domain(this.sourceDomain.getQualifiedName());
            }
        }
        throw new GReTLException(this.context, "Unknown TransformationPhase " + (Object)((Object)this.context.phase) + "!");
    }
}

