/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.gretl.AddSuperClass;
import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.CopyDomain;
import de.uni_koblenz.jgralab.gretl.CreateAbstractEdgeClass;
import de.uni_koblenz.jgralab.gretl.CreateAbstractVertexClass;
import de.uni_koblenz.jgralab.gretl.CreateAttribute;
import de.uni_koblenz.jgralab.gretl.CreateEdgeClass;
import de.uni_koblenz.jgralab.gretl.CreateVertexClass;
import de.uni_koblenz.jgralab.gretl.GReTLException;
import de.uni_koblenz.jgralab.gretl.Transformation;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import de.uni_koblenz.jgralab.schema.Domain;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.IncidenceClass;
import de.uni_koblenz.jgralab.schema.RecordDomain;
import de.uni_koblenz.jgralab.schema.VertexClass;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class CopyTransformation
extends Transformation<Graph> {
    protected Pattern excludePattern;
    protected Pattern includePattern;
    private final HashSet<String> vcsCreated = new HashSet();
    private final HashSet<String> ecsCreated = new HashSet();
    private final HashSet<String> attrsCreated = new HashSet();
    private static Logger logger = JGraLab.getLogger(CopyTransformation.class);

    public CopyTransformation(Context context, Pattern excludePattern, Pattern includePattern) {
        super(context);
        this.excludePattern = excludePattern;
        this.includePattern = includePattern;
    }

    public CopyTransformation(Context context) {
        this(context, null, null);
    }

    @Override
    protected final Graph transform() {
        this.createVertexClasses();
        this.transformVertexClasses();
        this.createEdgeClasses();
        this.transformEdgeClasses();
        this.createAttributes();
        return this.context.getTargetGraph();
    }

    protected void transformVertexClasses() {
    }

    protected void transformEdgeClasses() {
    }

    @Transformation.After
    protected void clearNameCaches() {
        this.vcsCreated.clear();
        this.ecsCreated.clear();
        this.attrsCreated.clear();
    }

    private void createAttributes() {
        for (Map.Entry<String, Graph> e : this.context.getSourceGraphs().entrySet()) {
            String schemaQName = e.getValue().getSchema().getQualifiedName();
            if (this.context.getPhase() == Context.TransformationPhase.SCHEMA && this.attrsCreated.contains(schemaQName)) continue;
            this.attrsCreated.add(schemaQName);
            GraphClass gc = e.getValue().getSchema().getGraphClass();
            this.createAttributes(gc, e);
            for (GraphElementClass<?, ?> aec : gc.getGraphElementClasses()) {
                if (this.isExcluded(aec.getQualifiedName())) continue;
                this.createAttributes(aec, e);
            }
        }
    }

    private boolean isExcluded(String qName) {
        if (this.excludePattern == null && this.includePattern == null) {
            return false;
        }
        if (this.excludePattern == null) {
            return !this.includePattern.matcher(qName).matches();
        }
        if (this.includePattern == null) {
            return this.excludePattern.matcher(qName).matches();
        }
        return this.excludePattern.matcher(qName).matches() && !this.includePattern.matcher(qName).matches();
    }

    private void createAttributes(AttributedElementClass<?, ?> oldAEC, Map.Entry<String, Graph> e) {
        for (Attribute oldAttr : oldAEC.getOwnAttributeList()) {
            if (this.isExcluded(oldAEC.getQualifiedName() + "." + oldAttr.getName())) {
                logger.finer("Skipping attribute '" + oldAEC.getQualifiedName() + "#" + oldAttr.getName() + "' because it is excluded.");
                continue;
            }
            AttributedElementClass<?, ?> newAec = this.aec(oldAEC.getQualifiedName());
            if (newAec == null) {
                throw new GReTLException(this.context, "Cannot create attribute '" + oldAttr.getName() + "' when copying '" + oldAEC.getQualifiedName() + "'.");
            }
            Domain domain = (Domain)new CopyDomain(this.context, oldAttr.getDomain()).execute();
            String query = null;
            if (oldAEC instanceof GraphClass) {
                query = "#" + e.getKey() + "# map(getGraph() -> " + CopyTransformation.getAttributeReportString("getGraph()", oldAttr.getName(), domain) + ")";
            } else {
                String varName = "x";
                query = "#" + e.getKey() + "# from " + varName + " : keySet(" + Context.toGReTLVarNotation(oldAEC.getQualifiedName(), Context.GReTLVariableType.IMG) + ") reportMap " + varName + " -> " + CopyTransformation.getAttributeReportString(varName, oldAttr.getName(), domain) + " end";
            }
            new CreateAttribute(this.context, new CreateAttribute.AttributeSpec(newAec, oldAttr.getName(), domain, oldAttr.getDefaultValueAsString()), query).execute();
            logger.info("Copied Attribute '" + oldAEC.getQualifiedName() + "#" + oldAttr.getName() + "'.");
        }
    }

    public static String getAttributeReportString(String varName, String attrName, Domain domain) {
        StringBuilder sb = new StringBuilder();
        if (domain instanceof RecordDomain) {
            RecordDomain d = (RecordDomain)domain;
            sb.append("rec(");
            boolean first = true;
            for (RecordDomain.RecordComponent c : d.getComponents()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(c.getName());
                sb.append(" : ");
                sb.append(varName);
                sb.append(".");
                sb.append(c.getName());
            }
            sb.append(")");
        } else {
            sb.append(varName);
            sb.append(".");
            sb.append(attrName);
        }
        return sb.toString();
    }

    private void createEdgeClasses() {
        for (Map.Entry<String, Graph> e : this.context.getSourceGraphs().entrySet()) {
            String schemaQName = e.getValue().getSchema().getQualifiedName();
            if (this.context.getPhase() == Context.TransformationPhase.SCHEMA && this.ecsCreated.contains(schemaQName)) continue;
            this.ecsCreated.add(schemaQName);
            for (EdgeClass oldEC : e.getValue().getGraphClass().getEdgeClasses()) {
                if (this.isExcluded(oldEC.getQualifiedName())) {
                    logger.finer("CopyTransformation: Skipped rule for EdgeClass " + oldEC.getQualifiedName() + ", because it is excluded.");
                    continue;
                }
                IncidenceClass oldFromIC = oldEC.getFrom();
                IncidenceClass oldToIC = oldEC.getTo();
                EdgeClass newEC = null;
                String newECQName = oldEC.getQualifiedName();
                VertexClass newECFrom = this.context.getTargetSchema().getGraphClass().getVertexClass(oldFromIC.getVertexClass().getQualifiedName());
                VertexClass newECTo = this.context.getTargetSchema().getGraphClass().getVertexClass(oldToIC.getVertexClass().getQualifiedName());
                if (newECFrom == null && this.isExcluded(oldFromIC.getVertexClass().getQualifiedName()) || newECTo == null && this.isExcluded(oldToIC.getVertexClass().getQualifiedName())) {
                    logger.finer("Skipping edge class '" + newECQName + "' because its from or to vertex class is excluded.");
                    continue;
                }
                if (newECFrom == null || newECTo == null) {
                    throw new GReTLException(this.context, "Couldn't get from or to vertex class of '" + newECQName + "' although they are not excluded.");
                }
                if (oldEC.isAbstract()) {
                    newEC = (EdgeClass)new CreateAbstractEdgeClass(this.context, newECQName, new CreateEdgeClass.IncidenceClassSpec(newECFrom, oldFromIC), new CreateEdgeClass.IncidenceClassSpec(newECTo, oldToIC)).execute();
                } else {
                    String archetypeTripleQuery = "#" + e.getKey() + "# from e : E{" + oldEC.getQualifiedName() + "!} " + "reportSet e, startVertex(e), endVertex(e) end";
                    newEC = (EdgeClass)new CreateEdgeClass(this.context, newECQName, new CreateEdgeClass.IncidenceClassSpec(newECFrom, oldFromIC), new CreateEdgeClass.IncidenceClassSpec(newECTo, oldToIC), archetypeTripleQuery).execute();
                }
                assert (newEC != null) : "The newly created EdgeClass '" + newECQName + "' is null!";
                for (EdgeClass superEC : oldEC.getDirectSuperClasses()) {
                    if (this.isExcluded(superEC.getQualifiedName())) continue;
                    EdgeClass supEC = superEC;
                    EdgeClass newSuperEC = this.ec(supEC.getQualifiedName());
                    new AddSuperClass(this.context, newEC, newSuperEC).execute();
                }
                logger.info("Copied EdgeClass '" + oldEC.getQualifiedName() + "'.");
            }
        }
    }

    private void createVertexClasses() {
        for (Map.Entry<String, Graph> e : this.context.getSourceGraphs().entrySet()) {
            String schemaQName = e.getValue().getSchema().getQualifiedName();
            if (this.context.getPhase() == Context.TransformationPhase.SCHEMA && this.vcsCreated.contains(schemaQName)) continue;
            this.vcsCreated.add(schemaQName);
            for (VertexClass oldVC : e.getValue().getSchema().getGraphClass().getVertexClasses()) {
                if (this.isExcluded(oldVC.getQualifiedName())) {
                    logger.finer("CopyTransformation: Skipped rule for VertexClass " + oldVC.getQualifiedName() + ", because it is excluded.");
                    continue;
                }
                VertexClass newVC = null;
                newVC = oldVC.isAbstract() ? (VertexClass)new CreateAbstractVertexClass(this.context, oldVC.getQualifiedName()).execute() : (VertexClass)new CreateVertexClass(this.context, oldVC.getQualifiedName(), "#" + e.getKey() + "# V{" + oldVC.getQualifiedName() + "!}").execute();
                for (VertexClass superVC : oldVC.getDirectSuperClasses()) {
                    if (this.isExcluded(superVC.getQualifiedName())) continue;
                    VertexClass superClass = (VertexClass)this.context.getTargetSchema().getAttributedElementClass(superVC.getQualifiedName());
                    new AddSuperClass(this.context, newVC, superClass).execute();
                }
                logger.info("Copied VertexClass '" + oldVC.getQualifiedName() + "'.");
            }
        }
    }
}

