/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.ExecuteTransformation;
import de.uni_koblenz.jgralab.gretl.GReTLException;
import de.uni_koblenz.jgralab.gretl.SetAttributes;
import de.uni_koblenz.jgralab.gretl.Transformation;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import de.uni_koblenz.jgralab.schema.Domain;
import org.pcollections.PMap;

public class CreateAttribute
extends Transformation<Attribute> {
    private AttributeSpec attrSpec;
    private String semanticExpression;
    private PMap<? extends Object, ? extends Object> archetypes2values;

    protected CreateAttribute(Context c, AttributeSpec attrSpec) {
        super(c);
        this.attrSpec = attrSpec;
    }

    public CreateAttribute(Context c, AttributeSpec attrSpec, PMap<? extends Object, ? extends Object> archetypes2values) {
        this(c, attrSpec);
        this.archetypes2values = archetypes2values;
    }

    public CreateAttribute(Context c, AttributeSpec attrSpec, String semanticExpression) {
        this(c, attrSpec);
        this.semanticExpression = semanticExpression;
    }

    public static CreateAttribute parseAndCreate(ExecuteTransformation et) {
        AttributeSpec attrSpec = et.matchAttributeSpec();
        et.matchTransformationArrow();
        String semanticExpression = et.matchSemanticExpression();
        return new CreateAttribute(et.context, attrSpec, semanticExpression);
    }

    @Override
    protected Attribute transform() {
        switch (this.context.phase) {
            case SCHEMA: {
                this.attrSpec.aec.createAttribute(this.attrSpec.name, this.attrSpec.domain, this.attrSpec.defaultValue);
                Attribute attr = this.attrSpec.aec.getAttribute(this.attrSpec.name);
                return attr;
            }
            case GRAPH: {
                Attribute attribute = this.attrSpec.aec.getAttribute(this.attrSpec.name);
                if (this.archetypes2values != null) {
                    new SetAttributes(this.context, attribute, this.archetypes2values).execute();
                } else {
                    new SetAttributes(this.context, attribute, this.semanticExpression).execute();
                }
                return attribute;
            }
        }
        throw new GReTLException(this.context, "Unknown TransformationPhase " + (Object)((Object)this.context.phase) + "!");
    }

    public static final class AttributeSpec {
        protected String name;
        protected AttributedElementClass<?, ?> aec;
        protected Domain domain;
        protected String defaultValue;

        public AttributeSpec(AttributedElementClass<?, ?> attrElemClass, String attrName, Domain domain, String defaultValue) {
            this.name = attrName;
            this.aec = attrElemClass;
            this.domain = domain;
            this.defaultValue = defaultValue;
        }

        public AttributeSpec(AttributedElementClass<?, ?> attrElemClass, String attrName, Domain domain) {
            this(attrElemClass, attrName, domain, null);
        }
    }
}

