/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.jgralab.AttributedElement;
import de.uni_koblenz.jgralab.Edge;
import de.uni_koblenz.jgralab.Vertex;
import de.uni_koblenz.jgralab.greql.types.Tuple;
import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.ExecuteTransformation;
import de.uni_koblenz.jgralab.gretl.GReTLException;
import de.uni_koblenz.jgralab.gretl.Transformation;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.VertexClass;
import org.pcollections.Empty;
import org.pcollections.PSet;

public class CreateEdges
extends Transformation<PSet<? extends Edge>> {
    private PSet<Tuple> archetypes = null;
    private String semanticExpression = null;
    private EdgeClass edgeClass = null;

    public CreateEdges(Context c, EdgeClass edgeClass, String semanticExpression) {
        super(c);
        this.semanticExpression = semanticExpression;
        this.edgeClass = edgeClass;
    }

    public CreateEdges(Context c, EdgeClass edgeClass, PSet<Tuple> archetypes) {
        super(c);
        this.archetypes = archetypes;
        this.edgeClass = edgeClass;
    }

    public static CreateEdges parseAndCreate(ExecuteTransformation et) {
        EdgeClass ec = et.matchEdgeClass();
        et.matchTransformationArrow();
        String semanticExpression = et.matchSemanticExpression();
        return new CreateEdges(et.context, ec, semanticExpression);
    }

    @Override
    protected PSet<? extends Edge> transform() {
        if (this.context.phase != Context.TransformationPhase.GRAPH) {
            return null;
        }
        if (this.archetypes == null) {
            this.archetypes = (PSet)this.context.evaluateGReQLQuery(this.semanticExpression);
        }
        PSet result = Empty.set();
        for (Tuple trip : this.archetypes) {
            Object arch = trip.get(0);
            Object startVertexArch = trip.get(1);
            VertexClass fromVC = this.edgeClass.getFrom().getVertexClass();
            Vertex startVertex = (Vertex)this.context.getImg(fromVC).get(startVertexArch);
            if (startVertex == null) {
                this.context.printImgMappings();
                throw new GReTLException(this.context, "No startVertex for a new '" + this.edgeClass.getQualifiedName() + "' instance! Couldn't fetch image of '" + startVertexArch + "' in " + Context.toGReTLVarNotation(fromVC.getQualifiedName(), Context.GReTLVariableType.IMG) + ".");
            }
            Object endVertexArch = trip.get(2);
            VertexClass toVC = this.edgeClass.getTo().getVertexClass();
            Vertex endVertex = (Vertex)this.context.getImg(toVC).get(endVertexArch);
            if (endVertex == null) {
                this.context.printImgMappings();
                throw new GReTLException(this.context, "No endVertex for a new '" + this.edgeClass.getQualifiedName() + "' instance! Couldn't fetch image of '" + endVertexArch + "' in " + Context.toGReTLVarNotation(toVC.getQualifiedName(), Context.GReTLVariableType.IMG) + ".");
            }
            Object img = this.context.targetGraph.createEdge(this.edgeClass, startVertex, endVertex);
            result = result.plus(img);
            this.context.addMapping(this.edgeClass, arch, (AttributedElement<?, ?>)img);
        }
        return result;
    }
}

