/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.ExecuteTransformation;
import de.uni_koblenz.jgralab.gretl.GReTLException;
import de.uni_koblenz.jgralab.gretl.Transformation;
import de.uni_koblenz.jgralab.schema.Domain;
import de.uni_koblenz.jgralab.schema.MapDomain;

public class CreateMapDomain
extends Transformation<MapDomain> {
    private Domain keyDomain;
    private Domain valueDomain;

    public CreateMapDomain(Context c, Domain keyDomain, Domain valueDomain) {
        super(c);
        this.keyDomain = keyDomain;
        this.valueDomain = valueDomain;
    }

    public static CreateMapDomain parseAndCreate(ExecuteTransformation et) {
        Domain kd = et.matchDomain();
        Domain vd = et.matchDomain();
        return new CreateMapDomain(et.context, kd, vd);
    }

    @Override
    protected MapDomain transform() {
        switch (this.context.phase) {
            case SCHEMA: {
                return this.context.targetSchema.createMapDomain(this.keyDomain, this.valueDomain);
            }
            case GRAPH: {
                return (MapDomain)this.context.targetSchema.getDomain("Map<" + this.keyDomain.getQualifiedName() + "," + this.valueDomain.getQualifiedName() + ">");
            }
        }
        throw new GReTLException(this.context, "Unknown TransformationPhase " + (Object)((Object)this.context.phase) + "!");
    }
}

