/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.jgralab.GraphElement;
import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.ExecuteTransformation;
import de.uni_koblenz.jgralab.gretl.GReTLException;
import de.uni_koblenz.jgralab.gretl.InPlaceTransformation;
import org.pcollections.PSet;

public class Delete
extends InPlaceTransformation {
    private String greqlExp;
    private PSet<GraphElement<?, ?>> elementsToBeDeleted;

    protected Delete(Context context, String semExp) {
        super(context);
        this.greqlExp = semExp;
    }

    protected Delete(Context context, PSet<GraphElement<?, ?>> deletableElements) {
        super(context);
        this.elementsToBeDeleted = deletableElements;
    }

    @Override
    protected Integer transform() {
        if (this.context.getPhase() == Context.TransformationPhase.SCHEMA) {
            throw new GReTLException("Huzza! SCHEMA phase in InPlaceTransformation?!?");
        }
        if (this.elementsToBeDeleted == null) {
            this.elementsToBeDeleted = (PSet)this.context.evaluateGReQLQuery(this.greqlExp);
        }
        int deleteCount = this.deleteElements(this.elementsToBeDeleted);
        this.elementsToBeDeleted = null;
        return deleteCount;
    }

    private int deleteElements(PSet<GraphElement<?, ?>> j) {
        int count = 0;
        for (GraphElement graphElement : j) {
            if (!graphElement.isValid()) continue;
            graphElement.delete();
            ++count;
        }
        return count;
    }

    public static Delete parseAndCreate(ExecuteTransformation et) {
        et.matchTransformationArrow();
        String semExp = et.matchSemanticExpression();
        return new Delete(et.context, semExp);
    }
}

