/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koblenz.jgralab.gretl;

import de.uni_koblenz.jgralab.Graph;
import de.uni_koblenz.jgralab.JGraLab;
import de.uni_koblenz.jgralab.gretl.AddMappings;
import de.uni_koblenz.jgralab.gretl.AddSourceGraph;
import de.uni_koblenz.jgralab.gretl.AddSubClass;
import de.uni_koblenz.jgralab.gretl.AddSubClasses;
import de.uni_koblenz.jgralab.gretl.AddSuperClass;
import de.uni_koblenz.jgralab.gretl.AddSuperClasses;
import de.uni_koblenz.jgralab.gretl.Assert;
import de.uni_koblenz.jgralab.gretl.Call;
import de.uni_koblenz.jgralab.gretl.Context;
import de.uni_koblenz.jgralab.gretl.CopyDomain;
import de.uni_koblenz.jgralab.gretl.CopyEdgeClass;
import de.uni_koblenz.jgralab.gretl.CopyVertexClass;
import de.uni_koblenz.jgralab.gretl.CreateAbstractEdgeClass;
import de.uni_koblenz.jgralab.gretl.CreateAbstractVertexClass;
import de.uni_koblenz.jgralab.gretl.CreateAttribute;
import de.uni_koblenz.jgralab.gretl.CreateAttributes;
import de.uni_koblenz.jgralab.gretl.CreateEdgeClass;
import de.uni_koblenz.jgralab.gretl.CreateEdges;
import de.uni_koblenz.jgralab.gretl.CreateEnumDomain;
import de.uni_koblenz.jgralab.gretl.CreateListDomain;
import de.uni_koblenz.jgralab.gretl.CreateMapDomain;
import de.uni_koblenz.jgralab.gretl.CreateRecordDomain;
import de.uni_koblenz.jgralab.gretl.CreateSetDomain;
import de.uni_koblenz.jgralab.gretl.CreateSubgraph;
import de.uni_koblenz.jgralab.gretl.CreateVertexClass;
import de.uni_koblenz.jgralab.gretl.CreateVertexClassDisjoint;
import de.uni_koblenz.jgralab.gretl.CreateVertices;
import de.uni_koblenz.jgralab.gretl.Delete;
import de.uni_koblenz.jgralab.gretl.GReTLException;
import de.uni_koblenz.jgralab.gretl.Iteratively;
import de.uni_koblenz.jgralab.gretl.MatchReplace;
import de.uni_koblenz.jgralab.gretl.MergeVertices;
import de.uni_koblenz.jgralab.gretl.NTimes;
import de.uni_koblenz.jgralab.gretl.PrintGraph;
import de.uni_koblenz.jgralab.gretl.SetAttributes;
import de.uni_koblenz.jgralab.gretl.SetMultipleAttributes;
import de.uni_koblenz.jgralab.gretl.SysErr;
import de.uni_koblenz.jgralab.gretl.SysOut;
import de.uni_koblenz.jgralab.gretl.Transformation;
import de.uni_koblenz.jgralab.gretl.parser.GReTLLexer;
import de.uni_koblenz.jgralab.gretl.parser.GReTLParsingException;
import de.uni_koblenz.jgralab.gretl.parser.Token;
import de.uni_koblenz.jgralab.gretl.parser.TokenTypes;
import de.uni_koblenz.jgralab.schema.AggregationKind;
import de.uni_koblenz.jgralab.schema.Attribute;
import de.uni_koblenz.jgralab.schema.AttributedElementClass;
import de.uni_koblenz.jgralab.schema.Domain;
import de.uni_koblenz.jgralab.schema.EdgeClass;
import de.uni_koblenz.jgralab.schema.GraphElementClass;
import de.uni_koblenz.jgralab.schema.RecordDomain;
import de.uni_koblenz.jgralab.schema.VertexClass;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

public class ExecuteTransformation
extends Transformation<Graph> {
    static String FACTORY_METHOD_NAME = "parseAndCreate";
    private static final HashMap<String, Method> knownTransformationClasses = new HashMap();
    private static Logger logger = JGraLab.getLogger(ExecuteTransformation.class);
    private final HashMap<String, Transformation<?>> definedTransformations = new HashMap();
    private File file = null;
    private String name = null;
    private final List<Token> tokens;
    private int current;

    public static void registerTransformation(Class<? extends Transformation<?>> tClass) {
        Method createMethod;
        String className = tClass.getSimpleName();
        String createMethodName = FACTORY_METHOD_NAME;
        try {
            createMethod = tClass.getMethod(createMethodName, ExecuteTransformation.class);
        }
        catch (SecurityException e) {
            throw new GReTLException(e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new GReTLException("The transformation class " + className + " has no " + createMethodName + "(ExecuteTransformation) method.", e);
        }
        knownTransformationClasses.put(className, createMethod);
        logger.finer("Registered transformation " + className + ".");
    }

    public ExecuteTransformation(Context c, File file) {
        super(c);
        this.file = file;
        StringBuilder sb = new StringBuilder();
        BufferedReader r = null;
        try {
            r = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = r.readLine()) != null) {
                sb.append(line);
                sb.append('\n');
            }
            r.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new GReTLParsingException(this.context, "Error while reading transformation...", e);
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Cannot close reader of " + file, e);
                }
            }
        }
        this.tokens = GReTLLexer.scan(sb.toString());
        this.current = 0;
        this.match(TokenTypes.TRANSFORMATION);
        this.setName(this.match((TokenTypes)TokenTypes.IDENT).value);
        this.match(TokenTypes.SEMICOLON);
    }

    public static ExecuteTransformation parseAndCreate(ExecuteTransformation et) {
        File f = new File(et.match((TokenTypes)TokenTypes.STRING).value);
        if (!f.isAbsolute()) {
            f = new File(et.file.getParent() + File.separator + f);
        }
        System.out.println(f.getAbsolutePath());
        return new ExecuteTransformation(et.context, f);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    protected Graph transform() {
        switch (this.context.getPhase()) {
            case SCHEMA: 
            case GRAPH: {
                this.interpretFile();
                break;
            }
            default: {
                throw new GReTLException(this.context, "Unknown TransformationPhase " + (Object)((Object)this.context.getPhase()) + "!");
            }
        }
        return this.context.getTargetGraph();
    }

    private void interpretFile() {
        this.current = 3;
        while (!this.tryMatch(TokenTypes.EOF)) {
            if (this.tryMatch(TokenTypes.GREQL_IMPORT)) {
                this.match(TokenTypes.GREQL_IMPORT);
                this.addGReQLImport(this.match((TokenTypes)TokenTypes.IDENT).value);
                this.match(TokenTypes.SEMICOLON);
                continue;
            }
            this.matchAndExecute();
        }
        this.match(TokenTypes.EOF);
    }

    private void matchAndExecute() {
        if (this.tryMatchTransformationDefinition()) {
            this.matchTransformationDefinition();
            return;
        }
        if (this.tryMatchTransformationCall()) {
            Transformation<?> t = this.matchTransformationCall();
            t.execute();
            return;
        }
        if (this.tryMatchHelperDefinition()) {
            Transformation<?> t = this.matchHelperDefinition();
            t.execute();
            return;
        }
        if (this.tryMatchVariableAssignment()) {
            Transformation<?> t = this.matchVariableAssignment();
            t.execute();
            return;
        }
        throw new GReTLParsingException(this.context, "Don't know how to parse " + this.tokens.get(this.current));
    }

    private Transformation<?> matchHelperDefinition() {
        final String helperName = this.match((TokenTypes)TokenTypes.IDENT).value;
        this.match(TokenTypes.PAREN_OPEN);
        this.match(TokenTypes.PAREN_CLOSE);
        this.match(TokenTypes.DEFINES);
        final String query = this.match((TokenTypes)TokenTypes.GREQL).value;
        this.match(TokenTypes.SEMICOLON);
        return new Transformation<Void>(this.context){

            @Override
            protected Void transform() {
                this.setGReQLHelper(helperName, query);
                return null;
            }
        };
    }

    private Transformation<?> matchVariableAssignment() {
        final String varName = this.match((TokenTypes)TokenTypes.IDENT).value;
        this.match(TokenTypes.DEFINES);
        final String query = this.match((TokenTypes)TokenTypes.GREQL).value;
        this.match(TokenTypes.SEMICOLON);
        return new Transformation<Void>(this.context){

            @Override
            protected Void transform() {
                this.setGReQLVariable(varName, query);
                return null;
            }
        };
    }

    public boolean tryMatchTransformationCall() {
        Token t = this.lookAhead(0);
        return t.type == TokenTypes.IDENT && knownTransformationClasses.containsKey(t.value);
    }

    private boolean tryMatchTransformationDefinition() {
        Token id = this.lookAhead(0);
        Token definesTransform = this.lookAhead(1);
        Token trans = this.lookAhead(2);
        return id.type == TokenTypes.IDENT && definesTransform.type == TokenTypes.DEFINES_TRANSFORMATION && trans.type == TokenTypes.IDENT && knownTransformationClasses.containsKey(trans.value);
    }

    private void matchTransformationDefinition() {
        String name = this.match((TokenTypes)TokenTypes.IDENT).value;
        this.match(TokenTypes.DEFINES_TRANSFORMATION);
        Transformation<?> t = this.matchTransformationCall();
        this.definedTransformations.put(name, t);
    }

    private boolean tryMatchHelperDefinition() {
        return this.lookAhead(3) != null && this.lookAhead((int)0).type == TokenTypes.IDENT && this.lookAhead((int)1).type == TokenTypes.PAREN_OPEN && this.lookAhead((int)2).type == TokenTypes.PAREN_CLOSE && this.lookAhead((int)3).type == TokenTypes.DEFINES;
    }

    private boolean tryMatchVariableAssignment() {
        return this.lookAhead((int)0).type == TokenTypes.IDENT && this.lookAhead((int)1).type == TokenTypes.DEFINES;
    }

    public Transformation<?> matchTransformationCall() {
        String transformName = this.match((TokenTypes)TokenTypes.IDENT).value;
        Method createMethod = knownTransformationClasses.get(transformName);
        if (createMethod == null) {
            throw new GReTLParsingException(this.context, "Unknown transformation class '" + transformName + "'.");
        }
        try {
            Transformation t = (Transformation)createMethod.invoke(null, this);
            this.match(TokenTypes.SEMICOLON);
            return t;
        }
        catch (Exception e) {
            throw new GReTLParsingException(this.context, "Could not match " + transformName + " at position " + this.lookAhead((int)0).start, e);
        }
    }

    public Domain matchDomain() {
        StringBuilder sb = new StringBuilder(this.match((TokenTypes)TokenTypes.IDENT).value);
        while (this.getParenBalance(sb.toString(), '<', '>') != 0) {
            if (this.tryMatch(TokenTypes.COMMA)) {
                sb.append(this.match((TokenTypes)TokenTypes.COMMA).value);
                sb.append(" ");
            }
            sb.append(this.match((TokenTypes)TokenTypes.IDENT).value);
        }
        return this.domain(sb.toString());
    }

    public String matchGraphAlias() {
        String alias = this.match((TokenTypes)TokenTypes.IDENT).value;
        if (alias.startsWith("#") && alias.endsWith("#")) {
            return alias.substring(1, alias.length() - 1);
        }
        throw new GReTLParsingException(this.context, "'" + alias + "' is no valid graph alias.");
    }

    public boolean tryMatchGraphAlias() {
        Token cur = this.lookAhead(0);
        return cur != null && cur.type == TokenTypes.IDENT && cur.value != null && cur.value.startsWith("#") && cur.value.endsWith("#");
    }

    private int getParenBalance(String s, char open, char close) {
        int b = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == open) {
                ++b;
                continue;
            }
            if (c != close) continue;
            --b;
        }
        return b;
    }

    public Attribute matchAttribute() {
        return this.attr(this.match((TokenTypes)TokenTypes.IDENT).value);
    }

    public Attribute[] matchAttributeArray() {
        LinkedList<Attribute> lst = new LinkedList<Attribute>();
        while (this.tryMatch(TokenTypes.IDENT)) {
            lst.add(this.matchAttribute());
            if (!this.tryMatch(TokenTypes.COMMA)) continue;
            this.match(TokenTypes.COMMA);
            if (this.tryMatch(TokenTypes.IDENT)) continue;
            this.match(TokenTypes.IDENT);
        }
        return lst.toArray(new Attribute[lst.size()]);
    }

    public GraphElementClass<?, ?> matchGraphElementClass() {
        return this.gec(this.match((TokenTypes)TokenTypes.IDENT).value);
    }

    public VertexClass matchVertexClass() {
        return this.vc(this.match((TokenTypes)TokenTypes.IDENT).value);
    }

    public EdgeClass matchEdgeClass() {
        return this.ec(this.match((TokenTypes)TokenTypes.IDENT).value);
    }

    public VertexClass[] matchVertexClassArray() {
        LinkedList<VertexClass> lst = new LinkedList<VertexClass>();
        while (this.tryMatch(TokenTypes.IDENT)) {
            lst.add(this.vc(this.match((TokenTypes)TokenTypes.IDENT).value));
        }
        return lst.toArray(new VertexClass[lst.size()]);
    }

    public EdgeClass[] matchEdgeClassArray() {
        LinkedList<EdgeClass> lst = new LinkedList<EdgeClass>();
        while (this.tryMatch(TokenTypes.IDENT)) {
            lst.add(this.ec(this.match((TokenTypes)TokenTypes.IDENT).value));
        }
        return lst.toArray(new EdgeClass[lst.size()]);
    }

    public RecordDomain.RecordComponent[] matchRecordComponentArray() {
        LinkedList<RecordDomain.RecordComponent> l = new LinkedList<RecordDomain.RecordComponent>();
        this.match(TokenTypes.PAREN_OPEN);
        while (this.tryMatch(TokenTypes.IDENT)) {
            String compName = this.match((TokenTypes)TokenTypes.IDENT).value;
            this.match(TokenTypes.COLON);
            String domName = this.match((TokenTypes)TokenTypes.IDENT).value;
            l.add(new RecordDomain.RecordComponent(compName, this.domain(domName)));
            if (this.tryMatch(TokenTypes.COMMA)) {
                this.match(TokenTypes.COMMA);
                if (this.tryMatch(TokenTypes.IDENT)) continue;
                this.match(TokenTypes.IDENT);
                continue;
            }
            if (this.tryMatch(TokenTypes.PAREN_CLOSE)) continue;
            this.match(TokenTypes.PAREN_CLOSE);
        }
        this.match(TokenTypes.PAREN_CLOSE);
        return l.toArray(new RecordDomain.RecordComponent[l.size()]);
    }

    public String[] matchIdentifierArray() {
        this.match(TokenTypes.PAREN_OPEN);
        LinkedList<String> strs = new LinkedList<String>();
        while (this.tryMatch(TokenTypes.IDENT)) {
            strs.add(this.match((TokenTypes)TokenTypes.IDENT).value);
            if (this.tryMatch(TokenTypes.COMMA)) {
                this.match(TokenTypes.COMMA);
                if (this.tryMatch(TokenTypes.IDENT)) continue;
                this.match(TokenTypes.IDENT);
                continue;
            }
            if (this.tryMatch(TokenTypes.PAREN_CLOSE)) continue;
            this.match(TokenTypes.PAREN_CLOSE);
        }
        this.match(TokenTypes.PAREN_CLOSE);
        return strs.toArray(new String[strs.size()]);
    }

    public CreateEdgeClass.IncidenceClassSpec matchIncidenceClassSpec() {
        if (this.tryMatch(TokenTypes.FROM)) {
            this.match();
        } else {
            this.match(TokenTypes.TO);
        }
        VertexClass vc = this.vc(this.match((TokenTypes)TokenTypes.IDENT).value);
        int min = -1;
        int max = -1;
        String role = "";
        AggregationKind kind = AggregationKind.NONE;
        if (this.tryMatch(TokenTypes.PAREN_OPEN)) {
            this.match();
            min = Integer.parseInt(this.match((TokenTypes)TokenTypes.IDENT).value);
            this.match(TokenTypes.COMMA);
            String maxStr = this.match((TokenTypes)TokenTypes.IDENT).value;
            max = maxStr.equals("*") ? Integer.MAX_VALUE : Integer.parseInt(maxStr);
            this.match(TokenTypes.PAREN_CLOSE);
        }
        if (this.tryMatch(TokenTypes.ROLE)) {
            this.match();
            role = this.match((TokenTypes)TokenTypes.IDENT).value;
        }
        if (this.tryMatch(TokenTypes.AGGREGATION)) {
            this.match();
            kind = AggregationKind.valueOf(this.match((TokenTypes)TokenTypes.IDENT).value.toUpperCase());
        }
        try {
            Constructor c = CreateEdgeClass.IncidenceClassSpec.class.getConstructor(VertexClass.class, Integer.TYPE, Integer.TYPE, String.class, AggregationKind.class);
            return (CreateEdgeClass.IncidenceClassSpec)c.newInstance(new Object[]{vc, min, max, role, kind});
        }
        catch (Exception e) {
            throw new GReTLParsingException(this.context, "Exception while instantiating an IncidenceClassSpec.", e);
        }
    }

    public String matchQualifiedName() {
        return this.match((TokenTypes)TokenTypes.IDENT).value;
    }

    public void matchTransformationArrow() {
        this.match(TokenTypes.TRANSFORM_ARROW);
    }

    public String matchSemanticExpression() {
        return this.match((TokenTypes)TokenTypes.GREQL).value;
    }

    public CreateAttribute.AttributeSpec matchAttributeSpec() {
        String qName = this.match((TokenTypes)TokenTypes.IDENT).value;
        this.match(TokenTypes.COLON);
        String domain = this.matchDomain().getQualifiedName();
        String defaultValue = null;
        if (this.tryMatch(TokenTypes.ASSIGN)) {
            this.match(TokenTypes.ASSIGN);
            defaultValue = this.match((TokenTypes)TokenTypes.STRING).value;
        }
        try {
            Constructor c = CreateAttribute.AttributeSpec.class.getConstructor(AttributedElementClass.class, String.class, Domain.class, String.class);
            int lastDot = qName.lastIndexOf(46);
            String className = qName.substring(0, lastDot);
            AttributedElementClass<?, ?> aec = this.aec(className);
            if (aec == null) {
                throw new GReTLParsingException(this.context, "There's no AttributedElementClass '" + className + "'.");
            }
            String attrName = qName.substring(lastDot + 1);
            return (CreateAttribute.AttributeSpec)c.newInstance(aec, attrName, this.domain(domain), defaultValue);
        }
        catch (Exception e) {
            throw new GReTLParsingException(this.context, "Exception while instantiating an IncidenceClassSpec.", e);
        }
    }

    public CreateAttribute.AttributeSpec[] matchAttributeSpecArray() {
        LinkedList<CreateAttribute.AttributeSpec> l = new LinkedList<CreateAttribute.AttributeSpec>();
        boolean first = true;
        do {
            if (first) {
                first = false;
            } else {
                this.match(TokenTypes.COMMA);
            }
            l.add(this.matchAttributeSpec());
        } while (this.tryMatch(TokenTypes.COMMA));
        return l.toArray(new CreateAttribute.AttributeSpec[l.size()]);
    }

    public final Token match(TokenTypes type) {
        if (this.lookAhead((int)0).type == type) {
            return this.match();
        }
        StringBuilder sb = new StringBuilder();
        for (int i = -5; i < 6; ++i) {
            Token t = this.lookAhead(i);
            if (t == null) continue;
            if (i == 0) {
                sb.append("\u00bb");
                sb.append(t.value);
                sb.append("\u00ab");
            } else {
                sb.append(t.value);
            }
            sb.append(" ");
        }
        throw new GReTLParsingException(this.context, "Expected " + (Object)((Object)type) + " but got " + (Object)((Object)this.tokens.get((int)this.current).type) + " while parsing: " + sb.toString());
    }

    public final Token match() {
        return this.tokens.get(this.current++);
    }

    public final boolean tryMatch(TokenTypes type) {
        return this.lookAhead((int)0).type == type;
    }

    public final Token lookAhead(int i) {
        int idx = this.current + i;
        if (idx >= 0 && idx < this.tokens.size()) {
            return this.tokens.get(idx);
        }
        return null;
    }

    public Transformation<?> getDefinedTransformation(String name) {
        Transformation<?> t = this.definedTransformations.get(name);
        if (t == null) {
            throw new GReTLParsingException(this.context, "No '" + name + "' Transformation defined!");
        }
        return t;
    }

    static {
        ExecuteTransformation.registerTransformation(AddMappings.class);
        ExecuteTransformation.registerTransformation(AddSourceGraph.class);
        ExecuteTransformation.registerTransformation(AddSubClass.class);
        ExecuteTransformation.registerTransformation(AddSubClasses.class);
        ExecuteTransformation.registerTransformation(AddSuperClass.class);
        ExecuteTransformation.registerTransformation(AddSuperClasses.class);
        ExecuteTransformation.registerTransformation(Assert.class);
        ExecuteTransformation.registerTransformation(ExecuteTransformation.class);
        ExecuteTransformation.registerTransformation(Call.class);
        ExecuteTransformation.registerTransformation(CopyDomain.class);
        ExecuteTransformation.registerTransformation(CopyEdgeClass.class);
        ExecuteTransformation.registerTransformation(CopyVertexClass.class);
        ExecuteTransformation.registerTransformation(CreateAbstractEdgeClass.class);
        ExecuteTransformation.registerTransformation(CreateAbstractVertexClass.class);
        ExecuteTransformation.registerTransformation(CreateAttribute.class);
        ExecuteTransformation.registerTransformation(CreateAttributes.class);
        ExecuteTransformation.registerTransformation(CreateEdgeClass.class);
        ExecuteTransformation.registerTransformation(CreateEdges.class);
        ExecuteTransformation.registerTransformation(CreateEnumDomain.class);
        ExecuteTransformation.registerTransformation(CreateListDomain.class);
        ExecuteTransformation.registerTransformation(CreateMapDomain.class);
        ExecuteTransformation.registerTransformation(CreateVertexClassDisjoint.class);
        ExecuteTransformation.registerTransformation(CreateRecordDomain.class);
        ExecuteTransformation.registerTransformation(CreateSetDomain.class);
        ExecuteTransformation.registerTransformation(CreateSubgraph.class);
        ExecuteTransformation.registerTransformation(CreateVertexClass.class);
        ExecuteTransformation.registerTransformation(CreateVertices.class);
        ExecuteTransformation.registerTransformation(Delete.class);
        ExecuteTransformation.registerTransformation(Iteratively.class);
        ExecuteTransformation.registerTransformation(MatchReplace.class);
        ExecuteTransformation.registerTransformation(MergeVertices.class);
        ExecuteTransformation.registerTransformation(NTimes.class);
        ExecuteTransformation.registerTransformation(PrintGraph.class);
        ExecuteTransformation.registerTransformation(SetAttributes.class);
        ExecuteTransformation.registerTransformation(SetMultipleAttributes.class);
        ExecuteTransformation.registerTransformation(SysErr.class);
        ExecuteTransformation.registerTransformation(SysOut.class);
    }
}

